/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static boolean loaded;
    static boolean swingInitialized;

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }

    static final native long getAWTHandle(Canvas var0);

    static final native Object initFrame(long var0, String var2);

    static final native void synthesizeWindowActivation(Frame var0, boolean var1);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        Toolkit.getDefaultToolkit();
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {}
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", new Class[0]);
            if (method != null) {
                method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {}
    }

    public static Frame getFrame(Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)parent.getData(EMBEDDED_FRAME_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Frame new_Frame(Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        long handle = parent.handle;
        Frame[] result2 = new Frame[1];
        Throwable[] exception = new Throwable[1];
        Runnable runnable = () -> {
            Object value;
            block20: {
                String className;
                try {
                    className = embeddedFrameClass != null ? embeddedFrameClass : "sun.awt.windows.WEmbeddedFrame";
                    try {
                        if (embeddedFrameClass != null) {
                            Class.forName(className);
                        }
                        SWT_AWT.loadLibrary();
                    }
                    catch (ClassNotFoundException cne) {
                        SWT.error(20, cne);
                    }
                    catch (Throwable e2) {
                        throwableArray[0] = e2;
                        Frame[] frameArray2 = result2;
                        synchronized (result2) {
                            result2.notify();
                            // ** MonitorExit[var7_7] (shouldn't be in output)
                            return;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Frame[] frameArray3 = result2;
                    synchronized (result2) {
                        result2.notify();
                        // ** MonitorExit[var7_9] (shouldn't be in output)
                        throw throwable;
                    }
                }
                SWT_AWT.initializeSwing();
                value = SWT_AWT.initFrame(handle, className);
                if (value != null && value instanceof Frame) break block20;
                throwableArray[0] = new Throwable("[Error while creating AWT embedded frame]");
                SWT.error(1, exception[0]);
                Frame[] frameArray4 = result2;
                synchronized (result2) {
                    result2.notify();
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                    return;
                }
            }
            frameArray[0] = (Frame)value;
            Frame[] frameArray5 = result2;
            synchronized (result2) {
                result2.notify();
                // ** MonitorExit[var7_10] (shouldn't be in output)
                return;
            }
        };
        if (EventQueue.isDispatchThread() || parent.getDisplay().getSyncThread() != null) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
            OS.ReplyMessage(0L);
            boolean interrupted = false;
            MSG msg = new MSG();
            int flags = 0x400002;
            while (result2[0] == null && exception[0] == null) {
                OS.PeekMessage(msg, 0L, 0, 0, flags);
                try {
                    Frame[] frameArray = result2;
                    // MONITORENTER : result2
                    result2.wait(50L);
                    // MONITOREXIT : frameArray
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (exception[0] != null) {
            SWT.error(20, exception[0]);
        }
        Frame frame = result2[0];
        parent.setData(EMBEDDED_FRAME_KEY, frame);
        Listener shellListener = e2 -> {
            switch (e2.type) {
                case 20: {
                    EventQueue.invokeLater(() -> frame.dispatchEvent(new WindowEvent(frame, 204)));
                    break;
                }
                case 19: {
                    EventQueue.invokeLater(() -> frame.dispatchEvent(new WindowEvent(frame, 203)));
                }
            }
        };
        Shell shell = parent.getShell();
        shell.addListener(20, shellListener);
        shell.addListener(19, shellListener);
        Listener listener2 = e2 -> {
            switch (e2.type) {
                case 12: {
                    Shell shell1 = parent.getShell();
                    shell1.removeListener(20, shellListener);
                    shell1.removeListener(19, shellListener);
                    parent.setVisible(false);
                    EventQueue.invokeLater(() -> {
                        try {
                            frame.dispose();
                        }
                        catch (Throwable throwable) {}
                    });
                    break;
                }
                case 15: 
                case 26: {
                    EventQueue.invokeLater(() -> {
                        if (frame.isActive()) {
                            return;
                        }
                        try {
                            Class<?> clazz = frame.getClass();
                            Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                            if (method != null) {
                                method.invoke((Object)frame, Boolean.TRUE);
                            }
                        }
                        catch (Throwable throwable) {}
                    });
                    break;
                }
                case 27: {
                    EventQueue.invokeLater(() -> {
                        if (!frame.isActive()) {
                            return;
                        }
                        try {
                            Class<?> clazz = frame.getClass();
                            Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                            if (method != null) {
                                method.invoke((Object)frame, Boolean.FALSE);
                            }
                        }
                        catch (Throwable throwable) {}
                    });
                }
            }
        };
        parent.addListener(15, listener2);
        parent.addListener(27, listener2);
        parent.addListener(12, listener2);
        parent.getDisplay().asyncExec(() -> {
            if (parent.isDisposed()) {
                return;
            }
            Rectangle clientArea = DPIUtil.autoScaleUp(parent.getClientArea());
            EventQueue.invokeLater(() -> {
                frame.setSize(rectangle2.width, rectangle2.height);
                frame.validate();
            });
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas parent) {
        if (display == null) {
            SWT.error(4);
        }
        if (parent == null) {
            SWT.error(4);
        }
        long handle = 0L;
        try {
            SWT_AWT.loadLibrary();
            handle = SWT_AWT.getAWTHandle(parent);
        }
        catch (Throwable e2) {
            SWT.error(20, e2);
        }
        if (handle == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.win32_new(display, handle);
        ComponentAdapter listener2 = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                display.syncExec(() -> {
                    if (shell.isDisposed()) {
                        return;
                    }
                    Dimension dim = parent.getSize();
                    shell.setSize(DPIUtil.autoScaleDown(new Point(dim.width, dim.height)));
                });
            }
        };
        parent.addComponentListener(listener2);
        shell.addListener(12, event -> parent.removeComponentListener(listener2));
        shell.setVisible(true);
        return shell;
    }
}

