/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.polynomials;

import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.MathUtils;

public class PolynomialFunctionNewtonForm
implements UnivariateDifferentiableFunction {
    private double[] coefficients;
    private final double[] c;
    private final double[] a;
    private boolean coefficientsComputed;

    public PolynomialFunctionNewtonForm(double[] a2, double[] c2) throws NullArgumentException, NoDataException, DimensionMismatchException {
        PolynomialFunctionNewtonForm.verifyInputArray(a2, c2);
        this.a = new double[a2.length];
        this.c = new double[c2.length];
        System.arraycopy(a2, 0, this.a, 0, a2.length);
        System.arraycopy(c2, 0, this.c, 0, c2.length);
        this.coefficientsComputed = false;
    }

    public double value(double z2) {
        return PolynomialFunctionNewtonForm.evaluate(this.a, this.c, z2);
    }

    public DerivativeStructure value(DerivativeStructure t2) {
        PolynomialFunctionNewtonForm.verifyInputArray(this.a, this.c);
        int n2 = this.c.length;
        DerivativeStructure value = new DerivativeStructure(t2.getFreeParameters(), t2.getOrder(), this.a[n2]);
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            value = t2.subtract(this.c[i2]).multiply(value).add(this.a[i2]);
        }
        return value;
    }

    public int degree() {
        return this.c.length;
    }

    public double[] getNewtonCoefficients() {
        double[] out = new double[this.a.length];
        System.arraycopy(this.a, 0, out, 0, this.a.length);
        return out;
    }

    public double[] getCenters() {
        double[] out = new double[this.c.length];
        System.arraycopy(this.c, 0, out, 0, this.c.length);
        return out;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    public static double evaluate(double[] a2, double[] c2, double z2) throws NullArgumentException, DimensionMismatchException, NoDataException {
        PolynomialFunctionNewtonForm.verifyInputArray(a2, c2);
        int n2 = c2.length;
        double value = a2[n2];
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            value = a2[i2] + (z2 - c2[i2]) * value;
        }
        return value;
    }

    protected void computeCoefficients() {
        int i2;
        int n2 = this.degree();
        this.coefficients = new double[n2 + 1];
        for (i2 = 0; i2 <= n2; ++i2) {
            this.coefficients[i2] = 0.0;
        }
        this.coefficients[0] = this.a[n2];
        for (i2 = n2 - 1; i2 >= 0; --i2) {
            for (int j2 = n2 - i2; j2 > 0; --j2) {
                this.coefficients[j2] = this.coefficients[j2 - 1] - this.c[i2] * this.coefficients[j2];
            }
            this.coefficients[0] = this.a[i2] - this.c[i2] * this.coefficients[0];
        }
        this.coefficientsComputed = true;
    }

    protected static void verifyInputArray(double[] a2, double[] c2) throws NullArgumentException, NoDataException, DimensionMismatchException {
        MathUtils.checkNotNull(a2);
        MathUtils.checkNotNull(c2);
        if (a2.length == 0 || c2.length == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        if (a2.length != c2.length + 1) {
            throw new DimensionMismatchException((Localizable)LocalizedFormats.ARRAY_SIZES_SHOULD_HAVE_DIFFERENCE_1, a2.length, c2.length);
        }
    }
}

