/*
 * Decompiled with CFR 0.152.
 */
package gde.device.jeti;

import cz.vutbr.fit.gja.proj.utils.TelemetryData;
import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementType;
import gde.device.jeti.JetiAdapter;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.exception.NotSupportedFileFormatException;
import gde.io.CSVSerialDataReaderWriter;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.TimeLine;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;

public class JetiDataReader {
    static Logger log = Logger.getLogger(CSVSerialDataReaderWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;

    /*
     * WARNING - void declaration
     */
    public static RecordSet read(String filePath, JetiAdapter device, String recordNameExtend, Integer channelConfigNumber, boolean isRaw) throws NotSupportedFileFormatException, IOException, DataInconsitsentException, DataTypeException {
        RecordSet recordSet;
        block65: {
            recordSet = null;
            Channel activeChannel = null;
            String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new File(filePath).lastModified());
            boolean isOutdated = false;
            boolean isStartIndexGPS = false;
            boolean isActualTime = false;
            boolean isActualDate = false;
            int ordinalTimeRecord = -1;
            int ordinalDateRecord = -1;
            int lineNumber = 0;
            int activeChannelConfigNumber = 1;
            Object recordSetNameExtend = device.getRecordSetStemNameReplacement();
            double time_ms = 0.0;
            double timeStep_ms = 0.0;
            try {
                activeChannel = channelConfigNumber == null ? channels.getActiveChannel() : (Channel)channels.get((Object)channelConfigNumber);
                if (activeChannel == null) break block65;
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0594") + filePath);
                GDE.getUiNotification().setProgress(0);
                activeChannelConfigNumber = activeChannel.getNumber();
                if (GDE.isWithUi()) {
                    channels.switchChannel(activeChannel.getNumber(), "");
                    application.getMenuToolBar().updateChannelSelector();
                    activeChannel = channels.getActiveChannel();
                }
                Object recordSetName = activeChannel.size() + 1 + ") " + (String)recordSetNameExtend;
                int measurementSize = device.getNumberOfMeasurements(activeChannelConfigNumber);
                int dataBlockSize = device.getDataBlockSize(InputTypes.FILE_IO);
                log.log(Level.FINE, "measurementSize = " + measurementSize + "; dataBlockSize = " + dataBlockSize);
                if (measurementSize < Math.abs(dataBlockSize)) {
                    throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0041", (Object[])new String[]{filePath}));
                }
                StringBuilder reverseChannelStatistics = new StringBuilder();
                TelemetryData data = new TelemetryData();
                if (!data.loadData(filePath)) break block65;
                TreeSet<TelemetryData.TelemetrySensor> recordSetData = data.getData();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Modell name = " + data.getModelName());
                }
                if (application.getMenuBar() != null) {
                    device.matchModelNameObjectKey(data.getModelName());
                }
                int numValues = 0;
                HashMap<Integer, Integer> valuesMap = new HashMap<Integer, Integer>();
                for (TelemetryData.TelemetrySensor telemetrySensor : recordSetData) {
                    if (telemetrySensor.getId() == 0L) continue;
                    boolean isTimeStepEvaluated = false;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, telemetrySensor.getName() + " -  length " + telemetrySensor.getName().length());
                    }
                    for (TelemetryData.TelemetryVar telemetryVar : telemetrySensor.getVariables()) {
                        int dataItemsSize = telemetryVar.getItems().size();
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, telemetryVar.getName() + " data items size = " + dataItemsSize);
                        }
                        if (telemetryVar.getItems().size() > 3) {
                            if (!isTimeStepEvaluated && telemetryVar.getTimeSteps().size() > 0) {
                                int nameLength = telemetrySensor.getName().length();
                                if (nameLength <= 5) {
                                    reverseChannelStatistics.append(String.format(Locale.getDefault(), "%-8s\t\tmin %.3fsec avg %.3fsec max %.3fsec at %s", telemetrySensor.getName(), (double)telemetryVar.getTimeSteps().getMinValue() / 1000.0, (double)telemetryVar.getTimeSteps().getAvgValue() / 1000.0, (double)telemetryVar.getTimeSteps().getMaxValue() / 1000.0, TimeLine.getFomatedTimeWithUnit((double)telemetryVar.getTimeSteps().getMaxValueTimeStamp()))).append('\n');
                                } else {
                                    reverseChannelStatistics.append(String.format(Locale.getDefault(), "%-8s\tmin %.3fsec avg %.3fsec max %.3fsec at %s", telemetrySensor.getName(), (double)telemetryVar.getTimeSteps().getMinValue() / 1000.0, (double)telemetryVar.getTimeSteps().getAvgValue() / 1000.0, (double)telemetryVar.getTimeSteps().getMaxValue() / 1000.0, TimeLine.getFomatedTimeWithUnit((double)telemetryVar.getTimeSteps().getMaxValueTimeStamp()))).append('\n');
                                }
                                if (log.isLoggable(Level.INFO)) {
                                    log.log(Level.INFO, String.format(Locale.getDefault(), "%10s: min %.3fsec avg %.3fsec max %.3fsec at %s", telemetrySensor.getName(), (double)telemetryVar.getTimeSteps().getMinValue() / 1000.0, (double)telemetryVar.getTimeSteps().getAvgValue() / 1000.0, (double)telemetryVar.getTimeSteps().getMaxValue() / 1000.0, TimeLine.getFomatedTimeWithUnit((double)telemetryVar.getTimeSteps().getMaxValueTimeStamp())));
                                }
                                isTimeStepEvaluated = true;
                            }
                            valuesMap.put(dataItemsSize, 1);
                        }
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, String.format("%10s [%s]", telemetryVar.getName(), telemetryVar.getUnit()));
                    }
                }
                Object[] occurrence = valuesMap.values().toArray(new Integer[1]);
                Arrays.sort(occurrence);
                for (Integer key : valuesMap.keySet()) {
                    if (valuesMap.get(key) != occurrence[occurrence.length - 1]) continue;
                    numValues = key;
                    break;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "best fit # values = " + numValues);
                }
                timeStep_ms = data.getMaxTimestamp() * 1000.0 / (double)numValues;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("best fit timeStep_ms = %.1f", timeStep_ms));
                }
                try {
                    recordSetNameExtend = device.getRecordSetStateNameReplacement(1);
                    if (recordNameExtend.length() > 0) {
                        recordSetNameExtend = (String)recordSetNameExtend + " [" + recordNameExtend + "]";
                    }
                }
                catch (Exception exception) {
                    throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0044", (Object[])new Object[]{1, filePath, device.getPropertiesFileName()}));
                }
                recordSetName = activeChannel.size() + 1 + ") " + (String)recordSetNameExtend;
                boolean bl = false;
                Vector<String> vecRecordNames = new Vector<String>();
                HashMap<Integer, Record.DataType> mapRecordType = new HashMap<Integer, Record.DataType>();
                for (TelemetryData.TelemetrySensor telemetrySensor : recordSetData) {
                    if (telemetrySensor.getId() == 0L) continue;
                    boolean isActualgps = false;
                    for (TelemetryData.TelemetryVar dataVar : telemetrySensor.getVariables()) {
                        void var30_34;
                        String newRecordName = dataVar.getName().trim();
                        if (telemetrySensor.getName().startsWith("Rx")) {
                            newRecordName = String.format("%s %s", newRecordName.split(" Rx")[0], telemetrySensor.getName());
                        }
                        while (vecRecordNames.contains(newRecordName)) {
                            newRecordName = String.format("%s %s", newRecordName, telemetrySensor.getName());
                        }
                        vecRecordNames.add(newRecordName);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, String.format("add new record = %s [%s]", newRecordName, dataVar.getUnit()));
                        }
                        device.setMeasurementName(activeChannelConfigNumber, (int)var30_34, dataVar.getName());
                        device.setMeasurementUnit(activeChannelConfigNumber, (int)var30_34, dataVar.getUnit());
                        if (dataVar.getType() == 9 && (dataVar.getDecimals() & 1) == 0) {
                            isActualgps = true;
                            mapRecordType.put((int)var30_34, Record.DataType.GPS_LATITUDE);
                        } else if (dataVar.getType() == 9 && (dataVar.getDecimals() & 1) == 1) {
                            isActualgps = true;
                            mapRecordType.put((int)var30_34, Record.DataType.GPS_LONGITUDE);
                        } else if (dataVar.getType() == 5 && (dataVar.getDecimals() & 1) == 0) {
                            mapRecordType.put((int)var30_34, Record.DataType.GPS_TIME);
                            isActualTime = true;
                            ordinalTimeRecord = var30_34;
                        } else if (dataVar.getType() == 5 && (dataVar.getDecimals() & 1) == 1) {
                            mapRecordType.put((int)var30_34, Record.DataType.DATE_TIME);
                            isActualDate = true;
                            ordinalDateRecord = var30_34;
                        } else if (isActualgps && dataVar.getUnit().contains("\u00b0") && dataVar.getParam() == 10) {
                            mapRecordType.put((int)var30_34, Record.DataType.GPS_AZIMUTH);
                        } else if ((dataVar.getName().toLowerCase().contains("hoehe") || dataVar.getName().toLowerCase().contains("h\u00f6he") || dataVar.getName().toLowerCase().contains("height") || dataVar.getName().toLowerCase().contains("alt")) && dataVar.getUnit().equals("m")) {
                            mapRecordType.put((int)var30_34, Record.DataType.GPS_ALTITUDE);
                        } else if ((dataVar.getName().toLowerCase().contains("speed") || dataVar.getName().toLowerCase().contains("geschw")) && (dataVar.getUnit().equals("km/h") || dataVar.getUnit().equals("kmh") || dataVar.getUnit().equals("kph") || dataVar.getUnit().equals("m/s"))) {
                            mapRecordType.put((int)var30_34, Record.DataType.GPS_SPEED);
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "param = " + dataVar.getParam());
                        }
                        ++var30_34;
                    }
                }
                for (TelemetryData.TelemetrySensor telemetrySensor : recordSetData) {
                    if (telemetrySensor.getId() != 0L) continue;
                    for (TelemetryData.TelemetryVar dataVar : telemetrySensor.getVariables()) {
                        void var30_35;
                        Object newRecordName = dataVar.getName().trim();
                        while (vecRecordNames.contains(newRecordName)) {
                            newRecordName = (String)newRecordName + "'";
                        }
                        vecRecordNames.add((String)newRecordName);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "add new record name = " + (String)newRecordName);
                        }
                        device.setMeasurementName(activeChannelConfigNumber, (int)var30_35, dataVar.getName());
                        device.setMeasurementUnit(activeChannelConfigNumber, (int)var30_35, dataVar.getUnit());
                        ++var30_35;
                    }
                }
                String[] stringArray = vecRecordNames.toArray(new String[0]);
                String[] recordSymbols = new String[stringArray.length];
                String[] recordUnits = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    MeasurementType measurement = device.getMeasurement(activeChannelConfigNumber, i);
                    recordSymbols[i] = measurement.getSymbol();
                    recordUnits[i] = measurement.getUnit();
                }
                recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)activeChannelConfigNumber, (String[])stringArray, (String[])recordSymbols, (String[])recordUnits, (double)device.getTimeStep_ms(), (boolean)isRaw, (boolean)true, (boolean)true);
                for (Map.Entry entry : mapRecordType.entrySet()) {
                    recordSet.get(((Integer)entry.getKey()).intValue()).setDataType((Record.DataType)entry.getValue());
                }
                recordSetName = recordSet.getName();
                try {
                    isOutdated = Integer.parseInt(dateTime.split("-")[0]) <= 2000;
                }
                catch (Exception i) {
                    // empty catch block
                }
                activeChannel.put(recordSetName, (Object)recordSet);
                boolean bl2 = false;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, device.getNumberOfMeasurements(activeChannelConfigNumber) + " - " + recordSet.size());
                }
                int[] points = new int[stringArray.length];
                for (int i = 0; i < numValues; ++i) {
                    for (TelemetryData.TelemetrySensor telemetrySensor : recordSetData) {
                        if (telemetrySensor.getId() == 0L) continue;
                        for (TelemetryData.TelemetryVar dataVar : telemetrySensor.getVariables()) {
                            if (dataVar.getType() == 9 && (isStartIndexGPS || (isStartIndexGPS = dataVar.getNextIntFrom(time_ms) > 0))) {
                                points[n++] = (int)(dataVar.getDoubleAt(time_ms) * 1000000.0);
                                continue;
                            }
                            points[n++] = dataVar.getIntValueAt(time_ms);
                        }
                    }
                    for (TelemetryData.TelemetrySensor telemetrySensor : recordSetData) {
                        if (telemetrySensor.getId() != 0L) continue;
                        for (TelemetryData.TelemetryVar dataVar : telemetrySensor.getVariables()) {
                            points[n++] = dataVar.getIntValueAt(time_ms);
                        }
                    }
                    recordSet.addPoints(points, time_ms);
                    time_ms += timeStep_ms;
                    int n = 0;
                }
                GDE.getUiNotification().setProgress(100);
                activeChannel.setActiveRecordSet((String)recordSetName);
                activeChannel.applyTemplate((String)recordSetName, true);
                device.updateVisibilityStatus((RecordSet)activeChannel.get(recordSetName), true);
                if (!isOutdated) {
                    GregorianCalendar cal;
                    long startTimeStamp = (long)((double)new File(filePath).lastModified() - ((RecordSet)activeChannel.get(recordSetName)).getMaxTime_ms());
                    if (isActualTime && ordinalTimeRecord >= 0 && ((RecordSet)activeChannel.get(recordSetName)).get(ordinalTimeRecord).size() > 1 && ((RecordSet)activeChannel.get(recordSetName)).get(ordinalTimeRecord).get(0) != 0) {
                        int timeValue = ((RecordSet)activeChannel.get(recordSetName)).get(ordinalTimeRecord).get(0) / 1000;
                        int tmpHH = timeValue / 10000;
                        int tmpMM = timeValue / 100 - tmpHH * 100;
                        int tmpSS = timeValue - tmpMM * 100 - tmpHH * 10000;
                        cal = new GregorianCalendar();
                        cal.setTimeInMillis(startTimeStamp);
                        cal.set(11, tmpHH);
                        cal.set(12, tmpMM);
                        cal.set(13, tmpSS);
                        startTimeStamp = cal.getTimeInMillis();
                    }
                    if (isActualDate && ordinalDateRecord >= 0 && ((RecordSet)activeChannel.get(recordSetName)).get(ordinalDateRecord).size() > 11 && ((RecordSet)activeChannel.get(recordSetName)).get(ordinalDateRecord).get(0) != 0) {
                        int dateValue = ((RecordSet)activeChannel.get(recordSetName)).get(ordinalDateRecord).get(10) / 1000;
                        int tmpYY = dateValue / 10000;
                        int tmpMM = dateValue / 100 - tmpYY * 100;
                        int tmpDD = dateValue - tmpMM * 100 - tmpYY * 10000;
                        cal = new GregorianCalendar();
                        cal.setTimeInMillis(startTimeStamp);
                        cal.set(1, tmpYY + 2000);
                        cal.set(2, tmpMM - 1);
                        cal.set(5, tmpDD);
                        startTimeStamp = cal.getTimeInMillis();
                    }
                    ((RecordSet)activeChannel.get(recordSetName)).setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                    ((RecordSet)activeChannel.get(recordSetName)).setStartTimeStamp(startTimeStamp);
                    activeChannel.setFileDescription(dateTime.substring(0, 10) + activeChannel.getFileDescription().substring(10));
                } else {
                    ((RecordSet)activeChannel.get(recordSetName)).setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new Date()));
                }
                if (reverseChannelStatistics.length() > 3) {
                    reverseChannelStatistics.deleteCharAt(reverseChannelStatistics.length() - 1);
                }
                ((RecordSet)activeChannel.get(recordSetName)).descriptionAppendFilename(filePath.substring(filePath.lastIndexOf(47) + 1));
                if (data.getModelName().length() > 2) {
                    ((RecordSet)activeChannel.get(recordSetName)).setRecordSetDescription(Messages.getString((String)"GDE_MSGT2914", (Object[])new String[]{((RecordSet)activeChannel.get(recordSetName)).getRecordSetDescription(), data.getModelName()}));
                }
                for (String statistics : reverseChannelStatistics.toString().split("\n")) {
                    ((RecordSet)activeChannel.get(recordSetName)).setRecordSetDescription(((RecordSet)activeChannel.get(recordSetName)).getRecordSetDescription() + Messages.getString((String)"GDE_MSGT2915", (Object[])new String[]{"\n", statistics}));
                }
                ((RecordSet)activeChannel.get(recordSetName)).checkAllDisplayable();
                ((RecordSet)activeChannel.get(recordSetName)).updateVisibleAndDisplayableRecordsForTable();
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet((String)recordSetName);
                }
            }
            catch (Exception e) {
                if (activeChannel != null && activeChannel.size() > 0) {
                    String recordSetName = activeChannel.getFirstRecordSetName();
                    activeChannel.setActiveRecordSet(recordSetName);
                    device.updateVisibilityStatus((RecordSet)activeChannel.get((Object)recordSetName), true);
                    ((RecordSet)activeChannel.get((Object)recordSetName)).checkAllDisplayable();
                    if (GDE.isWithUi()) {
                        activeChannel.switchRecordSet(recordSetName);
                    }
                }
                String msg = filePath + " - " + Messages.getString((String)"GDE_MSGE0045", (Object[])new Object[]{e.getMessage(), lineNumber});
                log.log(Level.WARNING, msg, e);
                application.openMessageDialog(msg);
            }
        }
        return recordSet;
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
    }
}

