/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IMLangFontLink2;
import org.eclipse.swt.internal.win32.EMR;
import org.eclipse.swt.internal.win32.EMREXTCREATEFONTINDIRECTW;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRIC;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacingInPoints = 0;
    int ascentInPixels = -1;
    int descentInPixels = -1;
    int alignment;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int textDirection = 0x2000000;
    int indent;
    int wrapIndent;
    boolean justify;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    IMLangFontLink2 mLangFontLink2;
    int verticalIndentInPoints = 0;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final int MERGE_MAX = 512;
    static final int TOO_MANY_RUNS = 1024;
    static final int UNDERLINE_IME_DOT = 65536;
    static final int UNDERLINE_IME_DASH = 131072;
    static final int UNDERLINE_IME_THICK = 196608;

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.text = "";
        long[] ppv = new long[1];
        OS.OleInitialize(0L);
        if (COM.CoCreateInstance(COM.CLSID_CMultiLanguage, 0L, 1, COM.IID_IMLangFontLink2, ppv) == 0) {
            this.mLangFontLink2 = new IMLangFontLink2(ppv[0]);
        }
        this.init();
    }

    RECT addClipRect(StyleItem run2, RECT clipRect, RECT rect, int selectionStart, int selectionEnd) {
        if (rect != null) {
            boolean isRTL;
            if (clipRect == null) {
                clipRect = new RECT();
                OS.SetRect(clipRect, -1, rect.top, -1, rect.bottom);
            }
            boolean bl = isRTL = (this.orientation & 0x4000000) != 0;
            if (run2.start <= selectionStart && selectionStart <= run2.start + run2.length) {
                if (run2.analysis.fRTL ^ isRTL) {
                    clipRect.right = rect.left;
                } else {
                    clipRect.left = rect.left;
                }
            }
            if (run2.start <= selectionEnd && selectionEnd <= run2.start + run2.length) {
                if (run2.analysis.fRTL ^ isRTL) {
                    clipRect.left = rect.right;
                } else {
                    clipRect.right = rect.right;
                }
            }
        }
        return clipRect;
    }

    void breakRun(StyleItem run2) {
        if (run2.psla != 0L) {
            return;
        }
        char[] chars = new char[run2.length];
        this.segmentsText.getChars(run2.start, run2.start + run2.length, chars, 0);
        long hHeap = OS.GetProcessHeap();
        run2.psla = OS.HeapAlloc(hHeap, 8, SCRIPT_LOGATTR.sizeof * chars.length);
        if (run2.psla == 0L) {
            SWT.error(2);
        }
        OS.ScriptBreak(chars, chars.length, run2.analysis, run2.psla);
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gc) {
        if (this.runs != null) {
            return;
        }
        long hDC = gc != null ? gc.handle : this.device.internal_new_GC(null);
        long srcHdc = OS.CreateCompatibleDC(hDC);
        this.allRuns = this.itemize();
        int i2 = 0;
        while (i2 < this.allRuns.length - 1) {
            StyleItem run2 = this.allRuns[i2];
            OS.SelectObject(srcHdc, this.getItemFont(run2));
            this.shape(srcHdc, run2);
            ++i2;
        }
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties2 = new SCRIPT_PROPERTIES();
        int lineWidth = this.indent;
        int lineStart = 0;
        int lineCount = 1;
        int i3 = 0;
        while (i3 < this.allRuns.length - 1) {
            StyleItem run3 = this.allRuns[i3];
            if (this.tabs != null && run3.tab) {
                int length;
                int tabsLength = this.tabs.length;
                int j2 = 0;
                while (j2 < tabsLength) {
                    if (this.tabs[j2] > lineWidth) {
                        run3.width = this.tabs[j2] - lineWidth;
                        break;
                    }
                    ++j2;
                }
                if (j2 == tabsLength) {
                    int lastTabWidth;
                    int tabX = this.tabs[tabsLength - 1];
                    int n2 = lastTabWidth = tabsLength > 1 ? this.tabs[tabsLength - 1] - this.tabs[tabsLength - 2] : this.tabs[0];
                    if (lastTabWidth > 0) {
                        while (tabX <= lineWidth) {
                            tabX += lastTabWidth;
                        }
                        run3.width = tabX - lineWidth;
                    }
                }
                if ((length = run3.length) > 1) {
                    int stop2 = j2 + length - 1;
                    if (stop2 < tabsLength) {
                        run3.width += this.tabs[stop2] - this.tabs[j2];
                    } else {
                        if (j2 < tabsLength) {
                            run3.width += this.tabs[tabsLength - 1] - this.tabs[j2];
                            length -= tabsLength - 1 - j2;
                        }
                        int lastTabWidth = tabsLength > 1 ? this.tabs[tabsLength - 1] - this.tabs[tabsLength - 2] : this.tabs[0];
                        run3.width += lastTabWidth * (length - 1);
                    }
                }
            }
            if (this.wrapWidth != -1 && lineWidth + run3.width > this.wrapWidth && !run3.tab && !run3.lineBreak) {
                boolean wrapEntireRun;
                int start = 0;
                int[] piDx = new int[run3.length];
                if (run3.style != null && run3.style.metrics != null) {
                    piDx[0] = run3.width;
                } else {
                    OS.ScriptGetLogicalWidths(run3.analysis, run3.length, run3.glyphCount, run3.advances, run3.clusters, run3.visAttrs, piDx);
                }
                int width = 0;
                int maxWidth = this.wrapWidth - lineWidth;
                while (width + piDx[start] < maxWidth) {
                    width += piDx[start++];
                }
                int firstStart = start;
                int firstIndice = i3;
                while (i3 >= lineStart) {
                    this.breakRun(run3);
                    while (start >= 0) {
                        OS.MoveMemory(logAttr, run3.psla + (long)(start * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                        if (logAttr.fSoftBreak || logAttr.fWhiteSpace) break;
                        --start;
                    }
                    if (start == 0 && i3 != lineStart && !run3.tab && logAttr.fSoftBreak && !logAttr.fWhiteSpace) {
                        OS.MoveMemory(properties2, this.device.scripts[run3.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        short langID = properties2.langid;
                        StyleItem pRun = this.allRuns[i3 - 1];
                        OS.MoveMemory(properties2, this.device.scripts[pRun.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        if (properties2.langid == langID || langID == 0 || properties2.langid == 0) {
                            this.breakRun(pRun);
                            OS.MoveMemory(logAttr, pRun.psla + (long)((pRun.length - 1) * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                            if (!logAttr.fWhiteSpace) {
                                start = -1;
                            }
                        }
                    }
                    if (start >= 0 || i3 == lineStart) break;
                    run3 = this.allRuns[--i3];
                    start = run3.length - 1;
                }
                boolean bl = wrapEntireRun = start == 0 && i3 != lineStart && !run3.tab;
                if (wrapEntireRun) {
                    this.breakRun(run3);
                    OS.MoveMemory(logAttr, run3.psla + (long)(start * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                    boolean bl2 = wrapEntireRun = !logAttr.fWhiteSpace;
                }
                if (wrapEntireRun) {
                    run3 = this.allRuns[--i3];
                    start = run3.length;
                } else if (start <= 0 && i3 == lineStart) {
                    if (firstStart == 0 && firstIndice > lineStart) {
                        i3 = firstIndice - 1;
                        run3 = this.allRuns[i3];
                        start = run3.length;
                    } else {
                        i3 = firstIndice;
                        run3 = this.allRuns[i3];
                        start = Math.max(1, firstStart);
                    }
                }
                this.breakRun(run3);
                while (start < run3.length) {
                    OS.MoveMemory(logAttr, run3.psla + (long)(start * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                    if (!logAttr.fWhiteSpace) break;
                    ++start;
                }
                if (start > 0 && start < run3.length) {
                    StyleItem newRun = new StyleItem();
                    newRun.start = run3.start + start;
                    newRun.length = run3.length - start;
                    newRun.style = run3.style;
                    newRun.analysis = this.cloneScriptAnalysis(run3.analysis);
                    run3.free();
                    run3.length = start;
                    OS.SelectObject(srcHdc, this.getItemFont(run3));
                    run3.analysis.fNoGlyphIndex = false;
                    this.shape(srcHdc, run3);
                    OS.SelectObject(srcHdc, this.getItemFont(newRun));
                    newRun.analysis.fNoGlyphIndex = false;
                    this.shape(srcHdc, newRun);
                    StyleItem[] newAllRuns = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, newAllRuns, 0, i3 + 1);
                    System.arraycopy(this.allRuns, i3 + 1, newAllRuns, i3 + 2, this.allRuns.length - i3 - 1);
                    this.allRuns = newAllRuns;
                    this.allRuns[i3 + 1] = newRun;
                }
                if (i3 != this.allRuns.length - 2) {
                    run3.lineBreak = true;
                    run3.softBreak = true;
                }
            }
            lineWidth += run3.width;
            if (run3.lineBreak) {
                lineStart = i3 + 1;
                lineWidth = run3.softBreak ? this.wrapIndent : this.indent;
                ++lineCount;
            }
            ++i3;
        }
        lineWidth = 0;
        this.runs = new StyleItem[lineCount][];
        this.lineOffset = new int[lineCount + 1];
        this.lineY = new int[lineCount + 1];
        this.lineWidth = new int[lineCount];
        int lineRunCount = 0;
        int line2 = 0;
        int ascentInPoints = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.ascentInPixels));
        int descentInPoints = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.descentInPixels));
        StyleItem[] lineRuns = new StyleItem[this.allRuns.length];
        int i4 = 0;
        while (i4 < this.allRuns.length) {
            StyleItem run4 = this.allRuns[i4];
            lineRuns[lineRunCount++] = run4;
            lineWidth += run4.width;
            ascentInPoints = Math.max(ascentInPoints, run4.ascentInPoints);
            descentInPoints = Math.max(descentInPoints, run4.descentInPoints);
            if (run4.lineBreak || i4 == this.allRuns.length - 1) {
                if (!(lineRunCount != 1 || i4 != this.allRuns.length - 1 && run4.softBreak)) {
                    TEXTMETRIC lptm = new TEXTMETRIC();
                    OS.SelectObject(srcHdc, this.getItemFont(run4));
                    OS.GetTextMetrics(srcHdc, lptm);
                    run4.ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmAscent);
                    run4.descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmDescent);
                    ascentInPoints = Math.max(ascentInPoints, run4.ascentInPoints);
                    descentInPoints = Math.max(descentInPoints, run4.descentInPoints);
                }
                this.runs[line2] = new StyleItem[lineRunCount];
                System.arraycopy(lineRuns, 0, this.runs[line2], 0, lineRunCount);
                if (this.justify && this.wrapWidth != -1 && run4.softBreak && lineWidth > 0) {
                    int lineIndent = this.wrapIndent;
                    if (line2 == 0) {
                        lineIndent = this.indent;
                    } else {
                        StyleItem[] previousLine = this.runs[line2 - 1];
                        StyleItem previousRun = previousLine[previousLine.length - 1];
                        if (previousRun.lineBreak && !previousRun.softBreak) {
                            lineIndent = this.indent;
                        }
                    }
                    lineWidth += lineIndent;
                    long hHeap = OS.GetProcessHeap();
                    int newLineWidth = 0;
                    int j3 = 0;
                    while (j3 < this.runs[line2].length) {
                        StyleItem item2 = this.runs[line2][j3];
                        int iDx = item2.width * this.wrapWidth / lineWidth;
                        if (iDx != item2.width) {
                            item2.justify = OS.HeapAlloc(hHeap, 8, item2.glyphCount * 4);
                            if (item2.justify == 0L) {
                                SWT.error(2);
                            }
                            OS.ScriptJustify(item2.visAttrs, item2.advances, item2.glyphCount, iDx - item2.width, 2, item2.justify);
                            item2.width = iDx;
                        }
                        newLineWidth += item2.width;
                        ++j3;
                    }
                    lineWidth = newLineWidth;
                }
                this.lineWidth[line2] = lineWidth;
                StyleItem lastRun = this.runs[line2][lineRunCount - 1];
                int lastOffset = lastRun.start + lastRun.length;
                this.runs[line2] = this.reorder(this.runs[line2], i4 == this.allRuns.length - 1);
                lastRun = this.runs[line2][lineRunCount - 1];
                if (run4.softBreak && run4 != lastRun) {
                    run4.lineBreak = false;
                    run4.softBreak = false;
                    lastRun.lineBreak = true;
                    lastRun.softBreak = true;
                }
                lineWidth = this.getLineIndent(line2);
                int j4 = 0;
                while (j4 < this.runs[line2].length) {
                    this.runs[line2][j4].x = lineWidth;
                    lineWidth += this.runs[line2][j4].width;
                    ++j4;
                }
                this.lineY[++line2] = this.lineY[line2 - 1] + ascentInPoints + descentInPoints + this.lineSpacingInPoints;
                this.lineOffset[line2] = lastOffset;
                lineWidth = 0;
                lineRunCount = 0;
                ascentInPoints = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.ascentInPixels));
                descentInPoints = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.descentInPixels));
            }
            ++i4;
        }
        if (srcHdc != 0L) {
            OS.DeleteDC(srcHdc);
        }
        if (gc == null) {
            this.device.internal_dispose_GC(hDC, null);
        }
    }

    @Override
    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        this.segments = null;
        this.segmentsChars = null;
        if (this.mLangFontLink2 != null) {
            this.mLangFontLink2.Release();
            this.mLangFontLink2 = null;
        }
        OS.OleUninitialize();
    }

    SCRIPT_ANALYSIS cloneScriptAnalysis(SCRIPT_ANALYSIS src) {
        SCRIPT_ANALYSIS dst = new SCRIPT_ANALYSIS();
        dst.eScript = src.eScript;
        dst.fRTL = src.fRTL;
        dst.fLayoutRTL = src.fLayoutRTL;
        dst.fLinkBefore = src.fLinkBefore;
        dst.fLinkAfter = src.fLinkAfter;
        dst.fLogicalOrder = src.fLogicalOrder;
        dst.fNoGlyphIndex = src.fNoGlyphIndex;
        dst.s = new SCRIPT_STATE();
        dst.s.uBidiLevel = src.s.uBidiLevel;
        dst.s.fOverrideDirection = src.s.fOverrideDirection;
        dst.s.fInhibitSymSwap = src.s.fInhibitSymSwap;
        dst.s.fCharShape = src.s.fCharShape;
        dst.s.fDigitSubstitute = src.s.fDigitSubstitute;
        dst.s.fInhibitLigate = src.s.fInhibitLigate;
        dst.s.fDisplayZWG = src.s.fDisplayZWG;
        dst.s.fArabicNumContext = src.s.fArabicNumContext;
        dst.s.fGcpClusters = src.s.fGcpClusters;
        dst.s.fReserved = src.s.fReserved;
        dst.s.fEngineReserved = src.s.fEngineReserved;
        return dst;
    }

    int[] computePolyline(int left2, int top2, int right2, int bottom2) {
        int length;
        int height = bottom2 - top2;
        int width = 2 * height;
        int peaks = Compatibility.ceil(right2 - left2, width);
        if (peaks == 0 && right2 - left2 > 2) {
            peaks = 1;
        }
        if ((length = (2 * peaks + 1) * 2) < 0) {
            return new int[0];
        }
        int[] coordinates = new int[length];
        int i2 = 0;
        while (i2 < peaks) {
            int index = 4 * i2;
            coordinates[index] = left2 + width * i2;
            coordinates[index + 1] = bottom2;
            coordinates[index + 2] = coordinates[index] + width / 2;
            coordinates[index + 3] = top2;
            ++i2;
        }
        coordinates[length - 2] = left2 + width * peaks;
        coordinates[length - 1] = bottom2;
        return coordinates;
    }

    long createGdipBrush(int pixel, int alpha) {
        int argb = (alpha & 0xFF) << 24 | pixel >> 16 & 0xFF | pixel & 0xFF00 | (pixel & 0xFF) << 16;
        return Gdip.SolidBrush_new(argb);
    }

    long createGdipBrush(Color color, int alpha) {
        return this.createGdipBrush(color.handle, alpha);
    }

    public void draw(GC gc, int x2, int y2) {
        this.checkLayout();
        this.drawInPixels(gc, DPIUtil.autoScaleUp((Drawable)this.getDevice(), x2), DPIUtil.autoScaleUp((Drawable)this.getDevice(), y2));
    }

    void drawInPixels(GC gc, int x2, int y2) {
        this.drawInPixels(gc, x2, y2, -1, -1, null, null);
    }

    public void draw(GC gc, int x2, int y2, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.checkLayout();
        this.drawInPixels(gc, DPIUtil.autoScaleUp((Drawable)this.getDevice(), x2), DPIUtil.autoScaleUp((Drawable)this.getDevice(), y2), selectionStart, selectionEnd, selectionForeground, selectionBackground);
    }

    void drawInPixels(GC gc, int x2, int y2, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.drawInPixels(gc, x2, y2, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x2, int y2, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        this.checkLayout();
        this.drawInPixels(gc, DPIUtil.autoScaleUp((Drawable)this.getDevice(), x2), DPIUtil.autoScaleUp((Drawable)this.getDevice(), y2), selectionStart, selectionEnd, selectionForeground, selectionBackground, flags);
    }

    void drawInPixels(GC gc, int x2, int y2, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        int length;
        this.computeRuns(gc);
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        if ((length = this.text.length()) == 0 && flags == 0) {
            return;
        }
        y2 += this.getScaledVerticalIndent();
        long hdc = gc.handle;
        Rectangle clip = gc.getClippingInPixels();
        GCData data2 = gc.data;
        long gdipGraphics = data2.gdipGraphics;
        int foreground = data2.foreground;
        int linkColor = OS.GetSysColor(26);
        int alpha = data2.alpha;
        boolean gdip = gdipGraphics != 0L;
        long gdipForeground = 0L;
        long gdipLinkColor = 0L;
        int state = 0;
        if (gdip) {
            gc.checkGC(1);
            gdipForeground = gc.getFgBrush();
        } else {
            state = OS.SaveDC(hdc);
            if ((data2.style & 0x8000000) != 0) {
                OS.SetLayout(hdc, OS.GetLayout(hdc) | 1);
            }
        }
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        long gdipSelBackground = 0L;
        long gdipSelForeground = 0L;
        long gdipFont = 0L;
        long lastHFont = 0L;
        long selBackground = 0L;
        int selForeground = 0;
        if (hasSelection || (flags & 0x100000) != 0 && (flags & 0x30000) != 0) {
            int bgSel;
            int fgSel = selectionForeground != null ? selectionForeground.handle : OS.GetSysColor(14);
            int n2 = bgSel = selectionBackground != null ? selectionBackground.handle : OS.GetSysColor(13);
            if (gdip) {
                gdipSelBackground = this.createGdipBrush(bgSel, alpha);
                gdipSelForeground = this.createGdipBrush(fgSel, alpha);
            } else {
                selBackground = OS.CreateSolidBrush(bgSel);
                selForeground = fgSel;
            }
            if (hasSelection) {
                selectionStart = this.translateOffset(Math.min(Math.max(0, selectionStart), length - 1));
                selectionEnd = this.translateOffset(Math.min(Math.max(0, selectionEnd), length - 1));
            }
        }
        RECT rect = new RECT();
        OS.SetBkMode(hdc, 1);
        int line2 = 0;
        while (line2 < this.runs.length) {
            int drawX = x2 + this.getLineIndent(line2);
            int drawY = y2 + DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[line2]);
            StyleItem[] lineRuns = this.runs[line2];
            int lineHeight = DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[line2 + 1] - this.lineY[line2] - this.lineSpacingInPoints);
            if ((flags & 0x30000) != 0 && (hasSelection || (flags & 0x100000) != 0)) {
                boolean extents = false;
                if (line2 == this.runs.length - 1 && (flags & 0x100000) != 0) {
                    extents = true;
                } else {
                    StyleItem run2 = lineRuns[lineRuns.length - 1];
                    if (run2.lineBreak && !run2.softBreak) {
                        if (selectionStart <= run2.start && run2.start <= selectionEnd) {
                            extents = true;
                        }
                    } else {
                        int endOffset = run2.start + run2.length - 1;
                        if (selectionStart <= endOffset && endOffset < selectionEnd && (flags & 0x10000) != 0) {
                            extents = true;
                        }
                    }
                }
                if (extents) {
                    int width = (flags & 0x10000) != 0 ? 0x6FFFFFF : lineHeight / 3;
                    if (gdip) {
                        Gdip.Graphics_FillRectangle(gdipGraphics, gdipSelBackground, drawX + this.lineWidth[line2], drawY, width, lineHeight);
                    } else {
                        OS.SelectObject(hdc, selBackground);
                        OS.PatBlt(hdc, drawX + this.lineWidth[line2], drawY, width, lineHeight, 15728673);
                    }
                }
            }
            if (drawX <= clip.x + clip.width && drawX + this.lineWidth[line2] >= clip.x) {
                int alignmentX = drawX;
                int i2 = 0;
                while (i2 < lineRuns.length) {
                    StyleItem run3 = lineRuns[i2];
                    if (run3.length != 0) {
                        if (drawX > clip.x + clip.width) break;
                        if (drawX + run3.width >= clip.x && (!run3.lineBreak || run3.softBreak)) {
                            OS.SetRect(rect, drawX, drawY, drawX + run3.width, drawY + lineHeight);
                            if (gdip) {
                                this.drawRunBackgroundGDIP(run3, gdipGraphics, rect, selectionStart, selectionEnd, alpha, gdipSelBackground, hasSelection);
                            } else {
                                this.drawRunBackground(run3, hdc, rect, selectionStart, selectionEnd, selBackground, hasSelection);
                            }
                        }
                        drawX += run3.width;
                    }
                    ++i2;
                }
                int baselineInPixels = Math.max(0, this.ascentInPixels);
                int lineUnderlinePos = 0;
                int i3 = 0;
                while (i3 < lineRuns.length) {
                    baselineInPixels = Math.max(baselineInPixels, DPIUtil.autoScaleUp((Drawable)this.getDevice(), lineRuns[i3].ascentInPoints));
                    lineUnderlinePos = Math.min(lineUnderlinePos, lineRuns[i3].underlinePos);
                    ++i3;
                }
                RECT borderClip = null;
                RECT underlineClip = null;
                RECT strikeoutClip = null;
                RECT pRect = null;
                drawX = alignmentX;
                int i4 = 0;
                while (i4 < lineRuns.length) {
                    boolean hasAdorners;
                    StyleItem run4 = lineRuns[i4];
                    TextStyle style = run4.style;
                    boolean bl = hasAdorners = style != null && (style.underline || style.strikeout || style.borderStyle != 0);
                    if (run4.length != 0) {
                        if (drawX > clip.x + clip.width) break;
                        if (drawX + run4.width >= clip.x) {
                            boolean skipTab;
                            boolean bl2 = skipTab = run4.tab && !hasAdorners;
                            if (!(skipTab || run4.lineBreak && !run4.softBreak || style != null && style.metrics != null)) {
                                OS.SetRect(rect, drawX, drawY, drawX + run4.width, drawY + lineHeight);
                                if (gdip) {
                                    long hFont = this.getItemFont(run4);
                                    if (hFont != lastHFont) {
                                        lastHFont = hFont;
                                        if (gdipFont != 0L) {
                                            Gdip.Font_delete(gdipFont);
                                        }
                                        long oldFont = OS.SelectObject(hdc, hFont);
                                        gdipFont = Gdip.Font_new(hdc, hFont);
                                        OS.SelectObject(hdc, oldFont);
                                        if (gdipFont == 0L) {
                                            SWT.error(2);
                                        }
                                        if (!Gdip.Font_IsAvailable(gdipFont)) {
                                            Gdip.Font_delete(gdipFont);
                                            gdipFont = 0L;
                                        }
                                    }
                                    long gdipFg = gdipForeground;
                                    if (style != null && style.underline && style.underlineStyle == 4) {
                                        if (gdipLinkColor == 0L) {
                                            gdipLinkColor = this.createGdipBrush(linkColor, alpha);
                                        }
                                        gdipFg = gdipLinkColor;
                                    }
                                    if (gdipFont != 0L && !run4.analysis.fNoGlyphIndex) {
                                        pRect = this.drawRunTextGDIP(gdipGraphics, run4, rect, gdipFont, baselineInPixels, gdipFg, gdipSelForeground, selectionStart, selectionEnd, alpha);
                                    } else {
                                        int fg = style != null && style.underline && style.underlineStyle == 4 ? linkColor : foreground;
                                        pRect = this.drawRunTextGDIPRaster(gdipGraphics, run4, rect, baselineInPixels, fg, selForeground, selectionStart, selectionEnd);
                                    }
                                    underlineClip = this.drawUnderlineGDIP(gdipGraphics, x2, drawY + baselineInPixels, lineUnderlinePos, drawY + lineHeight, lineRuns, i4, gdipFg, gdipSelForeground, underlineClip, pRect, selectionStart, selectionEnd, alpha, clip);
                                    strikeoutClip = this.drawStrikeoutGDIP(gdipGraphics, x2, drawY + baselineInPixels, lineRuns, i4, gdipFg, gdipSelForeground, strikeoutClip, pRect, selectionStart, selectionEnd, alpha, clip);
                                    borderClip = this.drawBorderGDIP(gdipGraphics, x2, drawY, lineHeight, lineRuns, i4, gdipFg, gdipSelForeground, borderClip, pRect, selectionStart, selectionEnd, alpha, clip);
                                } else {
                                    int fg = style != null && style.underline && style.underlineStyle == 4 ? linkColor : foreground;
                                    pRect = this.drawRunText(hdc, run4, rect, baselineInPixels, fg, selForeground, selectionStart, selectionEnd);
                                    underlineClip = this.drawUnderline(hdc, x2, drawY + baselineInPixels, lineUnderlinePos, drawY + lineHeight, lineRuns, i4, fg, selForeground, underlineClip, pRect, selectionStart, selectionEnd, clip);
                                    strikeoutClip = this.drawStrikeout(hdc, x2, drawY + baselineInPixels, lineRuns, i4, fg, selForeground, strikeoutClip, pRect, selectionStart, selectionEnd, clip);
                                    borderClip = this.drawBorder(hdc, x2, drawY, lineHeight, lineRuns, i4, fg, selForeground, borderClip, pRect, selectionStart, selectionEnd, clip);
                                }
                            }
                        }
                        drawX += run4.width;
                    }
                    ++i4;
                }
            }
            ++line2;
        }
        if (gdipSelBackground != 0L) {
            Gdip.SolidBrush_delete(gdipSelBackground);
        }
        if (gdipSelForeground != 0L) {
            Gdip.SolidBrush_delete(gdipSelForeground);
        }
        if (gdipLinkColor != 0L) {
            Gdip.SolidBrush_delete(gdipLinkColor);
        }
        if (gdipFont != 0L) {
            Gdip.Font_delete(gdipFont);
        }
        if (state != 0) {
            OS.RestoreDC(hdc, state);
        }
        if (selBackground != 0L) {
            OS.DeleteObject(selBackground);
        }
    }

    RECT drawBorder(long hdc, int x2, int y2, int lineHeight, StyleItem[] line2, int index, int color, int selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run2 = line2[index];
        TextStyle style = run2.style;
        if (style == null) {
            return null;
        }
        if (style.borderStyle == 0) {
            return null;
        }
        clipRect = this.addClipRect(run2, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x2 + run2.x + run2.width > drawClip.x + drawClip.width;
        if (index + 1 >= line2.length || lastRunVisible || !style.isAdherentBorder(line2[index + 1].style)) {
            boolean fullSelection;
            int left2 = run2.x;
            int start = run2.start;
            int end = run2.start + run2.length - 1;
            int i2 = index;
            while (i2 > 0 && style.isAdherentBorder(line2[i2 - 1].style)) {
                left2 = line2[i2 - 1].x;
                start = Math.min(start, line2[i2 - 1].start);
                end = Math.max(end, line2[i2 - 1].start + line2[i2 - 1].length - 1);
                --i2;
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean bl2 = fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            if (style.borderColor != null) {
                color = style.borderColor.handle;
                clipRect = null;
            } else if (fullSelection) {
                color = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                color = style.foreground.handle;
            }
            int lineWidth = 1;
            int pattern = 1;
            int lineStyle = 0;
            switch (style.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    lineStyle = 1;
                    pattern = 4;
                    break;
                }
                case 4: {
                    lineStyle = 2;
                    pattern = 2;
                }
            }
            long oldBrush = OS.SelectObject(hdc, OS.GetStockObject(5));
            LOGBRUSH logBrush = new LOGBRUSH();
            logBrush.lbStyle = 0;
            logBrush.lbColor = color;
            long newPen = OS.ExtCreatePen(lineStyle | 0x10000, lineWidth, logBrush, 0, null);
            long oldPen = OS.SelectObject(hdc, newPen);
            RECT drawRect = new RECT();
            OS.SetRect(drawRect, x2 + left2, y2, x2 + run2.x + run2.width, y2 + lineHeight);
            if (drawClip != null) {
                int remainder;
                if (drawRect.left < drawClip.x) {
                    remainder = drawRect.left % pattern;
                    drawRect.left = drawClip.x / pattern * pattern + remainder - pattern;
                }
                if (drawRect.right > drawClip.x + drawClip.width) {
                    remainder = drawRect.right % pattern;
                    drawRect.right = (drawClip.x + drawClip.width) / pattern * pattern + remainder + pattern;
                }
            }
            OS.Rectangle(hdc, drawRect.left, drawRect.top, drawRect.right, drawRect.bottom);
            OS.SelectObject(hdc, oldPen);
            OS.DeleteObject(newPen);
            if (clipRect != null) {
                int state = OS.SaveDC(hdc);
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                OS.IntersectClipRect(hdc, clipRect.left, clipRect.top, clipRect.right, clipRect.bottom);
                logBrush.lbColor = selectionColor;
                long selPen = OS.ExtCreatePen(lineStyle | 0x10000, lineWidth, logBrush, 0, null);
                oldPen = OS.SelectObject(hdc, selPen);
                OS.Rectangle(hdc, drawRect.left, drawRect.top, drawRect.right, drawRect.bottom);
                OS.RestoreDC(hdc, state);
                OS.SelectObject(hdc, oldPen);
                OS.DeleteObject(selPen);
            }
            OS.SelectObject(hdc, oldBrush);
            return null;
        }
        return clipRect;
    }

    RECT drawBorderGDIP(long graphics, int x2, int y2, int lineHeight, StyleItem[] line2, int index, long color, long selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, int alpha, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run2 = line2[index];
        TextStyle style = run2.style;
        if (style == null) {
            return null;
        }
        if (style.borderStyle == 0) {
            return null;
        }
        clipRect = this.addClipRect(run2, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x2 + run2.x + run2.width > drawClip.x + drawClip.width;
        if (index + 1 >= line2.length || lastRunVisible || !style.isAdherentBorder(line2[index + 1].style)) {
            int left2 = run2.x;
            int start = run2.start;
            int end = run2.start + run2.length - 1;
            int i2 = index;
            while (i2 > 0 && style.isAdherentBorder(line2[i2 - 1].style)) {
                left2 = line2[i2 - 1].x;
                start = Math.min(start, line2[i2 - 1].start);
                end = Math.max(end, line2[i2 - 1].start + line2[i2 - 1].length - 1);
                --i2;
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            long brush = color;
            if (style.borderColor != null) {
                brush = this.createGdipBrush(style.borderColor, alpha);
                clipRect = null;
            } else if (fullSelection) {
                brush = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                brush = this.createGdipBrush(style.foreground, alpha);
            }
            boolean lineWidth = true;
            int lineStyle = 0;
            switch (style.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    lineStyle = 1;
                    break;
                }
                case 4: {
                    lineStyle = 2;
                }
            }
            long pen = Gdip.Pen_new(brush, (float)lineWidth);
            Gdip.Pen_SetDashStyle(pen, lineStyle);
            Gdip.Graphics_SetPixelOffsetMode(graphics, 3);
            int smoothingMode = Gdip.Graphics_GetSmoothingMode(graphics);
            Gdip.Graphics_SetSmoothingMode(graphics, 3);
            if (clipRect != null) {
                int gstate = Gdip.Graphics_Save(graphics);
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                Rect gdipRect = new Rect();
                gdipRect.X = clipRect.left;
                gdipRect.Y = clipRect.top;
                gdipRect.Width = clipRect.right - clipRect.left;
                gdipRect.Height = clipRect.bottom - clipRect.top;
                Gdip.Graphics_SetClip(graphics, gdipRect, 4);
                Gdip.Graphics_DrawRectangle(graphics, pen, x2 + left2, y2, run2.x + run2.width - left2 - 1, lineHeight - 1);
                Gdip.Graphics_Restore(graphics, gstate);
                gstate = Gdip.Graphics_Save(graphics);
                Gdip.Graphics_SetClip(graphics, gdipRect, 1);
                long selPen = Gdip.Pen_new(selectionColor, (float)lineWidth);
                Gdip.Pen_SetDashStyle(selPen, lineStyle);
                Gdip.Graphics_DrawRectangle(graphics, selPen, x2 + left2, y2, run2.x + run2.width - left2 - 1, lineHeight - 1);
                Gdip.Pen_delete(selPen);
                Gdip.Graphics_Restore(graphics, gstate);
            } else {
                Gdip.Graphics_DrawRectangle(graphics, pen, x2 + left2, y2, run2.x + run2.width - left2 - 1, lineHeight - 1);
            }
            Gdip.Graphics_SetPixelOffsetMode(graphics, 4);
            Gdip.Graphics_SetSmoothingMode(graphics, smoothingMode);
            Gdip.Pen_delete(pen);
            if (brush != selectionColor && brush != color) {
                Gdip.SolidBrush_delete(brush);
            }
            return null;
        }
        return clipRect;
    }

    void drawRunBackground(StyleItem run2, long hdc, RECT rect, int selectionStart, int selectionEnd, long selBrush, boolean hasSelection) {
        boolean fullSelection;
        int end = run2.start + run2.length - 1;
        boolean bl = fullSelection = hasSelection && selectionStart <= run2.start && selectionEnd >= end;
        if (fullSelection) {
            OS.SelectObject(hdc, selBrush);
            OS.PatBlt(hdc, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
        } else {
            boolean partialSelection;
            if (run2.style != null && run2.style.background != null) {
                int bg = run2.style.background.handle;
                long hBrush = OS.CreateSolidBrush(bg);
                long oldBrush = OS.SelectObject(hdc, hBrush);
                OS.PatBlt(hdc, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
                OS.SelectObject(hdc, oldBrush);
                OS.DeleteObject(hBrush);
            }
            boolean bl2 = partialSelection = hasSelection && selectionStart <= end && run2.start <= selectionEnd;
            if (partialSelection) {
                this.getPartialSelection(run2, selectionStart, selectionEnd, rect);
                OS.SelectObject(hdc, selBrush);
                OS.PatBlt(hdc, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
            }
        }
    }

    void drawRunBackgroundGDIP(StyleItem run2, long graphics, RECT rect, int selectionStart, int selectionEnd, int alpha, long selBrush, boolean hasSelection) {
        boolean fullSelection;
        int end = run2.start + run2.length - 1;
        boolean bl = fullSelection = hasSelection && selectionStart <= run2.start && selectionEnd >= end;
        if (fullSelection) {
            Gdip.Graphics_FillRectangle(graphics, selBrush, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
        } else {
            boolean partialSelection;
            if (run2.style != null && run2.style.background != null) {
                long brush = this.createGdipBrush(run2.style.background, alpha);
                Gdip.Graphics_FillRectangle(graphics, brush, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
                Gdip.SolidBrush_delete(brush);
            }
            boolean bl2 = partialSelection = hasSelection && selectionStart <= end && run2.start <= selectionEnd;
            if (partialSelection) {
                this.getPartialSelection(run2, selectionStart, selectionEnd, rect);
                if (rect.left > rect.right) {
                    int tmp = rect.left;
                    rect.left = rect.right;
                    rect.right = tmp;
                }
                Gdip.Graphics_FillRectangle(graphics, selBrush, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
            }
        }
    }

    RECT drawRunText(long hdc, StyleItem run2, RECT rect, int baselineInPixels, int color, int selectionColor, int selectionStart, int selectionEnd) {
        int end = run2.start + run2.length - 1;
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        boolean fullSelection = hasSelection && selectionStart <= run2.start && selectionEnd >= end;
        boolean partialSelection = hasSelection && !fullSelection && selectionStart <= end && run2.start <= selectionEnd;
        int offset = (this.orientation & 0x4000000) != 0 ? -1 : 0;
        int x2 = rect.left + offset;
        int y2 = rect.top + (baselineInPixels - DPIUtil.autoScaleUp((Drawable)this.getDevice(), run2.ascentInPoints));
        long hFont = this.getItemFont(run2);
        OS.SelectObject(hdc, hFont);
        if (fullSelection) {
            color = selectionColor;
        } else if (run2.style != null && run2.style.foreground != null) {
            color = run2.style.foreground.handle;
        }
        OS.SetTextColor(hdc, color);
        OS.ScriptTextOut(hdc, run2.psc, x2, y2, 0, null, run2.analysis, 0L, 0, run2.glyphs, run2.glyphCount, run2.advances, run2.justify, run2.goffsets);
        if (partialSelection) {
            this.getPartialSelection(run2, selectionStart, selectionEnd, rect);
            OS.SetTextColor(hdc, selectionColor);
            OS.ScriptTextOut(hdc, run2.psc, x2, y2, 4, rect, run2.analysis, 0L, 0, run2.glyphs, run2.glyphCount, run2.advances, run2.justify, run2.goffsets);
        }
        return fullSelection || partialSelection ? rect : null;
    }

    RECT drawRunTextGDIP(long graphics, StyleItem run2, RECT rect, long gdipFont, int baselineInPixels, long color, long selectionColor, int selectionStart, int selectionEnd, int alpha) {
        boolean isMirrored;
        int end = run2.start + run2.length - 1;
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        boolean fullSelection = hasSelection && selectionStart <= run2.start && selectionEnd >= end;
        boolean partialSelection = hasSelection && !fullSelection && selectionStart <= end && run2.start <= selectionEnd;
        int drawY = rect.top + baselineInPixels;
        if (run2.style != null && run2.style.rise != 0) {
            drawY -= DPIUtil.autoScaleUp((Drawable)this.getDevice(), run2.style.rise);
        }
        int drawX = rect.left;
        long brush = color;
        if (fullSelection) {
            brush = selectionColor;
        } else if (run2.style != null && run2.style.foreground != null) {
            brush = this.createGdipBrush(run2.style.foreground, alpha);
        }
        int gstate = 0;
        Rect gdipRect = null;
        if (partialSelection) {
            gdipRect = new Rect();
            this.getPartialSelection(run2, selectionStart, selectionEnd, rect);
            gdipRect.X = rect.left;
            gdipRect.Y = rect.top;
            gdipRect.Width = rect.right - rect.left;
            gdipRect.Height = rect.bottom - rect.top;
            gstate = Gdip.Graphics_Save(graphics);
            Gdip.Graphics_SetClip(graphics, gdipRect, 4);
        }
        int gstateMirrored = 0;
        boolean bl = isMirrored = (this.orientation & 0x4000000) != 0;
        if (isMirrored) {
            switch (Gdip.Brush_GetType(brush)) {
                case 4: {
                    Gdip.LinearGradientBrush_ScaleTransform(brush, -1.0f, 1.0f, 0);
                    Gdip.LinearGradientBrush_TranslateTransform(brush, -2 * drawX - run2.width, 0.0f, 0);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_ScaleTransform(brush, -1.0f, 1.0f, 0);
                    Gdip.TextureBrush_TranslateTransform(brush, -2 * drawX - run2.width, 0.0f, 0);
                }
            }
            gstateMirrored = Gdip.Graphics_Save(graphics);
            Gdip.Graphics_ScaleTransform(graphics, -1.0f, 1.0f, 0);
            Gdip.Graphics_TranslateTransform(graphics, -2 * drawX - run2.width, 0.0f, 0);
        }
        int[] advances = new int[run2.glyphCount];
        float[] points = new float[run2.glyphCount * 2];
        C.memmove(advances, run2.justify != 0L ? run2.justify : run2.advances, (long)(run2.glyphCount * 4));
        int glyphX = drawX;
        int h2 = 0;
        int j2 = 0;
        while (h2 < advances.length) {
            points[j2++] = glyphX;
            points[j2++] = drawY;
            glyphX += advances[h2];
            ++h2;
        }
        Gdip.Graphics_DrawDriverString(graphics, run2.glyphs, run2.glyphCount, gdipFont, brush, points, 0, 0L);
        if (partialSelection) {
            if (isMirrored) {
                Gdip.Graphics_Restore(graphics, gstateMirrored);
            }
            Gdip.Graphics_Restore(graphics, gstate);
            gstate = Gdip.Graphics_Save(graphics);
            Gdip.Graphics_SetClip(graphics, gdipRect, 1);
            if (isMirrored) {
                gstateMirrored = Gdip.Graphics_Save(graphics);
                Gdip.Graphics_ScaleTransform(graphics, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(graphics, -2 * drawX - run2.width, 0.0f, 0);
            }
            Gdip.Graphics_DrawDriverString(graphics, run2.glyphs, run2.glyphCount, gdipFont, selectionColor, points, 0, 0L);
            Gdip.Graphics_Restore(graphics, gstate);
        }
        if (isMirrored) {
            switch (Gdip.Brush_GetType(brush)) {
                case 4: {
                    Gdip.LinearGradientBrush_ResetTransform(brush);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_ResetTransform(brush);
                }
            }
            Gdip.Graphics_Restore(graphics, gstateMirrored);
        }
        if (brush != selectionColor && brush != color) {
            Gdip.SolidBrush_delete(brush);
        }
        return fullSelection || partialSelection ? rect : null;
    }

    RECT drawRunTextGDIPRaster(long graphics, StyleItem run2, RECT rect, int baselineInPixels, int color, int selectionColor, int selectionStart, int selectionEnd) {
        long clipRgn = 0L;
        Gdip.Graphics_SetPixelOffsetMode(graphics, 3);
        long rgn = Gdip.Region_new();
        if (rgn == 0L) {
            SWT.error(2);
        }
        Gdip.Graphics_GetClip(graphics, rgn);
        if (!Gdip.Region_IsInfinite(rgn, graphics)) {
            clipRgn = Gdip.Region_GetHRGN(rgn, graphics);
        }
        Gdip.Region_delete(rgn);
        Gdip.Graphics_SetPixelOffsetMode(graphics, 4);
        float[] lpXform = null;
        long matrix = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        if (matrix == 0L) {
            SWT.error(2);
        }
        Gdip.Graphics_GetTransform(graphics, matrix);
        if (!Gdip.Matrix_IsIdentity(matrix)) {
            lpXform = new float[6];
            Gdip.Matrix_GetElements(matrix, lpXform);
        }
        Gdip.Matrix_delete(matrix);
        long hdc = Gdip.Graphics_GetHDC(graphics);
        int state = OS.SaveDC(hdc);
        if (lpXform != null) {
            OS.SetGraphicsMode(hdc, 2);
            OS.SetWorldTransform(hdc, lpXform);
        }
        if (clipRgn != 0L) {
            OS.SelectClipRgn(hdc, clipRgn);
            OS.DeleteObject(clipRgn);
        }
        if ((this.orientation & 0x4000000) != 0) {
            OS.SetLayout(hdc, OS.GetLayout(hdc) | 1);
        }
        OS.SetBkMode(hdc, 1);
        RECT pRect = this.drawRunText(hdc, run2, rect, baselineInPixels, color, selectionColor, selectionStart, selectionEnd);
        OS.RestoreDC(hdc, state);
        Gdip.Graphics_ReleaseHDC(graphics, hdc);
        return pRect;
    }

    RECT drawStrikeout(long hdc, int x2, int baselineInPixels, StyleItem[] line2, int index, int color, int selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run2 = line2[index];
        TextStyle style = run2.style;
        if (style == null) {
            return null;
        }
        if (!style.strikeout) {
            return null;
        }
        clipRect = this.addClipRect(run2, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x2 + run2.x + run2.width > drawClip.x + drawClip.width;
        if (index + 1 >= line2.length || lastRunVisible || !style.isAdherentStrikeout(line2[index + 1].style)) {
            boolean fullSelection;
            int left2 = run2.x;
            int start = run2.start;
            int end = run2.start + run2.length - 1;
            int i2 = index;
            while (i2 > 0 && style.isAdherentStrikeout(line2[i2 - 1].style)) {
                left2 = line2[i2 - 1].x;
                start = Math.min(start, line2[i2 - 1].start);
                end = Math.max(end, line2[i2 - 1].start + line2[i2 - 1].length - 1);
                --i2;
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean bl2 = fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            if (style.strikeoutColor != null) {
                color = style.strikeoutColor.handle;
                clipRect = null;
            } else if (fullSelection) {
                color = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                color = style.foreground.handle;
            }
            RECT rect = new RECT();
            int riseInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), style.rise);
            OS.SetRect(rect, x2 + left2, baselineInPixels - run2.strikeoutPos - riseInPixels, x2 + run2.x + run2.width, baselineInPixels - run2.strikeoutPos + run2.strikeoutThickness - riseInPixels);
            long brush = OS.CreateSolidBrush(color);
            OS.FillRect(hdc, rect, brush);
            OS.DeleteObject(brush);
            if (clipRect != null) {
                long selBrush = OS.CreateSolidBrush(selectionColor);
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                OS.SetRect(clipRect, Math.max(rect.left, clipRect.left), rect.top, Math.min(rect.right, clipRect.right), rect.bottom);
                OS.FillRect(hdc, clipRect, selBrush);
                OS.DeleteObject(selBrush);
            }
            return null;
        }
        return clipRect;
    }

    RECT drawStrikeoutGDIP(long graphics, int x2, int baselineInPixels, StyleItem[] line2, int index, long color, long selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, int alpha, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run2 = line2[index];
        TextStyle style = run2.style;
        if (style == null) {
            return null;
        }
        if (!style.strikeout) {
            return null;
        }
        clipRect = this.addClipRect(run2, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x2 + run2.x + run2.width > drawClip.x + drawClip.width;
        if (index + 1 >= line2.length || lastRunVisible || !style.isAdherentStrikeout(line2[index + 1].style)) {
            int left2 = run2.x;
            int start = run2.start;
            int end = run2.start + run2.length - 1;
            int i2 = index;
            while (i2 > 0 && style.isAdherentStrikeout(line2[i2 - 1].style)) {
                left2 = line2[i2 - 1].x;
                start = Math.min(start, line2[i2 - 1].start);
                end = Math.max(end, line2[i2 - 1].start + line2[i2 - 1].length - 1);
                --i2;
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            long brush = color;
            if (style.strikeoutColor != null) {
                brush = this.createGdipBrush(style.strikeoutColor, alpha);
                clipRect = null;
            } else if (fullSelection) {
                brush = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                brush = this.createGdipBrush(style.foreground, alpha);
            }
            int riseInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), style.rise);
            if (clipRect != null) {
                int gstate = Gdip.Graphics_Save(graphics);
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                Rect gdipRect = new Rect();
                gdipRect.X = clipRect.left;
                gdipRect.Y = clipRect.top;
                gdipRect.Width = clipRect.right - clipRect.left;
                gdipRect.Height = clipRect.bottom - clipRect.top;
                Gdip.Graphics_SetClip(graphics, gdipRect, 4);
                Gdip.Graphics_FillRectangle(graphics, brush, x2 + left2, baselineInPixels - run2.strikeoutPos - riseInPixels, run2.x + run2.width - left2, run2.strikeoutThickness);
                Gdip.Graphics_Restore(graphics, gstate);
                gstate = Gdip.Graphics_Save(graphics);
                Gdip.Graphics_SetClip(graphics, gdipRect, 1);
                Gdip.Graphics_FillRectangle(graphics, selectionColor, x2 + left2, baselineInPixels - run2.strikeoutPos - riseInPixels, run2.x + run2.width - left2, run2.strikeoutThickness);
                Gdip.Graphics_Restore(graphics, gstate);
            } else {
                Gdip.Graphics_FillRectangle(graphics, brush, x2 + left2, baselineInPixels - run2.strikeoutPos - riseInPixels, run2.x + run2.width - left2, run2.strikeoutThickness);
            }
            if (brush != selectionColor && brush != color) {
                Gdip.SolidBrush_delete(brush);
            }
            return null;
        }
        return clipRect;
    }

    RECT drawUnderline(long hdc, int x2, int baselineInPixels, int lineUnderlinePos, int lineBottom, StyleItem[] line2, int index, int color, int selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run2 = line2[index];
        TextStyle style = run2.style;
        if (style == null) {
            return null;
        }
        if (!style.underline) {
            return null;
        }
        clipRect = this.addClipRect(run2, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x2 + run2.x + run2.width > drawClip.x + drawClip.width;
        if (index + 1 >= line2.length || lastRunVisible || !style.isAdherentUnderline(line2[index + 1].style)) {
            boolean fullSelection;
            int left2 = run2.x;
            int start = run2.start;
            int end = run2.start + run2.length - 1;
            int i2 = index;
            while (i2 > 0 && style.isAdherentUnderline(line2[i2 - 1].style)) {
                left2 = line2[i2 - 1].x;
                start = Math.min(start, line2[i2 - 1].start);
                end = Math.max(end, line2[i2 - 1].start + line2[i2 - 1].length - 1);
                --i2;
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean bl2 = fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            if (style.underlineColor != null) {
                color = style.underlineColor.handle;
                clipRect = null;
            } else if (fullSelection) {
                color = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                color = style.foreground.handle;
            }
            RECT rect = new RECT();
            int riseInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), style.rise);
            OS.SetRect(rect, x2 + left2, baselineInPixels - lineUnderlinePos - riseInPixels, x2 + run2.x + run2.width, baselineInPixels - lineUnderlinePos + run2.underlineThickness - riseInPixels);
            if (clipRect != null) {
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                OS.SetRect(clipRect, Math.max(rect.left, clipRect.left), rect.top, Math.min(rect.right, clipRect.right), rect.bottom);
            }
            switch (style.underlineStyle) {
                case 2: 
                case 3: {
                    int squigglyThickness = 1;
                    int squigglyHeight = 2 * squigglyThickness;
                    int squigglyY = Math.min(rect.top - squigglyHeight / 2, lineBottom - squigglyHeight - 1);
                    int[] points = this.computePolyline(rect.left, squigglyY, rect.right, squigglyY + squigglyHeight);
                    long pen = OS.CreatePen(0, squigglyThickness, color);
                    long oldPen = OS.SelectObject(hdc, pen);
                    int state = OS.SaveDC(hdc);
                    OS.IntersectClipRect(hdc, rect.left, squigglyY, rect.right + 1, squigglyY + squigglyHeight + 1);
                    OS.Polyline(hdc, points, points.length / 2);
                    int length = points.length;
                    if (length >= 2 && squigglyThickness <= 1) {
                        OS.SetPixel(hdc, points[length - 2], points[length - 1], color);
                    }
                    OS.SelectObject(hdc, oldPen);
                    OS.DeleteObject(pen);
                    OS.RestoreDC(hdc, state);
                    if (clipRect == null) break;
                    pen = OS.CreatePen(0, squigglyThickness, selectionColor);
                    oldPen = OS.SelectObject(hdc, pen);
                    state = OS.SaveDC(hdc);
                    OS.IntersectClipRect(hdc, clipRect.left, squigglyY, clipRect.right + 1, squigglyY + squigglyHeight + 1);
                    OS.Polyline(hdc, points, points.length / 2);
                    if (length >= 2 && squigglyThickness <= 1) {
                        OS.SetPixel(hdc, points[length - 2], points[length - 1], selectionColor);
                    }
                    OS.SelectObject(hdc, oldPen);
                    OS.DeleteObject(pen);
                    OS.RestoreDC(hdc, state);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 196608: {
                    int bottom2;
                    if (style.underlineStyle == 196608) {
                        rect.top -= run2.underlineThickness;
                        if (clipRect != null) {
                            clipRect.top -= run2.underlineThickness;
                        }
                    }
                    int n2 = bottom2 = style.underlineStyle == 1 ? rect.bottom + run2.underlineThickness * 2 : rect.bottom;
                    if (bottom2 > lineBottom) {
                        OS.OffsetRect(rect, 0, lineBottom - bottom2);
                        if (clipRect != null) {
                            OS.OffsetRect(clipRect, 0, lineBottom - bottom2);
                        }
                    }
                    long brush = OS.CreateSolidBrush(color);
                    OS.FillRect(hdc, rect, brush);
                    if (style.underlineStyle == 1) {
                        OS.SetRect(rect, rect.left, rect.top + run2.underlineThickness * 2, rect.right, rect.bottom + run2.underlineThickness * 2);
                        OS.FillRect(hdc, rect, brush);
                    }
                    OS.DeleteObject(brush);
                    if (clipRect == null) break;
                    long selBrush = OS.CreateSolidBrush(selectionColor);
                    OS.FillRect(hdc, clipRect, selBrush);
                    if (style.underlineStyle == 1) {
                        OS.SetRect(clipRect, clipRect.left, rect.top, clipRect.right, rect.bottom);
                        OS.FillRect(hdc, clipRect, selBrush);
                    }
                    OS.DeleteObject(selBrush);
                    break;
                }
                case 65536: 
                case 131072: {
                    int penStyle = style.underlineStyle == 131072 ? 1 : 2;
                    long pen = OS.CreatePen(penStyle, 1, color);
                    long oldPen = OS.SelectObject(hdc, pen);
                    int descentInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), run2.descentInPoints);
                    OS.SetRect(rect, rect.left, baselineInPixels + descentInPixels, rect.right, baselineInPixels + descentInPixels + run2.underlineThickness);
                    OS.MoveToEx(hdc, rect.left, rect.top, 0L);
                    OS.LineTo(hdc, rect.right, rect.top);
                    OS.SelectObject(hdc, oldPen);
                    OS.DeleteObject(pen);
                    if (clipRect == null) break;
                    pen = OS.CreatePen(penStyle, 1, selectionColor);
                    oldPen = OS.SelectObject(hdc, pen);
                    OS.SetRect(clipRect, clipRect.left, rect.top, clipRect.right, rect.bottom);
                    OS.MoveToEx(hdc, clipRect.left, clipRect.top, 0L);
                    OS.LineTo(hdc, clipRect.right, clipRect.top);
                    OS.SelectObject(hdc, oldPen);
                    OS.DeleteObject(pen);
                }
            }
            return null;
        }
        return clipRect;
    }

    RECT drawUnderlineGDIP(long graphics, int x2, int baselineInPixels, int lineUnderlinePos, int lineBottom, StyleItem[] line2, int index, long color, long selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, int alpha, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run2 = line2[index];
        TextStyle style = run2.style;
        if (style == null) {
            return null;
        }
        if (!style.underline) {
            return null;
        }
        clipRect = this.addClipRect(run2, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x2 + run2.x + run2.width > drawClip.x + drawClip.width;
        if (index + 1 >= line2.length || lastRunVisible || !style.isAdherentUnderline(line2[index + 1].style)) {
            int left2 = run2.x;
            int start = run2.start;
            int end = run2.start + run2.length - 1;
            int i2 = index;
            while (i2 > 0 && style.isAdherentUnderline(line2[i2 - 1].style)) {
                left2 = line2[i2 - 1].x;
                start = Math.min(start, line2[i2 - 1].start);
                end = Math.max(end, line2[i2 - 1].start + line2[i2 - 1].length - 1);
                --i2;
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            long brush = color;
            if (style.underlineColor != null) {
                brush = this.createGdipBrush(style.underlineColor, alpha);
                clipRect = null;
            } else if (fullSelection) {
                brush = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                brush = this.createGdipBrush(style.foreground, alpha);
            }
            RECT rect = new RECT();
            int riseInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), style.rise);
            OS.SetRect(rect, x2 + left2, baselineInPixels - lineUnderlinePos - riseInPixels, x2 + run2.x + run2.width, baselineInPixels - lineUnderlinePos + run2.underlineThickness - riseInPixels);
            Rect gdipRect = null;
            if (clipRect != null) {
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                OS.SetRect(clipRect, Math.max(rect.left, clipRect.left), rect.top, Math.min(rect.right, clipRect.right), rect.bottom);
                gdipRect = new Rect();
                gdipRect.X = clipRect.left;
                gdipRect.Y = clipRect.top;
                gdipRect.Width = clipRect.right - clipRect.left;
                gdipRect.Height = clipRect.bottom - clipRect.top;
            }
            int gstate = 0;
            Gdip.Graphics_SetPixelOffsetMode(graphics, 3);
            int smoothingMode = Gdip.Graphics_GetSmoothingMode(graphics);
            Gdip.Graphics_SetSmoothingMode(graphics, 3);
            switch (style.underlineStyle) {
                case 2: 
                case 3: {
                    int squigglyThickness = 1;
                    int squigglyHeight = 2 * squigglyThickness;
                    int squigglyY = Math.min(rect.top - squigglyHeight / 2, lineBottom - squigglyHeight - 1);
                    int[] points = this.computePolyline(rect.left, squigglyY, rect.right, squigglyY + squigglyHeight);
                    long pen = Gdip.Pen_new(brush, squigglyThickness);
                    gstate = Gdip.Graphics_Save(graphics);
                    if (gdipRect != null) {
                        Gdip.Graphics_SetClip(graphics, gdipRect, 4);
                    } else {
                        Rect r2 = new Rect();
                        r2.X = rect.left;
                        r2.Y = squigglyY;
                        r2.Width = rect.right - rect.left;
                        r2.Height = squigglyHeight + 1;
                        Gdip.Graphics_SetClip(graphics, r2, 1);
                    }
                    Gdip.Graphics_DrawLines(graphics, pen, points, points.length / 2);
                    if (gdipRect != null) {
                        long selPen = Gdip.Pen_new(selectionColor, squigglyThickness);
                        Gdip.Graphics_Restore(graphics, gstate);
                        gstate = Gdip.Graphics_Save(graphics);
                        Gdip.Graphics_SetClip(graphics, gdipRect, 1);
                        Gdip.Graphics_DrawLines(graphics, selPen, points, points.length / 2);
                        Gdip.Pen_delete(selPen);
                    }
                    Gdip.Graphics_Restore(graphics, gstate);
                    Gdip.Pen_delete(pen);
                    if (gstate == 0) break;
                    Gdip.Graphics_Restore(graphics, gstate);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 196608: {
                    int bottom2;
                    if (style.underlineStyle == 196608) {
                        rect.top -= run2.underlineThickness;
                    }
                    int n2 = bottom2 = style.underlineStyle == 1 ? rect.bottom + run2.underlineThickness * 2 : rect.bottom;
                    if (bottom2 > lineBottom) {
                        OS.OffsetRect(rect, 0, lineBottom - bottom2);
                    }
                    if (gdipRect != null) {
                        gdipRect.Y = rect.top;
                        if (style.underlineStyle == 196608) {
                            gdipRect.Height = run2.underlineThickness * 2;
                        }
                        if (style.underlineStyle == 1) {
                            gdipRect.Height = run2.underlineThickness * 3;
                        }
                        gstate = Gdip.Graphics_Save(graphics);
                        Gdip.Graphics_SetClip(graphics, gdipRect, 4);
                    }
                    Gdip.Graphics_FillRectangle(graphics, brush, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
                    if (style.underlineStyle == 1) {
                        Gdip.Graphics_FillRectangle(graphics, brush, rect.left, rect.top + run2.underlineThickness * 2, rect.right - rect.left, rect.bottom - rect.top);
                    }
                    if (gdipRect == null) break;
                    Gdip.Graphics_Restore(graphics, gstate);
                    gstate = Gdip.Graphics_Save(graphics);
                    Gdip.Graphics_SetClip(graphics, gdipRect, 1);
                    Gdip.Graphics_FillRectangle(graphics, selectionColor, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
                    if (style.underlineStyle == 1) {
                        Gdip.Graphics_FillRectangle(graphics, selectionColor, rect.left, rect.top + run2.underlineThickness * 2, rect.right - rect.left, rect.bottom - rect.top);
                    }
                    Gdip.Graphics_Restore(graphics, gstate);
                    break;
                }
                case 65536: 
                case 131072: {
                    long pen = Gdip.Pen_new(brush, 1.0f);
                    int dashStyle = style.underlineStyle == 65536 ? 2 : 1;
                    Gdip.Pen_SetDashStyle(pen, dashStyle);
                    if (gdipRect != null) {
                        gstate = Gdip.Graphics_Save(graphics);
                        Gdip.Graphics_SetClip(graphics, gdipRect, 4);
                    }
                    int descentInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), run2.descentInPoints);
                    Gdip.Graphics_DrawLine(graphics, pen, rect.left, baselineInPixels + descentInPixels, run2.width - run2.length, baselineInPixels + descentInPixels);
                    if (gdipRect != null) {
                        Gdip.Graphics_Restore(graphics, gstate);
                        gstate = Gdip.Graphics_Save(graphics);
                        Gdip.Graphics_SetClip(graphics, gdipRect, 1);
                        long selPen = Gdip.Pen_new(brush, 1.0f);
                        Gdip.Pen_SetDashStyle(selPen, dashStyle);
                        Gdip.Graphics_DrawLine(graphics, selPen, rect.left, baselineInPixels + descentInPixels, run2.width - run2.length, baselineInPixels + descentInPixels);
                        Gdip.Graphics_Restore(graphics, gstate);
                        Gdip.Pen_delete(selPen);
                    }
                    Gdip.Pen_delete(pen);
                }
            }
            if (brush != selectionColor && brush != color) {
                Gdip.SolidBrush_delete(brush);
            }
            Gdip.Graphics_SetPixelOffsetMode(graphics, 4);
            Gdip.Graphics_SetSmoothingMode(graphics, smoothingMode);
            return null;
        }
        return clipRect;
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.allRuns.length) {
            StyleItem run2 = this.allRuns[i2];
            run2.free();
            ++i2;
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.ascentInPixels);
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int width = 0;
        if (this.wrapWidth != -1) {
            width = this.wrapWidth;
        } else {
            int line2 = 0;
            while (line2 < this.runs.length) {
                width = Math.max(width, this.lineWidth[line2] + this.getLineIndent(line2));
                ++line2;
            }
        }
        return new Rectangle(0, 0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), width), this.lineY[this.lineY.length - 1] + this.getScaledVerticalIndent());
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getBoundsInPixels(start, end));
    }

    Rectangle getBoundsInPixels(int start, int end) {
        this.computeRuns(null);
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        length = this.segmentsText.length();
        char ch = this.segmentsText.charAt(start);
        if ('\udc00' <= ch && ch <= '\udfff' && start - 1 >= 0 && '\ud800' <= (ch = this.segmentsText.charAt(start - 1)) && ch <= '\udbff') {
            --start;
        }
        if ('\ud800' <= (ch = this.segmentsText.charAt(end)) && ch <= '\udbff' && end + 1 < length && '\udc00' <= (ch = this.segmentsText.charAt(end + 1)) && ch <= '\udfff') {
            ++end;
        }
        int left2 = Integer.MAX_VALUE;
        int right2 = 0;
        int top2 = Integer.MAX_VALUE;
        int bottom2 = 0;
        boolean isRTL = (this.orientation & 0x4000000) != 0;
        int i2 = 0;
        while (i2 < this.allRuns.length - 1) {
            StyleItem run2 = this.allRuns[i2];
            int runEnd = run2.start + run2.length;
            if (runEnd > start) {
                long advances;
                int[] piX;
                GlyphMetrics metrics;
                int cx;
                if (run2.start > end) break;
                int runLead = run2.x;
                int runTrail = run2.x + run2.width;
                if (run2.start <= start && start < runEnd) {
                    cx = 0;
                    if (run2.style != null && run2.style.metrics != null) {
                        metrics = run2.style.metrics;
                        cx = metrics.getWidthInPixels() * (start - run2.start);
                    } else if (!run2.tab) {
                        piX = new int[1];
                        advances = run2.justify != 0L ? run2.justify : run2.advances;
                        OS.ScriptCPtoX(start - run2.start, false, run2.length, run2.glyphCount, run2.clusters, run2.visAttrs, advances, run2.analysis, piX);
                        int n2 = cx = isRTL ? run2.width - piX[0] : piX[0];
                    }
                    if (run2.analysis.fRTL ^ isRTL) {
                        runTrail = run2.x + cx;
                    } else {
                        runLead = run2.x + cx;
                    }
                }
                if (run2.start <= end && end < runEnd) {
                    cx = run2.width;
                    if (run2.style != null && run2.style.metrics != null) {
                        metrics = run2.style.metrics;
                        cx = metrics.getWidthInPixels() * (end - run2.start + 1);
                    } else if (!run2.tab) {
                        piX = new int[1];
                        advances = run2.justify != 0L ? run2.justify : run2.advances;
                        OS.ScriptCPtoX(end - run2.start, true, run2.length, run2.glyphCount, run2.clusters, run2.visAttrs, advances, run2.analysis, piX);
                        int n3 = cx = isRTL ? run2.width - piX[0] : piX[0];
                    }
                    if (run2.analysis.fRTL ^ isRTL) {
                        runLead = run2.x + cx;
                    } else {
                        runTrail = run2.x + cx;
                    }
                }
                int lineIndex = 0;
                while (lineIndex < this.runs.length && this.lineOffset[lineIndex + 1] <= run2.start) {
                    ++lineIndex;
                }
                left2 = Math.min(left2, runLead);
                right2 = Math.max(right2, runTrail);
                top2 = Math.min(top2, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[lineIndex]));
                bottom2 = Math.max(bottom2, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[lineIndex + 1] - this.lineSpacingInPoints));
            }
            ++i2;
        }
        return new Rectangle(left2, top2, right2 - left2, bottom2 - top2 + this.getScaledVerticalIndent());
    }

    public int getDescent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.descentInPixels);
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getIndentInPixels());
    }

    int getIndentInPixels() {
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    long getItemFont(StyleItem item2) {
        if (item2.fallbackFont != 0L) {
            return item2.fallbackFont;
        }
        if (item2.style != null && item2.style.font != null) {
            return item2.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont.handle;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int i2 = 1;
        while (i2 < this.allRuns.length) {
            if (this.allRuns[i2].start > offset) {
                return this.allRuns[i2 - 1].analysis.s.uBidiLevel;
            }
            ++i2;
        }
        return (this.resolveTextDirection() & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLineBoundsInPixels(lineIndex));
    }

    Rectangle getLineBoundsInPixels(int lineIndex) {
        this.computeRuns(null);
        if (lineIndex < 0 || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int x2 = this.getLineIndent(lineIndex);
        int y2 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[lineIndex]);
        int width = this.lineWidth[lineIndex];
        int height = DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[lineIndex + 1] - this.lineY[lineIndex] - this.lineSpacingInPoints);
        return new Rectangle(x2, y2, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int lineIndex) {
        int lineIndent = this.wrapIndent;
        if (lineIndex == 0) {
            lineIndent = this.indent;
        } else {
            StyleItem[] previousLine = this.runs[lineIndex - 1];
            StyleItem previousRun = previousLine[previousLine.length - 1];
            if (previousRun.lineBreak && !previousRun.softBreak) {
                lineIndent = this.indent;
            }
        }
        if (this.wrapWidth != -1) {
            boolean partialLine = true;
            if (this.justify) {
                StyleItem[] lineRun = this.runs[lineIndex];
                if (lineRun[lineRun.length - 1].softBreak) {
                    partialLine = false;
                }
            }
            if (partialLine) {
                int lineWidth = this.lineWidth[lineIndex] + lineIndent;
                switch (this.alignment) {
                    case 0x1000000: {
                        lineIndent += (this.wrapWidth - lineWidth) / 2;
                        break;
                    }
                    case 131072: {
                        lineIndent += this.wrapWidth - lineWidth;
                    }
                }
            }
        }
        return lineIndent;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int line2 = 0;
        while (line2 < this.runs.length) {
            if (this.lineOffset[line2 + 1] > offset) {
                return line2;
            }
            ++line2;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        this.computeRuns(null);
        if (lineIndex < 0 || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        long hDC = this.device.internal_new_GC(null);
        long srcHdc = OS.CreateCompatibleDC(hDC);
        TEXTMETRIC lptm = new TEXTMETRIC();
        OS.SelectObject(srcHdc, this.font != null ? this.font.handle : this.device.systemFont.handle);
        OS.GetTextMetrics(srcHdc, lptm);
        OS.DeleteDC(srcHdc);
        this.device.internal_dispose_GC(hDC, null);
        int ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), Math.max(lptm.tmAscent, this.ascentInPixels));
        int descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), Math.max(lptm.tmDescent, this.descentInPixels));
        int leadingInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmInternalLeading);
        if (this.text.length() != 0) {
            StyleItem[] lineRuns = this.runs[lineIndex];
            int i2 = 0;
            while (i2 < lineRuns.length) {
                StyleItem run2 = lineRuns[i2];
                if (run2.ascentInPoints > ascentInPoints) {
                    ascentInPoints = run2.ascentInPoints;
                    leadingInPoints = run2.leadingInPoints;
                }
                descentInPoints = Math.max(descentInPoints, run2.descentInPoints);
                ++i2;
            }
        }
        lptm.tmAscent = DPIUtil.autoScaleUp((Drawable)this.getDevice(), ascentInPoints);
        lptm.tmDescent = DPIUtil.autoScaleUp((Drawable)this.getDevice(), descentInPoints);
        lptm.tmHeight = DPIUtil.autoScaleUp((Drawable)this.getDevice(), ascentInPoints + descentInPoints);
        lptm.tmInternalLeading = DPIUtil.autoScaleUp((Drawable)this.getDevice(), leadingInPoints);
        lptm.tmAveCharWidth = 0;
        return FontMetrics.win32_new(lptm);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] offsets = new int[this.lineOffset.length];
        int i2 = 0;
        while (i2 < offsets.length) {
            offsets[i2] = this.untranslateOffset(this.lineOffset[i2]);
            ++i2;
        }
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLocationInPixels(offset, trailing));
    }

    Point getLocationInPixels(int offset, boolean trailing) {
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        int line2 = 0;
        while (line2 < this.runs.length) {
            if (this.lineOffset[line2 + 1] > offset) break;
            ++line2;
        }
        line2 = Math.min(line2, this.runs.length - 1);
        if (offset == length) {
            return new Point(this.getLineIndent(line2) + this.lineWidth[line2], DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[line2]));
        }
        char ch = this.segmentsText.charAt(offset);
        if (trailing) {
            if ('\ud800' <= ch && ch <= '\udbff' && offset + 1 < length && '\udc00' <= (ch = this.segmentsText.charAt(offset + 1)) && ch <= '\udfff') {
                ++offset;
            }
        } else if ('\udc00' <= ch && ch <= '\udfff' && offset - 1 >= 0 && '\ud800' <= (ch = this.segmentsText.charAt(offset - 1)) && ch <= '\udbff') {
            --offset;
        }
        int low = -1;
        int high = this.allRuns.length;
        while (high - low > 1) {
            int width;
            int index = (high + low) / 2;
            StyleItem run2 = this.allRuns[index];
            if (run2.start > offset) {
                high = index;
                continue;
            }
            if (run2.start + run2.length <= offset) {
                low = index;
                continue;
            }
            if (run2.style != null && run2.style.metrics != null) {
                GlyphMetrics metrics = run2.style.metrics;
                width = metrics.getWidthInPixels() * (offset - run2.start + (trailing ? 1 : 0));
            } else if (run2.tab) {
                width = trailing || offset == length ? run2.width : 0;
            } else {
                int runOffset = offset - run2.start;
                int cChars = run2.length;
                int gGlyphs = run2.glyphCount;
                int[] piX = new int[1];
                long advances = run2.justify != 0L ? run2.justify : run2.advances;
                OS.ScriptCPtoX(runOffset, trailing, cChars, gGlyphs, run2.clusters, run2.visAttrs, advances, run2.analysis, piX);
                width = (this.orientation & 0x4000000) != 0 ? run2.width - piX[0] : piX[0];
            }
            return new Point(run2.x + width, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[line2]) + this.getScaledVerticalIndent());
        }
        return new Point(0, 0);
    }

    public int getNextOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6, null, " [offset value: " + offset + "]");
        }
        if (forward && offset == length) {
            return length;
        }
        if (!forward && offset == 0) {
            return 0;
        }
        int n2 = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties2 = new SCRIPT_PROPERTIES();
        int i2 = forward ? 0 : this.allRuns.length - 1;
        offset = this.validadeOffset(offset, step);
        do {
            boolean isComplex;
            StyleItem run2 = this.allRuns[i2];
            if (run2.start > offset || offset >= run2.start + run2.length) continue;
            if (run2.lineBreak && !run2.softBreak) {
                return this.untranslateOffset(run2.start);
            }
            if (run2.tab) {
                return this.untranslateOffset(run2.start);
            }
            OS.MoveMemory(properties2, this.device.scripts[run2.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
            boolean bl = isComplex = properties2.fNeedsCaretInfo || properties2.fNeedsWordBreaking;
            if (isComplex) {
                this.breakRun(run2);
            }
            while (run2.start <= offset && offset < run2.start + run2.length) {
                if (isComplex) {
                    OS.MoveMemory(logAttr, run2.psla + (long)((offset - run2.start) * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                }
                switch (movement) {
                    case 2: {
                        if (properties2.fNeedsCaretInfo && (logAttr.fInvalid || !logAttr.fCharStop)) break;
                        char ch = this.segmentsText.charAt(offset);
                        if ('\udc00' <= ch && ch <= '\udfff' && offset > 0 && '\ud800' <= (ch = this.segmentsText.charAt(offset - 1)) && ch <= '\udbff') {
                            offset += step;
                        }
                        return this.untranslateOffset(offset);
                    }
                    case 4: 
                    case 16: {
                        boolean previousLetterOrDigit;
                        boolean letterOrDigit;
                        if (!(properties2.fNeedsWordBreaking ? !logAttr.fInvalid && logAttr.fWordStop : offset > 0 && ((letterOrDigit = Character.isLetterOrDigit(this.segmentsText.charAt(offset))) != (previousLetterOrDigit = Character.isLetterOrDigit(this.segmentsText.charAt(offset - 1))) || !letterOrDigit) && !Character.isWhitespace(this.segmentsText.charAt(offset)))) break;
                        return this.untranslateOffset(offset);
                    }
                    case 8: {
                        if (offset <= 0) break;
                        boolean isLetterOrDigit = Character.isLetterOrDigit(this.segmentsText.charAt(offset));
                        boolean previousLetterOrDigit = Character.isLetterOrDigit(this.segmentsText.charAt(offset - 1));
                        if (isLetterOrDigit || !previousLetterOrDigit) break;
                        return this.untranslateOffset(offset);
                    }
                }
                offset = this.validadeOffset(offset, step);
            }
        } while ((i2 += step) >= 0 && i2 < this.allRuns.length - 1 && offset >= 0 && offset < length);
        return forward ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffsetInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), point), trailing);
    }

    int getOffsetInPixels(Point point, int[] trailing) {
        return this.getOffsetInPixels(point.x, point.y, trailing);
    }

    public int getOffset(int x2, int y2, int[] trailing) {
        this.checkLayout();
        return this.getOffsetInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), x2), DPIUtil.autoScaleUp((Drawable)this.getDevice(), y2), trailing);
    }

    int getOffsetInPixels(int x2, int y2, int[] trailing) {
        this.computeRuns(null);
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        int lineCount = this.runs.length;
        int line2 = 0;
        while (line2 < lineCount) {
            if (DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[line2 + 1]) > y2) break;
            ++line2;
        }
        line2 = Math.min(line2, this.runs.length - 1);
        StyleItem[] lineRuns = this.runs[line2];
        int lineIndent = this.getLineIndent(line2);
        if (x2 >= lineIndent + this.lineWidth[line2]) {
            x2 = lineIndent + this.lineWidth[line2] - 1;
        }
        if (x2 < lineIndent) {
            x2 = lineIndent;
        }
        int low = -1;
        int high = lineRuns.length;
        while (high - low > 1) {
            char ch;
            GlyphMetrics metrics;
            int index = (high + low) / 2;
            StyleItem run2 = lineRuns[index];
            if (run2.x > x2) {
                high = index;
                continue;
            }
            if (run2.x + run2.width <= x2) {
                low = index;
                continue;
            }
            if (run2.lineBreak && !run2.softBreak) {
                return this.untranslateOffset(run2.start);
            }
            int xRun = x2 - run2.x;
            if (run2.style != null && run2.style.metrics != null && (metrics = run2.style.metrics).getWidthInPixels() > 0) {
                if (trailing != null) {
                    trailing[0] = xRun % metrics.getWidthInPixels() < metrics.getWidthInPixels() / 2 ? 0 : 1;
                }
                return this.untranslateOffset(run2.start + xRun / metrics.getWidthInPixels());
            }
            if (run2.tab) {
                if (trailing != null) {
                    trailing[0] = x2 < run2.x + run2.width / 2 ? 0 : 1;
                }
                return this.untranslateOffset(run2.start);
            }
            int cChars = run2.length;
            int cGlyphs = run2.glyphCount;
            int[] piCP = new int[1];
            int[] piTrailing = new int[1];
            if ((this.orientation & 0x4000000) != 0) {
                xRun = run2.width - xRun;
            }
            long advances = run2.justify != 0L ? run2.justify : run2.advances;
            OS.ScriptXtoCP(xRun, cChars, cGlyphs, run2.clusters, run2.visAttrs, advances, run2.analysis, piCP, piTrailing);
            int offset = run2.start + piCP[0];
            int length = this.segmentsText.length();
            char c2 = ch = offset < length ? this.segmentsText.charAt(offset) : (char)'\u0000';
            if ('\ud800' <= ch && ch <= '\udbff' && piTrailing[0] <= 1) {
                if (offset + 1 < length && '\udc00' <= (ch = this.segmentsText.charAt(offset + 1)) && ch <= '\udfff' && trailing != null) {
                    trailing[0] = 0;
                }
            } else if ('\udc00' <= ch && ch <= '\udfff' && piTrailing[0] <= 1) {
                if (offset - 1 >= 0 && '\ud800' <= (ch = this.segmentsText.charAt(offset - 1)) && ch <= '\udbff') {
                    --offset;
                    if (trailing != null) {
                        trailing[0] = 2;
                    }
                }
            } else if (trailing != null) {
                trailing[0] = piTrailing[0];
            }
            return this.untranslateOffset(offset);
        }
        if (trailing != null) {
            trailing[0] = 0;
        }
        if (lineRuns.length == 1) {
            StyleItem run3 = lineRuns[0];
            if (run3.lineBreak && !run3.softBreak) {
                return this.untranslateOffset(run3.start);
            }
        }
        return this.untranslateOffset(this.lineOffset[line2 + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    void getPartialSelection(StyleItem run2, int selectionStart, int selectionEnd, RECT rect) {
        int end = run2.start + run2.length - 1;
        int selStart = Math.max(selectionStart, run2.start) - run2.start;
        int selEnd = Math.min(selectionEnd, end) - run2.start;
        int cChars = run2.length;
        int gGlyphs = run2.glyphCount;
        int[] piX = new int[1];
        int x2 = rect.left;
        long advances = run2.justify != 0L ? run2.justify : run2.advances;
        OS.ScriptCPtoX(selStart, false, cChars, gGlyphs, run2.clusters, run2.visAttrs, advances, run2.analysis, piX);
        int runX = (this.orientation & 0x4000000) != 0 ? run2.width - piX[0] : piX[0];
        rect.left = x2 + runX;
        OS.ScriptCPtoX(selEnd, true, cChars, gGlyphs, run2.clusters, run2.visAttrs, advances, run2.analysis, piX);
        runX = (this.orientation & 0x4000000) != 0 ? run2.width - piX[0] : piX[0];
        rect.right = x2 + runX;
    }

    public int getPreviousOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result2 = new int[this.stylesCount * 2];
        int count = 0;
        int i2 = 0;
        while (i2 < this.stylesCount - 1) {
            if (this.styles[i2].style != null) {
                result2[count++] = this.styles[i2].start;
                result2[count++] = this.styles[i2 + 1].start - 1;
            }
            ++i2;
        }
        if (count != result2.length) {
            int[] newResult = new int[count];
            System.arraycopy(result2, 0, newResult, 0, count);
            result2 = newResult;
        }
        return result2;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int separator2;
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return this.text;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return this.text;
            }
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int defaultSeparator = (this.resolveTextDirection() & 0x4000000) != 0 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                separator2 = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
                newChars[charCount + segmentCount++] = separator2;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        while (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            separator2 = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
            newChars[charCount + segmentCount++] = separator2;
        }
        return new String(newChars, 0, newChars.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacingInPoints;
    }

    public int getVerticalIndent() {
        this.checkLayout();
        return this.verticalIndentInPoints;
    }

    private int getScaledVerticalIndent() {
        if (this.verticalIndentInPoints == 0) {
            return this.verticalIndentInPoints;
        }
        return DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.verticalIndentInPoints);
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i2 = 1;
        while (i2 < this.stylesCount) {
            if (this.styles[i2].start > offset) {
                return this.styles[i2 - 1].style;
            }
            ++i2;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result2 = new TextStyle[this.stylesCount];
        int count = 0;
        int i2 = 0;
        while (i2 < this.stylesCount) {
            if (this.styles[i2].style != null) {
                result2[count++] = this.styles[i2].style;
            }
            ++i2;
        }
        if (count != result2.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result2, 0, newResult, 0, count);
            result2 = newResult;
        }
        return result2;
    }

    public int[] getTabs() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getTabsInPixels());
    }

    int[] getTabsInPixels() {
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getTextDirection() {
        this.checkLayout();
        return this.resolveTextDirection();
    }

    public int getWidth() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWidthInPixels());
    }

    int getWidthInPixels() {
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWrapIndentInPixels());
    }

    int getWrapIndentInPixels() {
        return this.wrapIndent;
    }

    @Override
    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        this.segmentsText = this.getSegmentsText();
        int length = this.segmentsText.length();
        SCRIPT_CONTROL scriptControl = new SCRIPT_CONTROL();
        SCRIPT_STATE scriptState = new SCRIPT_STATE();
        int MAX_ITEM = length + 1;
        if ((this.resolveTextDirection() & 0x4000000) != 0) {
            scriptState.uBidiLevel = 1;
            scriptState.fArabicNumContext = true;
        }
        OS.ScriptApplyDigitSubstitution(null, scriptControl, scriptState);
        long hHeap = OS.GetProcessHeap();
        long pItems = OS.HeapAlloc(hHeap, 8, MAX_ITEM * SCRIPT_ITEM.sizeof);
        if (pItems == 0L) {
            SWT.error(2);
        }
        int[] pcItems = new int[1];
        char[] chars = new char[length];
        this.segmentsText.getChars(0, length, chars, 0);
        OS.ScriptItemize(chars, length, MAX_ITEM, scriptControl, scriptState, pItems, pcItems);
        StyleItem[] runs = this.merge(pItems, pcItems[0]);
        OS.HeapFree(hHeap, 0, pItems);
        return runs;
    }

    StyleItem[] merge(long items, int itemCount) {
        StyleItem item2;
        if (this.styles.length > this.stylesCount) {
            StyleItem[] newStyles = new StyleItem[this.stylesCount];
            System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
            this.styles = newStyles;
        }
        int count = 0;
        int start = 0;
        int end = this.segmentsText.length();
        int itemIndex = 0;
        int styleIndex = 0;
        StyleItem[] runs = new StyleItem[itemCount + this.stylesCount];
        SCRIPT_ITEM scriptItem = new SCRIPT_ITEM();
        int itemLimit = -1;
        int nextItemIndex = 0;
        boolean linkBefore = false;
        boolean merge = itemCount > 1024;
        SCRIPT_PROPERTIES sp = new SCRIPT_PROPERTIES();
        while (start < end) {
            int styleLimit;
            item2 = new StyleItem();
            item2.start = start;
            item2.style = this.styles[styleIndex].style;
            runs[count++] = item2;
            OS.MoveMemory(scriptItem, items + (long)(itemIndex * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
            item2.analysis = scriptItem.a;
            scriptItem.a = new SCRIPT_ANALYSIS();
            if (linkBefore) {
                item2.analysis.fLinkBefore = true;
                linkBefore = false;
            }
            char ch = this.segmentsText.charAt(start);
            switch (ch) {
                case '\n': 
                case '\r': {
                    item2.lineBreak = true;
                    break;
                }
                case '\t': {
                    item2.tab = true;
                }
            }
            if (itemLimit == -1) {
                nextItemIndex = itemIndex + 1;
                OS.MoveMemory(scriptItem, items + (long)(nextItemIndex * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
                itemLimit = scriptItem.iCharPos;
                if (nextItemIndex < itemCount && ch == '\r' && this.segmentsText.charAt(itemLimit) == '\n') {
                    nextItemIndex = itemIndex + 2;
                    OS.MoveMemory(scriptItem, items + (long)(nextItemIndex * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
                    itemLimit = scriptItem.iCharPos;
                }
                if (nextItemIndex < itemCount && merge && !item2.lineBreak) {
                    OS.MoveMemory(sp, this.device.scripts[item2.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                    if (!sp.fComplex || item2.tab) {
                        int i2 = 0;
                        while (i2 < 512) {
                            char c2;
                            if (nextItemIndex == itemCount || (c2 = this.segmentsText.charAt(itemLimit)) == '\n' || c2 == '\r' || c2 == '\t' != item2.tab) break;
                            OS.MoveMemory(sp, this.device.scripts[scriptItem.a.eScript], SCRIPT_PROPERTIES.sizeof);
                            if (!item2.tab && sp.fComplex) break;
                            OS.MoveMemory(scriptItem, items + (long)(++nextItemIndex * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
                            itemLimit = scriptItem.iCharPos;
                            ++i2;
                        }
                    }
                }
            }
            if ((styleLimit = this.translateOffset(this.styles[styleIndex + 1].start)) <= itemLimit) {
                ++styleIndex;
                start = styleLimit;
                if (start < itemLimit && start > 0 && start < end) {
                    char pChar = this.segmentsText.charAt(start - 1);
                    char tChar = this.segmentsText.charAt(start);
                    if (Character.isLetter(pChar) && Character.isLetter(tChar)) {
                        item2.analysis.fLinkAfter = true;
                        linkBefore = true;
                    }
                }
            }
            if (itemLimit <= styleLimit) {
                itemIndex = nextItemIndex;
                start = itemLimit;
                itemLimit = -1;
            }
            item2.length = start - item2.start;
        }
        item2 = new StyleItem();
        item2.start = end;
        OS.MoveMemory(scriptItem, items + (long)(itemCount * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
        item2.analysis = scriptItem.a;
        runs[count++] = item2;
        if (runs.length != count) {
            StyleItem[] result2 = new StyleItem[count];
            System.arraycopy(runs, 0, result2, 0, count);
            return result2;
        }
        return runs;
    }

    int resolveTextDirection() {
        return this.textDirection == 0x6000000 ? BidiUtil.resolveTextDirection(this.text) : this.textDirection;
    }

    StyleItem[] reorder(StyleItem[] runs, boolean terminate) {
        int length = runs.length;
        if (length <= 1) {
            return runs;
        }
        byte[] bidiLevels = new byte[length];
        int i2 = 0;
        while (i2 < length) {
            bidiLevels[i2] = (byte)(runs[i2].analysis.s.uBidiLevel & 0x1F);
            ++i2;
        }
        StyleItem lastRun = runs[length - 1];
        if (lastRun.lineBreak && !lastRun.softBreak) {
            bidiLevels[length - 1] = 0;
        }
        int[] log2vis = new int[length];
        OS.ScriptLayout(length, bidiLevels, null, log2vis);
        StyleItem[] result2 = new StyleItem[length];
        int i3 = 0;
        while (i3 < length) {
            result2[log2vis[i3]] = runs[i3];
            ++i3;
        }
        if ((this.orientation & 0x4000000) != 0) {
            if (terminate) {
                --length;
            }
            i3 = 0;
            while (i3 < length / 2) {
                StyleItem tmp = result2[i3];
                result2[i3] = result2[length - i3 - 1];
                result2[length - i3 - 1] = tmp;
                ++i3;
            }
        }
        return result2;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        if (this.alignment == alignment) {
            return;
        }
        this.freeRuns();
        this.alignment = alignment;
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascentInPixels == (ascent = DPIUtil.autoScaleUp((Drawable)this.getDevice(), ascent))) {
            return;
        }
        this.freeRuns();
        this.ascentInPixels = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descentInPixels == (descent = DPIUtil.autoScaleUp((Drawable)this.getDevice(), descent))) {
            return;
        }
        this.freeRuns();
        this.descentInPixels = descent;
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.freeRuns();
    }

    public void setIndent(int indent) {
        this.checkLayout();
        this.setIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), indent));
    }

    void setIndentInPixels(int indent) {
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        this.freeRuns();
        this.indent = indent;
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        if (this.justify == justify) {
            return;
        }
        this.freeRuns();
        this.justify = justify;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.textDirection = this.orientation = orientation;
        this.freeRuns();
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i2 = 0;
            while (i2 < segments.length) {
                if (this.segments[i2] != segments[i2]) break;
                ++i2;
            }
            if (i2 == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSegmentsChars(char[] segmentsChars) {
        this.checkLayout();
        if (this.segmentsChars == null && segmentsChars == null) {
            return;
        }
        if (this.segmentsChars != null && segmentsChars != null && this.segmentsChars.length == segmentsChars.length) {
            int i2 = 0;
            while (i2 < segmentsChars.length) {
                if (this.segmentsChars[i2] != segmentsChars[i2]) break;
                ++i2;
            }
            if (i2 == segmentsChars.length) {
                return;
            }
        }
        this.freeRuns();
        this.segmentsChars = segmentsChars;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.lineSpacingInPoints == spacing) {
            return;
        }
        this.freeRuns();
        this.lineSpacingInPoints = spacing;
    }

    public void setVerticalIndent(int verticalIndent) {
        this.checkLayout();
        if (verticalIndent < 0) {
            SWT.error(5);
        }
        if (this.verticalIndentInPoints == verticalIndent) {
            return;
        }
        this.verticalIndentInPoints = verticalIndent;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int newLength;
        int modifyStart;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int low = -1;
        int high = this.stylesCount;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (high >= 0 && high < this.stylesCount) {
            StyleItem item2 = this.styles[high];
            if (item2.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item2.style == null : style.equals(item2.style))) {
                return;
            }
        }
        this.freeRuns();
        int modifyEnd = modifyStart = high;
        while (modifyEnd < this.stylesCount) {
            if (this.styles[modifyEnd + 1].start > end) break;
            ++modifyEnd;
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                int newLength2 = this.stylesCount + 2;
                if (newLength2 > this.styles.length) {
                    int newSize = Math.min(newLength2 + 1024, Math.max(64, newLength2 * 2));
                    StyleItem[] newStyles = new StyleItem[newSize];
                    System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
                    this.styles = newStyles;
                }
                System.arraycopy(this.styles, modifyEnd + 1, this.styles, modifyEnd + 3, this.stylesCount - modifyEnd - 1);
                StyleItem item3 = new StyleItem();
                item3.start = start;
                item3.style = style;
                this.styles[modifyStart + 1] = item3;
                item3 = new StyleItem();
                item3.start = end + 1;
                item3.style = this.styles[modifyStart].style;
                this.styles[modifyStart + 2] = item3;
                this.stylesCount = newLength2;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        if ((newLength = this.stylesCount + 1 - (modifyEnd - modifyStart - 1)) > this.styles.length) {
            int newSize = Math.min(newLength + 1024, Math.max(64, newLength * 2));
            StyleItem[] newStyles = new StyleItem[newSize];
            System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
            this.styles = newStyles;
        }
        System.arraycopy(this.styles, modifyEnd, this.styles, modifyStart + 2, this.stylesCount - modifyEnd);
        StyleItem item4 = new StyleItem();
        item4.start = start;
        item4.style = style;
        this.styles[modifyStart + 1] = item4;
        this.styles[modifyStart + 2].start = end + 1;
        this.stylesCount = newLength;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        this.setTabsInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), tabs));
    }

    void setTabsInPixels(int[] tabs) {
        if (Arrays.equals(this.tabs, tabs)) {
            return;
        }
        this.freeRuns();
        this.tabs = tabs;
    }

    public void setText(String text2) {
        this.checkLayout();
        if (text2 == null) {
            SWT.error(4);
        }
        if (text2.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text2;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text2.length();
        this.stylesCount = 2;
    }

    public void setTextDirection(int textDirection) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((textDirection &= mask) == 0) {
            return;
        }
        if (textDirection != 0x6000000) {
            if ((textDirection & 0x2000000) != 0) {
                textDirection = 0x2000000;
            }
            if (this.textDirection == textDirection) {
                return;
            }
        }
        this.textDirection = textDirection;
        this.freeRuns();
    }

    public void setWidth(int width) {
        this.checkLayout();
        this.setWidthInPixels(width != -1 ? DPIUtil.autoScaleUp((Drawable)this.getDevice(), width) : width);
    }

    void setWidthInPixels(int width) {
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
    }

    public void setWrapIndent(int wrapIndent) {
        this.checkLayout();
        this.setWrapIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), wrapIndent));
    }

    void setWrapIndentInPixels(int wrapIndent) {
        if (wrapIndent < 0) {
            return;
        }
        if (this.wrapIndent == wrapIndent) {
            return;
        }
        this.freeRuns();
        this.wrapIndent = wrapIndent;
    }

    boolean shape(long hdc, StyleItem run2, char[] chars, int[] glyphCount, int maxGlyphs, SCRIPT_PROPERTIES sp) {
        short[] glyphs;
        boolean useCMAPcheck;
        boolean bl = useCMAPcheck = !sp.fComplex && !run2.analysis.fNoGlyphIndex;
        if (useCMAPcheck && OS.ScriptGetCMap(hdc, run2.psc, chars, chars.length, 0, glyphs = new short[chars.length]) != 0) {
            if (run2.psc != 0L) {
                OS.ScriptFreeCache(run2.psc);
                glyphCount[0] = 0;
                OS.MoveMemory(run2.psc, new long[1], C.PTR_SIZEOF);
            }
            return false;
        }
        int hr = OS.ScriptShape(hdc, run2.psc, chars, chars.length, maxGlyphs, run2.analysis, run2.glyphs, run2.clusters, run2.visAttrs, glyphCount);
        run2.glyphCount = glyphCount[0];
        if (useCMAPcheck) {
            return true;
        }
        if (hr != -2147220992) {
            if (run2.analysis.fNoGlyphIndex) {
                return true;
            }
            SCRIPT_FONTPROPERTIES fp = new SCRIPT_FONTPROPERTIES();
            fp.cBytes = SCRIPT_FONTPROPERTIES.sizeof;
            OS.ScriptGetFontProperties(hdc, run2.psc, fp);
            short[] glyphs2 = new short[glyphCount[0]];
            OS.MoveMemory(glyphs2, run2.glyphs, glyphs2.length * 2);
            int i2 = 0;
            while (i2 < glyphs2.length) {
                if (glyphs2[i2] == fp.wgDefault) break;
                ++i2;
            }
            if (i2 == glyphs2.length) {
                return true;
            }
        }
        if (run2.psc != 0L) {
            OS.ScriptFreeCache(run2.psc);
            glyphCount[0] = 0;
            OS.MoveMemory(run2.psc, new long[1], C.PTR_SIZEOF);
        }
        run2.glyphCount = 0;
        return false;
    }

    long createMetafileWithChars(long hdc, long hFont, char[] chars, int charCount) {
        long hHeap = OS.GetProcessHeap();
        int nativeStringSize = charCount * 2;
        long nativeString = OS.HeapAlloc(hHeap, 8, nativeStringSize);
        OS.MoveMemory(nativeString, chars, nativeStringSize);
        long ssa = OS.HeapAlloc(hHeap, 8, OS.SCRIPT_STRING_ANALYSIS_sizeof());
        long metaFileDc = OS.CreateEnhMetaFile(hdc, null, null, null);
        long oldMetaFont = OS.SelectObject(metaFileDc, hFont);
        int flags = 6304;
        if (OS.ScriptStringAnalyse(metaFileDc, nativeString, charCount, 0, -1, flags, 0, null, null, 0L, 0L, 0L, ssa) == 0) {
            OS.ScriptStringOut(ssa, 0, 0, 0, null, 0, 0, false);
            OS.ScriptStringFree(ssa);
        }
        OS.HeapFree(hHeap, 0, nativeString);
        OS.HeapFree(hHeap, 0, ssa);
        OS.SelectObject(metaFileDc, oldMetaFont);
        return OS.CloseEnhMetaFile(metaFileDc);
    }

    void shape(long hdc, StyleItem run2) {
        if (run2.lineBreak) {
            return;
        }
        if (run2.glyphs != 0L) {
            return;
        }
        int[] buffer = new int[1];
        char[] chars = new char[run2.length];
        this.segmentsText.getChars(run2.start, run2.start + run2.length, chars, 0);
        int maxGlyphs = chars.length * 3 / 2 + 16;
        long hHeap = OS.GetProcessHeap();
        run2.glyphs = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        if (run2.glyphs == 0L) {
            SWT.error(2);
        }
        run2.clusters = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        if (run2.clusters == 0L) {
            SWT.error(2);
        }
        run2.visAttrs = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        if (run2.visAttrs == 0L) {
            SWT.error(2);
        }
        run2.psc = OS.HeapAlloc(hHeap, 8, C.PTR_SIZEOF);
        if (run2.psc == 0L) {
            SWT.error(2);
        }
        short script = run2.analysis.eScript;
        SCRIPT_PROPERTIES sp = new SCRIPT_PROPERTIES();
        OS.MoveMemory(sp, this.device.scripts[script], SCRIPT_PROPERTIES.sizeof);
        boolean shapeSucceed = this.shape(hdc, run2, chars, buffer, maxGlyphs, sp);
        if (!shapeSucceed && sp.fPrivateUseArea) {
            run2.analysis.fNoGlyphIndex = true;
            shapeSucceed = this.shape(hdc, run2, chars, buffer, maxGlyphs, sp);
        }
        if (!shapeSucceed) {
            long hFont = OS.GetCurrentObject(hdc, 6);
            long newFont = 0L;
            char[] sampleChars = new char[Math.min(chars.length, 2)];
            SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
            this.breakRun(run2);
            int count = 0;
            int i2 = 0;
            while (i2 < chars.length) {
                OS.MoveMemory(logAttr, run2.psla + (long)(i2 * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                if (!logAttr.fWhiteSpace) {
                    sampleChars[count++] = chars[i2];
                    if (count == sampleChars.length) break;
                }
                ++i2;
            }
            if (count > 0) {
                Callback callback;
                long address;
                long metaFile = this.createMetafileWithChars(hdc, hFont, sampleChars, count);
                EMREXTCREATEFONTINDIRECTW emr = new EMREXTCREATEFONTINDIRECTW();
                class MetaFileEnumProc {
                    private final /* synthetic */ EMREXTCREATEFONTINDIRECTW val$emr;

                    MetaFileEnumProc(EMREXTCREATEFONTINDIRECTW eMREXTCREATEFONTINDIRECTW) {
                        this.val$emr = eMREXTCREATEFONTINDIRECTW;
                    }

                    long metaFileEnumProc(long hDC, long table, long record, long nObj, long lpData) {
                        OS.MoveMemory(this.val$emr.emr, record, EMR.sizeof);
                        switch (this.val$emr.emr.iType) {
                            case 82: {
                                OS.MoveMemory(this.val$emr, record, EMREXTCREATEFONTINDIRECTW.sizeof);
                                break;
                            }
                            case 84: {
                                return 0L;
                            }
                        }
                        return 1L;
                    }
                }
                MetaFileEnumProc object = new MetaFileEnumProc(emr);
                boolean compilerWarningWorkaround = false;
                if (compilerWarningWorkaround) {
                    object.metaFileEnumProc(0L, 0L, 0L, 0L, 0L);
                }
                if ((address = (callback = new Callback(object, "metaFileEnumProc", 5)).getAddress()) == 0L) {
                    SWT.error(3);
                }
                OS.EnumEnhMetaFile(0L, metaFile, address, 0L, null);
                OS.DeleteEnhMetaFile(metaFile);
                callback.dispose();
                newFont = OS.CreateFontIndirect(emr.elfw.elfLogFont);
            } else {
                int index = 0;
                while (index < this.allRuns.length - 1) {
                    if (this.allRuns[index] == run2) {
                        LOGFONT logFont;
                        if (index > 0) {
                            StyleItem pRun = this.allRuns[index - 1];
                            if (pRun.analysis.eScript == run2.analysis.eScript) {
                                long pFont = this.getItemFont(pRun);
                                logFont = new LOGFONT();
                                OS.GetObject(pFont, LOGFONT.sizeof, logFont);
                                newFont = OS.CreateFontIndirect(logFont);
                            }
                        }
                        if (newFont != 0L || index + 1 >= this.allRuns.length - 1) break;
                        StyleItem nRun = this.allRuns[index + 1];
                        if (nRun.analysis.eScript != run2.analysis.eScript) break;
                        OS.SelectObject(hdc, this.getItemFont(nRun));
                        this.shape(hdc, nRun);
                        long nFont = this.getItemFont(nRun);
                        logFont = new LOGFONT();
                        OS.GetObject(nFont, LOGFONT.sizeof, logFont);
                        newFont = OS.CreateFontIndirect(logFont);
                        break;
                    }
                    ++index;
                }
            }
            if (newFont != 0L) {
                OS.SelectObject(hdc, newFont);
                shapeSucceed = this.shape(hdc, run2, chars, buffer, maxGlyphs, sp);
                if (shapeSucceed) {
                    run2.fallbackFont = newFont;
                }
            }
            if (!shapeSucceed && !sp.fComplex) {
                run2.analysis.fNoGlyphIndex = true;
                shapeSucceed = this.shape(hdc, run2, chars, buffer, maxGlyphs, sp);
                if (shapeSucceed) {
                    run2.fallbackFont = newFont;
                } else {
                    run2.analysis.fNoGlyphIndex = false;
                }
            }
            if (!shapeSucceed && this.mLangFontLink2 != null) {
                long[] hNewFont = new long[1];
                int[] dwCodePages = new int[1];
                int[] cchCodePages = new int[1];
                this.mLangFontLink2.GetStrCodePages(chars, chars.length, 0, dwCodePages, cchCodePages);
                if (this.mLangFontLink2.MapFont(hdc, dwCodePages[0], chars[0], hNewFont) == 0) {
                    LOGFONT logFont = new LOGFONT();
                    OS.GetObject(hNewFont[0], LOGFONT.sizeof, logFont);
                    this.mLangFontLink2.ReleaseFont(hNewFont[0]);
                    long mLangFont = OS.CreateFontIndirect(logFont);
                    long oldFont = OS.SelectObject(hdc, mLangFont);
                    shapeSucceed = this.shape(hdc, run2, chars, buffer, maxGlyphs, sp);
                    if (shapeSucceed) {
                        run2.fallbackFont = mLangFont;
                    } else {
                        OS.SelectObject(hdc, oldFont);
                        OS.DeleteObject(mLangFont);
                    }
                }
            }
            if (!shapeSucceed) {
                OS.SelectObject(hdc, hFont);
            }
            if (newFont != 0L && newFont != run2.fallbackFont) {
                OS.DeleteObject(newFont);
            }
        }
        if (!shapeSucceed) {
            OS.ScriptShape(hdc, run2.psc, chars, chars.length, maxGlyphs, run2.analysis, run2.glyphs, run2.clusters, run2.visAttrs, buffer);
            run2.glyphCount = buffer[0];
        }
        int[] abc = new int[3];
        run2.advances = OS.HeapAlloc(hHeap, 8, run2.glyphCount * 4);
        if (run2.advances == 0L) {
            SWT.error(2);
        }
        run2.goffsets = OS.HeapAlloc(hHeap, 8, run2.glyphCount * 8);
        if (run2.goffsets == 0L) {
            SWT.error(2);
        }
        OS.ScriptPlace(hdc, run2.psc, run2.glyphs, run2.glyphCount, run2.visAttrs, run2.analysis, run2.advances, run2.goffsets, abc);
        run2.width = abc[0] + abc[1] + abc[2];
        TextStyle style = run2.style;
        if (style != null) {
            OUTLINETEXTMETRIC lotm = null;
            if ((style.underline || style.strikeout) && OS.GetOutlineTextMetrics(hdc, OUTLINETEXTMETRIC.sizeof, lotm = new OUTLINETEXTMETRIC()) == 0) {
                lotm = null;
            }
            if (style.metrics != null) {
                GlyphMetrics metrics = style.metrics;
                run2.width = metrics.getWidthInPixels() * Math.max(1, run2.glyphCount);
                run2.ascentInPoints = metrics.ascent;
                run2.descentInPoints = metrics.descent;
                run2.leadingInPoints = 0;
            } else {
                TEXTMETRIC lptm = null;
                if (lotm != null) {
                    lptm = lotm.otmTextMetrics;
                } else {
                    lptm = new TEXTMETRIC();
                    OS.GetTextMetrics(hdc, lptm);
                }
                run2.ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmAscent);
                run2.descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmDescent);
                run2.leadingInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmInternalLeading);
            }
            if (lotm != null) {
                run2.underlinePos = lotm.otmsUnderscorePosition;
                run2.underlineThickness = Math.max(1, lotm.otmsUnderscoreSize);
                run2.strikeoutPos = lotm.otmsStrikeoutPosition;
                run2.strikeoutThickness = Math.max(1, lotm.otmsStrikeoutSize);
            } else {
                run2.underlinePos = 1;
                run2.underlineThickness = 1;
                run2.strikeoutPos = DPIUtil.autoScaleUp((Drawable)this.getDevice(), run2.ascentInPoints) / 2;
                run2.strikeoutThickness = 1;
            }
            run2.ascentInPoints += style.rise;
            run2.descentInPoints -= style.rise;
        } else {
            TEXTMETRIC lptm = new TEXTMETRIC();
            OS.GetTextMetrics(hdc, lptm);
            run2.ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmAscent);
            run2.descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmDescent);
            run2.leadingInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmInternalLeading);
        }
    }

    int validadeOffset(int offset, int step) {
        offset = this.untranslateOffset(offset);
        return this.translateOffset(offset + step);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return offset;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return offset;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return offset;
            }
        }
        int i2 = 0;
        while (i2 < nSegments && offset - i2 >= this.segments[i2]) {
            ++offset;
            ++i2;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return offset;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return offset;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return offset;
            }
        }
        int i2 = 0;
        while (i2 < nSegments && offset > this.segments[i2]) {
            --offset;
            ++i2;
        }
        return offset;
    }

    public void setDefaultTabWidth(int tabLength) {
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        long psc = 0L;
        long glyphs;
        int glyphCount;
        long clusters;
        long visAttrs;
        long advances;
        long goffsets;
        int width;
        int ascentInPoints;
        int descentInPoints;
        int leadingInPoints;
        int x;
        int underlinePos;
        int underlineThickness;
        int strikeoutPos;
        int strikeoutThickness;
        long justify;
        long psla;
        long fallbackFont;

        StyleItem() {
        }

        void free() {
            long hHeap = OS.GetProcessHeap();
            if (this.psc != 0L) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(hHeap, 0, this.psc);
                this.psc = 0L;
            }
            if (this.glyphs != 0L) {
                OS.HeapFree(hHeap, 0, this.glyphs);
                this.glyphs = 0L;
                this.glyphCount = 0;
            }
            if (this.clusters != 0L) {
                OS.HeapFree(hHeap, 0, this.clusters);
                this.clusters = 0L;
            }
            if (this.visAttrs != 0L) {
                OS.HeapFree(hHeap, 0, this.visAttrs);
                this.visAttrs = 0L;
            }
            if (this.advances != 0L) {
                OS.HeapFree(hHeap, 0, this.advances);
                this.advances = 0L;
            }
            if (this.goffsets != 0L) {
                OS.HeapFree(hHeap, 0, this.goffsets);
                this.goffsets = 0L;
            }
            if (this.justify != 0L) {
                OS.HeapFree(hHeap, 0, this.justify);
                this.justify = 0L;
            }
            if (this.psla != 0L) {
                OS.HeapFree(hHeap, 0, this.psla);
                this.psla = 0L;
            }
            if (this.fallbackFont != 0L) {
                OS.DeleteObject(this.fallbackFont);
                this.fallbackFont = 0L;
            }
            this.x = 0;
            this.descentInPoints = 0;
            this.ascentInPoints = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

