/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldVector;
import org.apache.commons.math3.linear.FieldVectorChangingVisitor;
import org.apache.commons.math3.linear.FieldVectorPreservingVisitor;
import org.apache.commons.math3.linear.SparseFieldMatrix;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.OpenIntToFieldHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFieldVector<T extends FieldElement<T>>
implements FieldVector<T>,
Serializable {
    private static final long serialVersionUID = 7841233292190413362L;
    private final Field<T> field;
    private final OpenIntToFieldHashMap<T> entries;
    private final int virtualSize;

    public SparseFieldVector(Field<T> field2) {
        this(field2, 0);
    }

    public SparseFieldVector(Field<T> field2, int dimension) {
        this.field = field2;
        this.virtualSize = dimension;
        this.entries = new OpenIntToFieldHashMap<T>(field2);
    }

    protected SparseFieldVector(SparseFieldVector<T> v2, int resize) {
        this.field = v2.field;
        this.virtualSize = v2.getDimension() + resize;
        this.entries = new OpenIntToFieldHashMap<T>(v2.entries);
    }

    public SparseFieldVector(Field<T> field2, int dimension, int expectedSize) {
        this.field = field2;
        this.virtualSize = dimension;
        this.entries = new OpenIntToFieldHashMap<T>(field2, expectedSize);
    }

    public SparseFieldVector(Field<T> field2, T[] values2) throws NullArgumentException {
        MathUtils.checkNotNull(values2);
        this.field = field2;
        this.virtualSize = values2.length;
        this.entries = new OpenIntToFieldHashMap<T>(field2);
        for (int key2 = 0; key2 < values2.length; ++key2) {
            T value = values2[key2];
            this.entries.put(key2, value);
        }
    }

    public SparseFieldVector(SparseFieldVector<T> v2) {
        this.field = v2.field;
        this.virtualSize = v2.getDimension();
        this.entries = new OpenIntToFieldHashMap<T>(super.getEntries());
    }

    private OpenIntToFieldHashMap<T> getEntries() {
        return this.entries;
    }

    @Override
    public FieldVector<T> add(SparseFieldVector<T> v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        SparseFieldVector res = (SparseFieldVector)this.copy();
        OpenIntToFieldHashMap.Iterator iter = super.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key2 = iter.key();
            Object value = iter.value();
            if (this.entries.containsKey(key2)) {
                res.setEntry(key2, (FieldElement)this.entries.get(key2).add(value));
                continue;
            }
            res.setEntry(key2, value);
        }
        return res;
    }

    @Override
    public FieldVector<T> append(SparseFieldVector<T> v2) {
        SparseFieldVector res = new SparseFieldVector(this, v2.getDimension());
        OpenIntToFieldHashMap.Iterator iter = v2.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res.setEntry(iter.key() + this.virtualSize, iter.value());
        }
        return res;
    }

    @Override
    public FieldVector<T> append(FieldVector<T> v2) {
        if (v2 instanceof SparseFieldVector) {
            return this.append((T)((SparseFieldVector)v2));
        }
        int n2 = v2.getDimension();
        SparseFieldVector<T> res = new SparseFieldVector<T>(this, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            res.setEntry(i2 + this.virtualSize, v2.getEntry(i2));
        }
        return res;
    }

    @Override
    public FieldVector<T> append(T d2) throws NullArgumentException {
        MathUtils.checkNotNull(d2);
        SparseFieldVector<T> res = new SparseFieldVector<T>(this, 1);
        res.setEntry(this.virtualSize, d2);
        return res;
    }

    @Override
    public FieldVector<T> copy() {
        return new SparseFieldVector<T>(this);
    }

    @Override
    public T dotProduct(FieldVector<T> v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        FieldElement res = (FieldElement)this.field.getZero();
        OpenIntToFieldHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res = (FieldElement)res.add(v2.getEntry(iter.key()).multiply(iter.value()));
        }
        return (T)res;
    }

    @Override
    public FieldVector<T> ebeDivide(FieldVector<T> v2) throws DimensionMismatchException, MathArithmeticException {
        this.checkVectorDimensions(v2.getDimension());
        SparseFieldVector<FieldElement> res = new SparseFieldVector<FieldElement>(this);
        OpenIntToFieldHashMap.Iterator iter = res.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res.setEntry(iter.key(), (FieldElement)iter.value().divide(v2.getEntry(iter.key())));
        }
        return res;
    }

    @Override
    public FieldVector<T> ebeMultiply(FieldVector<T> v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        SparseFieldVector<FieldElement> res = new SparseFieldVector<FieldElement>(this);
        OpenIntToFieldHashMap.Iterator iter = res.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res.setEntry(iter.key(), (FieldElement)iter.value().multiply(v2.getEntry(iter.key())));
        }
        return res;
    }

    @Override
    @Deprecated
    public T[] getData() {
        return this.toArray();
    }

    @Override
    public int getDimension() {
        return this.virtualSize;
    }

    @Override
    public T getEntry(int index) throws OutOfRangeException {
        this.checkIndex(index);
        return this.entries.get(index);
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public FieldVector<T> getSubVector(int index, int n2) throws OutOfRangeException, NotPositiveException {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, n2);
        }
        this.checkIndex(index);
        this.checkIndex(index + n2 - 1);
        SparseFieldVector res = new SparseFieldVector(this.field, n2);
        int end = index + n2;
        OpenIntToFieldHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key2 = iter.key();
            if (key2 < index || key2 >= end) continue;
            res.setEntry(key2 - index, iter.value());
        }
        return res;
    }

    @Override
    public FieldVector<T> mapAdd(T d2) throws NullArgumentException {
        return this.copy().mapAddToSelf(d2);
    }

    @Override
    public FieldVector<T> mapAddToSelf(T d2) throws NullArgumentException {
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            this.setEntry(i2, (FieldElement)this.getEntry(i2).add(d2));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapDivide(T d2) throws NullArgumentException, MathArithmeticException {
        return this.copy().mapDivideToSelf(d2);
    }

    @Override
    public FieldVector<T> mapDivideToSelf(T d2) throws NullArgumentException, MathArithmeticException {
        OpenIntToFieldHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), (FieldElement)iter.value().divide(d2));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapInv() throws MathArithmeticException {
        return this.copy().mapInvToSelf();
    }

    @Override
    public FieldVector<T> mapInvToSelf() throws MathArithmeticException {
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            this.setEntry(i2, (FieldElement)((FieldElement)this.field.getOne()).divide(this.getEntry(i2)));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapMultiply(T d2) throws NullArgumentException {
        return this.copy().mapMultiplyToSelf(d2);
    }

    @Override
    public FieldVector<T> mapMultiplyToSelf(T d2) throws NullArgumentException {
        OpenIntToFieldHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.entries.put(iter.key(), (FieldElement)iter.value().multiply(d2));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapSubtract(T d2) throws NullArgumentException {
        return this.copy().mapSubtractToSelf(d2);
    }

    @Override
    public FieldVector<T> mapSubtractToSelf(T d2) throws NullArgumentException {
        return this.mapAddToSelf((FieldElement)((FieldElement)this.field.getZero()).subtract(d2));
    }

    @Override
    public FieldMatrix<T> outerProduct(SparseFieldVector<T> v2) {
        int n2 = v2.getDimension();
        SparseFieldMatrix<FieldElement> res = new SparseFieldMatrix<FieldElement>(this.field, this.virtualSize, n2);
        OpenIntToFieldHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            OpenIntToFieldHashMap.Iterator iter2 = v2.entries.iterator();
            while (iter2.hasNext()) {
                iter2.advance();
                res.setEntry(iter.key(), iter2.key(), (FieldElement)iter.value().multiply(iter2.value()));
            }
        }
        return res;
    }

    @Override
    public FieldMatrix<T> outerProduct(FieldVector<T> v2) {
        if (v2 instanceof SparseFieldVector) {
            return this.outerProduct((SparseFieldVector)v2);
        }
        int n2 = v2.getDimension();
        SparseFieldMatrix<FieldElement> res = new SparseFieldMatrix<FieldElement>(this.field, this.virtualSize, n2);
        OpenIntToFieldHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int row2 = iter.key();
            T value = iter.value();
            for (int col = 0; col < n2; ++col) {
                res.setEntry(row2, col, (FieldElement)value.multiply(v2.getEntry(col)));
            }
        }
        return res;
    }

    @Override
    public FieldVector<T> projection(FieldVector<T> v2) throws DimensionMismatchException, MathArithmeticException {
        this.checkVectorDimensions(v2.getDimension());
        return v2.mapMultiply((FieldElement)this.dotProduct(v2).divide(v2.dotProduct(v2)));
    }

    @Override
    public void set(T value) {
        MathUtils.checkNotNull(value);
        for (int i2 = 0; i2 < this.virtualSize; ++i2) {
            this.setEntry(i2, value);
        }
    }

    @Override
    public void setEntry(int index, T value) throws NullArgumentException, OutOfRangeException {
        MathUtils.checkNotNull(value);
        this.checkIndex(index);
        this.entries.put(index, value);
    }

    @Override
    public void setSubVector(int index, FieldVector<T> v2) throws OutOfRangeException {
        this.checkIndex(index);
        this.checkIndex(index + v2.getDimension() - 1);
        int n2 = v2.getDimension();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setEntry(i2 + index, v2.getEntry(i2));
        }
    }

    @Override
    public SparseFieldVector<T> subtract(SparseFieldVector<T> v2) throws DimensionMismatchException {
        this.checkVectorDimensions(v2.getDimension());
        SparseFieldVector res = (SparseFieldVector)this.copy();
        OpenIntToFieldHashMap.Iterator iter = super.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            int key2 = iter.key();
            if (this.entries.containsKey(key2)) {
                res.setEntry(key2, (FieldElement)this.entries.get(key2).subtract(iter.value()));
                continue;
            }
            res.setEntry(key2, (FieldElement)((FieldElement)this.field.getZero()).subtract(iter.value()));
        }
        return res;
    }

    @Override
    public FieldVector<T> subtract(FieldVector<T> v2) throws DimensionMismatchException {
        if (v2 instanceof SparseFieldVector) {
            return this.subtract((SparseFieldVector)v2);
        }
        int n2 = v2.getDimension();
        this.checkVectorDimensions(n2);
        SparseFieldVector<FieldElement> res = new SparseFieldVector<FieldElement>(this);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.entries.containsKey(i2)) {
                res.setEntry(i2, (FieldElement)this.entries.get(i2).subtract(v2.getEntry(i2)));
                continue;
            }
            res.setEntry(i2, (FieldElement)((FieldElement)this.field.getZero()).subtract(v2.getEntry(i2)));
        }
        return res;
    }

    @Override
    public T[] toArray() {
        FieldElement[] res = (FieldElement[])MathArrays.buildArray(this.field, this.virtualSize);
        OpenIntToFieldHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            res[iter.key()] = iter.value();
        }
        return res;
    }

    private void checkIndex(int index) throws OutOfRangeException {
        if (index < 0 || index >= this.getDimension()) {
            throw new OutOfRangeException(index, (Number)0, this.getDimension() - 1);
        }
    }

    private void checkIndices(int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        int dim = this.getDimension();
        if (start < 0 || start >= dim) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)start, 0, dim - 1);
        }
        if (end < 0 || end >= dim) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)end, 0, dim - 1);
        }
        if (end < start) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)end, start, false);
        }
    }

    protected void checkVectorDimensions(int n2) throws DimensionMismatchException {
        if (this.getDimension() != n2) {
            throw new DimensionMismatchException(this.getDimension(), n2);
        }
    }

    @Override
    public FieldVector<T> add(FieldVector<T> v2) throws DimensionMismatchException {
        if (v2 instanceof SparseFieldVector) {
            return this.add((SparseFieldVector)v2);
        }
        int n2 = v2.getDimension();
        this.checkVectorDimensions(n2);
        SparseFieldVector<FieldElement> res = new SparseFieldVector<FieldElement>(this.field, this.getDimension());
        for (int i2 = 0; i2 < n2; ++i2) {
            res.setEntry(i2, (FieldElement)v2.getEntry(i2).add(this.getEntry(i2)));
        }
        return res;
    }

    public T walkInDefaultOrder(FieldVectorPreservingVisitor<T> visitor2) {
        int dim = this.getDimension();
        visitor2.start(dim, 0, dim - 1);
        for (int i2 = 0; i2 < dim; ++i2) {
            visitor2.visit(i2, this.getEntry(i2));
        }
        return visitor2.end();
    }

    public T walkInDefaultOrder(FieldVectorPreservingVisitor<T> visitor2, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(start, end);
        visitor2.start(this.getDimension(), start, end);
        for (int i2 = start; i2 <= end; ++i2) {
            visitor2.visit(i2, this.getEntry(i2));
        }
        return visitor2.end();
    }

    public T walkInOptimizedOrder(FieldVectorPreservingVisitor<T> visitor2) {
        return this.walkInDefaultOrder(visitor2);
    }

    public T walkInOptimizedOrder(FieldVectorPreservingVisitor<T> visitor2, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(visitor2, start, end);
    }

    public T walkInDefaultOrder(FieldVectorChangingVisitor<T> visitor2) {
        int dim = this.getDimension();
        visitor2.start(dim, 0, dim - 1);
        for (int i2 = 0; i2 < dim; ++i2) {
            this.setEntry(i2, visitor2.visit(i2, this.getEntry(i2)));
        }
        return visitor2.end();
    }

    public T walkInDefaultOrder(FieldVectorChangingVisitor<T> visitor2, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(start, end);
        visitor2.start(this.getDimension(), start, end);
        for (int i2 = start; i2 <= end; ++i2) {
            this.setEntry(i2, visitor2.visit(i2, this.getEntry(i2)));
        }
        return visitor2.end();
    }

    public T walkInOptimizedOrder(FieldVectorChangingVisitor<T> visitor2) {
        return this.walkInDefaultOrder(visitor2);
    }

    public T walkInOptimizedOrder(FieldVectorChangingVisitor<T> visitor2, int start, int end) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(visitor2, start, end);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.field == null ? 0 : this.field.hashCode());
        result2 = 31 * result2 + this.virtualSize;
        OpenIntToFieldHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int temp = iter.value().hashCode();
            result2 = 31 * result2 + temp;
        }
        return result2;
    }

    public boolean equals(Object obj) {
        T test;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SparseFieldVector)) {
            return false;
        }
        SparseFieldVector other = (SparseFieldVector)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.virtualSize != other.virtualSize) {
            return false;
        }
        OpenIntToFieldHashMap.Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            test = other.getEntry(iter.key());
            if (test.equals(iter.value())) continue;
            return false;
        }
        iter = other.getEntries().iterator();
        while (iter.hasNext()) {
            iter.advance();
            test = iter.value();
            if (test.equals(this.getEntry(iter.key()))) continue;
            return false;
        }
        return true;
    }
}

