/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class GridLayout
extends Layout {
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;

    public GridLayout() {
    }

    public GridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        this.numColumns = numColumns;
        this.makeColumnsEqualWidth = makeColumnsEqualWidth;
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = this.layout(composite, false, 0, 0, wHint, hHint, flushCache);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    @Override
    protected boolean flushCache(Control control) {
        Object data2 = control.getLayoutData();
        if (data2 != null) {
            ((GridData)data2).flushCache();
        }
        return true;
    }

    GridData getData(Control[][] grid, int row2, int column2, int rowCount, int columnCount, boolean first) {
        Control control = grid[row2][column2];
        if (control != null) {
            int j2;
            GridData data2 = (GridData)control.getLayoutData();
            int hSpan = Math.max(1, Math.min(data2.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data2.verticalSpan);
            int i2 = first ? row2 + vSpan - 1 : row2 - vSpan + 1;
            int n2 = j2 = first ? column2 + hSpan - 1 : column2 - hSpan + 1;
            if (i2 >= 0 && i2 < rowCount && j2 >= 0 && j2 < columnCount && control == grid[i2][j2]) {
                return data2;
            }
        }
        return null;
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        this.layout(composite, true, rect.x, rect.y, rect.width, rect.height, flushCache);
    }

    Point layout(Composite composite, boolean move2, int x2, int y2, int width, int height, boolean flushCache) {
        int k2;
        int k3;
        int i2;
        int k4;
        int last;
        int i3;
        int j2;
        GridData data2;
        if (this.numColumns < 1) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        Control[] children = composite.getChildren();
        int count = 0;
        int i4 = 0;
        while (i4 < children.length) {
            Control control = children[i4];
            data2 = (GridData)control.getLayoutData();
            if (data2 == null || !data2.exclude) {
                children[count++] = children[i4];
            }
            ++i4;
        }
        if (count == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        i4 = 0;
        while (i4 < count) {
            Control child = children[i4];
            data2 = (GridData)child.getLayoutData();
            if (data2 == null) {
                data2 = new GridData();
                child.setLayoutData(data2);
            }
            if (flushCache) {
                data2.flushCache();
            }
            data2.computeSize(child, data2.widthHint, data2.heightHint, flushCache);
            if (data2.grabExcessHorizontalSpace && data2.minimumWidth > 0 && data2.cacheWidth < data2.minimumWidth) {
                int trim = 0;
                if (child instanceof Scrollable) {
                    Rectangle rect = ((Scrollable)child).computeTrim(0, 0, 0, 0);
                    trim = rect.width;
                } else {
                    trim = child.getBorderWidth() * 2;
                }
                data2.cacheHeight = -1;
                data2.cacheWidth = -1;
                data2.computeSize(child, Math.max(0, data2.minimumWidth - trim), data2.heightHint, false);
            }
            if (data2.grabExcessVerticalSpace && data2.minimumHeight > 0) {
                data2.cacheHeight = Math.max(data2.cacheHeight, data2.minimumHeight);
            }
            ++i4;
        }
        int row2 = 0;
        int column2 = 0;
        int rowCount = 0;
        int columnCount = this.numColumns;
        Control[][] grid = new Control[4][columnCount];
        int i5 = 0;
        while (i5 < count) {
            Control child = children[i5];
            GridData data3 = (GridData)child.getLayoutData();
            int hSpan = Math.max(1, Math.min(data3.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data3.verticalSpan);
            while (true) {
                int lastRow;
                if ((lastRow = row2 + vSpan) >= grid.length) {
                    Control[][] newGrid = new Control[lastRow + 4][columnCount];
                    System.arraycopy(grid, 0, newGrid, 0, grid.length);
                    grid = newGrid;
                }
                if (grid[row2] == null) {
                    grid[row2] = new Control[columnCount];
                }
                while (column2 < columnCount && grid[row2][column2] != null) {
                    ++column2;
                }
                int endCount = column2 + hSpan;
                if (endCount <= columnCount) {
                    int index = column2;
                    while (index < endCount && grid[row2][index] == null) {
                        ++index;
                    }
                    if (index == endCount) break;
                    column2 = index;
                }
                if (column2 + hSpan < columnCount) continue;
                column2 = 0;
                ++row2;
            }
            j2 = 0;
            while (j2 < vSpan) {
                if (grid[row2 + j2] == null) {
                    grid[row2 + j2] = new Control[columnCount];
                }
                int k5 = 0;
                while (k5 < hSpan) {
                    grid[row2 + j2][column2 + k5] = child;
                    ++k5;
                }
                ++j2;
            }
            rowCount = Math.max(rowCount, row2 + vSpan);
            column2 += hSpan;
            ++i5;
        }
        int availableWidth = width - this.horizontalSpacing * (columnCount - 1) - (this.marginLeft + this.marginWidth * 2 + this.marginRight);
        int expandCount = 0;
        int[] widths = new int[columnCount];
        int[] minWidths = new int[columnCount];
        boolean[] expandColumn = new boolean[columnCount];
        j2 = 0;
        while (j2 < columnCount) {
            int hSpan;
            i3 = 0;
            while (i3 < rowCount) {
                GridData data4 = this.getData(grid, i3, j2, rowCount, columnCount, true);
                if (data4 != null && (hSpan = Math.max(1, Math.min(data4.horizontalSpan, columnCount))) == 1) {
                    int w2 = data4.cacheWidth + data4.horizontalIndent;
                    widths[j2] = Math.max(widths[j2], w2);
                    if (data4.grabExcessHorizontalSpace) {
                        if (!expandColumn[j2]) {
                            ++expandCount;
                        }
                        expandColumn[j2] = true;
                    }
                    if (!data4.grabExcessHorizontalSpace || data4.minimumWidth != 0) {
                        w2 = !data4.grabExcessHorizontalSpace || data4.minimumWidth == -1 ? data4.cacheWidth : data4.minimumWidth;
                        minWidths[j2] = Math.max(minWidths[j2], w2 += data4.horizontalIndent);
                    }
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < rowCount) {
                GridData data5 = this.getData(grid, i3, j2, rowCount, columnCount, false);
                if (data5 != null && (hSpan = Math.max(1, Math.min(data5.horizontalSpan, columnCount))) > 1) {
                    int delta;
                    int remainder;
                    int w3;
                    int spanWidth = 0;
                    int spanMinWidth = 0;
                    int spanExpandCount = 0;
                    int k6 = 0;
                    while (k6 < hSpan) {
                        spanWidth += widths[j2 - k6];
                        spanMinWidth += minWidths[j2 - k6];
                        if (expandColumn[j2 - k6]) {
                            ++spanExpandCount;
                        }
                        ++k6;
                    }
                    if (data5.grabExcessHorizontalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandColumn[j2] = true;
                    }
                    if ((w3 = data5.cacheWidth + data5.horizontalIndent - spanWidth - (hSpan - 1) * this.horizontalSpacing) > 0) {
                        if (this.makeColumnsEqualWidth) {
                            int equalWidth = (w3 + spanWidth) / hSpan;
                            remainder = (w3 + spanWidth) % hSpan;
                            last = -1;
                            k4 = 0;
                            while (k4 < hSpan) {
                                last = j2 - k4;
                                widths[last] = Math.max(equalWidth, widths[j2 - k4]);
                                ++k4;
                            }
                            if (last > -1) {
                                int n2 = last;
                                widths[n2] = widths[n2] + remainder;
                            }
                        } else if (spanExpandCount == 0) {
                            int n3 = j2;
                            widths[n3] = widths[n3] + w3;
                        } else {
                            delta = w3 / spanExpandCount;
                            remainder = w3 % spanExpandCount;
                            last = -1;
                            k4 = 0;
                            while (k4 < hSpan) {
                                if (expandColumn[j2 - k4]) {
                                    last = j2 - k4;
                                    widths[last] = widths[last] + delta;
                                }
                                ++k4;
                            }
                            if (last > -1) {
                                int n4 = last;
                                widths[n4] = widths[n4] + remainder;
                            }
                        }
                    }
                    if (!data5.grabExcessHorizontalSpace || data5.minimumWidth != 0) {
                        int n5 = w3 = !data5.grabExcessHorizontalSpace || data5.minimumWidth == -1 ? data5.cacheWidth : data5.minimumWidth;
                        if ((w3 += data5.horizontalIndent - spanMinWidth - (hSpan - 1) * this.horizontalSpacing) > 0) {
                            if (spanExpandCount == 0) {
                                int n6 = j2;
                                minWidths[n6] = minWidths[n6] + w3;
                            } else {
                                delta = w3 / spanExpandCount;
                                remainder = w3 % spanExpandCount;
                                last = -1;
                                k4 = 0;
                                while (k4 < hSpan) {
                                    if (expandColumn[j2 - k4]) {
                                        last = j2 - k4;
                                        minWidths[last] = minWidths[last] + delta;
                                    }
                                    ++k4;
                                }
                                if (last > -1) {
                                    int n7 = last;
                                    minWidths[n7] = minWidths[n7] + remainder;
                                }
                            }
                        }
                    }
                }
                ++i3;
            }
            ++j2;
        }
        if (this.makeColumnsEqualWidth) {
            int minColumnWidth = 0;
            int columnWidth = 0;
            int i6 = 0;
            while (i6 < columnCount) {
                minColumnWidth = Math.max(minColumnWidth, minWidths[i6]);
                columnWidth = Math.max(columnWidth, widths[i6]);
                ++i6;
            }
            columnWidth = width == -1 || expandCount == 0 ? columnWidth : Math.max(minColumnWidth, availableWidth / columnCount);
            i6 = 0;
            while (i6 < columnCount) {
                expandColumn[i6] = expandCount > 0;
                widths[i6] = columnWidth;
                ++i6;
            }
        } else if (width != -1 && expandCount > 0) {
            int totalWidth = 0;
            i3 = 0;
            while (i3 < columnCount) {
                totalWidth += widths[i3];
                ++i3;
            }
            int c2 = expandCount;
            int delta = (availableWidth - totalWidth) / c2;
            int remainder = (availableWidth - totalWidth) % c2;
            int last2 = -1;
            while (totalWidth != availableWidth) {
                int j3 = 0;
                while (j3 < columnCount) {
                    if (expandColumn[j3]) {
                        if (widths[j3] + delta > minWidths[j3]) {
                            last2 = j3;
                            widths[last2] = widths[j3] + delta;
                        } else {
                            widths[j3] = minWidths[j3];
                            expandColumn[j3] = false;
                            --c2;
                        }
                    }
                    ++j3;
                }
                if (last2 > -1) {
                    int n8 = last2;
                    widths[n8] = widths[n8] + remainder;
                }
                j3 = 0;
                while (j3 < columnCount) {
                    i2 = 0;
                    while (i2 < rowCount) {
                        int hSpan;
                        GridData data6 = this.getData(grid, i2, j3, rowCount, columnCount, false);
                        if (!(data6 == null || (hSpan = Math.max(1, Math.min(data6.horizontalSpan, columnCount))) <= 1 || data6.grabExcessHorizontalSpace && data6.minimumWidth == 0)) {
                            int w4;
                            int spanWidth = 0;
                            int spanExpandCount = 0;
                            k4 = 0;
                            while (k4 < hSpan) {
                                spanWidth += widths[j3 - k4];
                                if (expandColumn[j3 - k4]) {
                                    ++spanExpandCount;
                                }
                                ++k4;
                            }
                            int n9 = w4 = !data6.grabExcessHorizontalSpace || data6.minimumWidth == -1 ? data6.cacheWidth : data6.minimumWidth;
                            if ((w4 += data6.horizontalIndent - spanWidth - (hSpan - 1) * this.horizontalSpacing) > 0) {
                                if (spanExpandCount == 0) {
                                    int n10 = j3;
                                    widths[n10] = widths[n10] + w4;
                                } else {
                                    int delta2 = w4 / spanExpandCount;
                                    int remainder2 = w4 % spanExpandCount;
                                    int last22 = -1;
                                    k3 = 0;
                                    while (k3 < hSpan) {
                                        if (expandColumn[j3 - k3]) {
                                            last22 = j3 - k3;
                                            widths[last22] = widths[last22] + delta2;
                                        }
                                        ++k3;
                                    }
                                    if (last22 > -1) {
                                        int n11 = last22;
                                        widths[n11] = widths[n11] + remainder2;
                                    }
                                }
                            }
                        }
                        ++i2;
                    }
                    ++j3;
                }
                if (c2 != 0) {
                    totalWidth = 0;
                    int i7 = 0;
                    while (i7 < columnCount) {
                        totalWidth += widths[i7];
                        ++i7;
                    }
                    delta = (availableWidth - totalWidth) / c2;
                    remainder = (availableWidth - totalWidth) % c2;
                    last2 = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] flush = null;
        int flushLength = 0;
        if (width != -1) {
            int j4 = 0;
            while (j4 < columnCount) {
                int i8 = 0;
                while (i8 < rowCount) {
                    GridData data7 = this.getData(grid, i8, j4, rowCount, columnCount, false);
                    if (data7 != null && data7.heightHint == -1) {
                        Control child = grid[i8][j4];
                        int hSpan = Math.max(1, Math.min(data7.horizontalSpan, columnCount));
                        int currentWidth = 0;
                        int k7 = 0;
                        while (k7 < hSpan) {
                            currentWidth += widths[j4 - k7];
                            ++k7;
                        }
                        if ((currentWidth += (hSpan - 1) * this.horizontalSpacing - data7.horizontalIndent) != data7.cacheWidth && data7.horizontalAlignment == 4 || data7.cacheWidth > currentWidth) {
                            int trim = 0;
                            if (child instanceof Scrollable) {
                                Rectangle rect = ((Scrollable)child).computeTrim(0, 0, 0, 0);
                                trim = rect.width;
                            } else {
                                trim = child.getBorderWidth() * 2;
                            }
                            data7.cacheHeight = -1;
                            data7.cacheWidth = -1;
                            data7.computeSize(child, Math.max(0, currentWidth - trim), data7.heightHint, false);
                            if (data7.grabExcessVerticalSpace && data7.minimumHeight > 0) {
                                data7.cacheHeight = Math.max(data7.cacheHeight, data7.minimumHeight);
                            }
                            if (flush == null) {
                                flush = new GridData[count];
                            }
                            flush[flushLength++] = data7;
                        }
                    }
                    ++i8;
                }
                ++j4;
            }
        }
        int availableHeight = height - this.verticalSpacing * (rowCount - 1) - (this.marginTop + this.marginHeight * 2 + this.marginBottom);
        expandCount = 0;
        int[] heights = new int[rowCount];
        int[] minHeights = new int[rowCount];
        boolean[] expandRow = new boolean[rowCount];
        i2 = 0;
        while (i2 < rowCount) {
            int j5 = 0;
            while (j5 < columnCount) {
                int vSpan;
                GridData data8 = this.getData(grid, i2, j5, rowCount, columnCount, true);
                if (data8 != null && (vSpan = Math.max(1, Math.min(data8.verticalSpan, rowCount))) == 1) {
                    int h2 = data8.cacheHeight + data8.verticalIndent;
                    heights[i2] = Math.max(heights[i2], h2);
                    if (data8.grabExcessVerticalSpace) {
                        if (!expandRow[i2]) {
                            ++expandCount;
                        }
                        expandRow[i2] = true;
                    }
                    if (!data8.grabExcessVerticalSpace || data8.minimumHeight != 0) {
                        h2 = !data8.grabExcessVerticalSpace || data8.minimumHeight == -1 ? data8.cacheHeight : data8.minimumHeight;
                        minHeights[i2] = Math.max(minHeights[i2], h2 += data8.verticalIndent);
                    }
                }
                ++j5;
            }
            j5 = 0;
            while (j5 < columnCount) {
                int vSpan;
                GridData data9 = this.getData(grid, i2, j5, rowCount, columnCount, false);
                if (data9 != null && (vSpan = Math.max(1, Math.min(data9.verticalSpan, rowCount))) > 1) {
                    int last3;
                    int remainder;
                    int delta;
                    int h3;
                    int spanHeight = 0;
                    int spanMinHeight = 0;
                    int spanExpandCount = 0;
                    int k8 = 0;
                    while (k8 < vSpan) {
                        spanHeight += heights[i2 - k8];
                        spanMinHeight += minHeights[i2 - k8];
                        if (expandRow[i2 - k8]) {
                            ++spanExpandCount;
                        }
                        ++k8;
                    }
                    if (data9.grabExcessVerticalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandRow[i2] = true;
                    }
                    if ((h3 = data9.cacheHeight + data9.verticalIndent - spanHeight - (vSpan - 1) * this.verticalSpacing) > 0) {
                        if (spanExpandCount == 0) {
                            int n12 = i2;
                            heights[n12] = heights[n12] + h3;
                        } else {
                            delta = h3 / spanExpandCount;
                            remainder = h3 % spanExpandCount;
                            last3 = -1;
                            k2 = 0;
                            while (k2 < vSpan) {
                                if (expandRow[i2 - k2]) {
                                    last3 = i2 - k2;
                                    heights[last3] = heights[last3] + delta;
                                }
                                ++k2;
                            }
                            if (last3 > -1) {
                                int n13 = last3;
                                heights[n13] = heights[n13] + remainder;
                            }
                        }
                    }
                    if (!data9.grabExcessVerticalSpace || data9.minimumHeight != 0) {
                        int n14 = h3 = !data9.grabExcessVerticalSpace || data9.minimumHeight == -1 ? data9.cacheHeight : data9.minimumHeight;
                        if ((h3 += data9.verticalIndent - spanMinHeight - (vSpan - 1) * this.verticalSpacing) > 0) {
                            if (spanExpandCount == 0) {
                                int n15 = i2;
                                minHeights[n15] = minHeights[n15] + h3;
                            } else {
                                delta = h3 / spanExpandCount;
                                remainder = h3 % spanExpandCount;
                                last3 = -1;
                                k2 = 0;
                                while (k2 < vSpan) {
                                    if (expandRow[i2 - k2]) {
                                        last3 = i2 - k2;
                                        minHeights[last3] = minHeights[last3] + delta;
                                    }
                                    ++k2;
                                }
                                if (last3 > -1) {
                                    int n16 = last3;
                                    minHeights[n16] = minHeights[n16] + remainder;
                                }
                            }
                        }
                    }
                }
                ++j5;
            }
            ++i2;
        }
        if (height != -1 && expandCount > 0) {
            int totalHeight = 0;
            int i9 = 0;
            while (i9 < rowCount) {
                totalHeight += heights[i9];
                ++i9;
            }
            int c3 = expandCount;
            int delta = (availableHeight - totalHeight) / c3;
            int remainder = (availableHeight - totalHeight) % c3;
            last = -1;
            while (totalHeight != availableHeight) {
                int i10 = 0;
                while (i10 < rowCount) {
                    if (expandRow[i10]) {
                        if (heights[i10] + delta > minHeights[i10]) {
                            last = i10;
                            heights[last] = heights[i10] + delta;
                        } else {
                            heights[i10] = minHeights[i10];
                            expandRow[i10] = false;
                            --c3;
                        }
                    }
                    ++i10;
                }
                if (last > -1) {
                    int n17 = last;
                    heights[n17] = heights[n17] + remainder;
                }
                i10 = 0;
                while (i10 < rowCount) {
                    int j6 = 0;
                    while (j6 < columnCount) {
                        int vSpan;
                        GridData data10 = this.getData(grid, i10, j6, rowCount, columnCount, false);
                        if (!(data10 == null || (vSpan = Math.max(1, Math.min(data10.verticalSpan, rowCount))) <= 1 || data10.grabExcessVerticalSpace && data10.minimumHeight == 0)) {
                            int h4;
                            int spanHeight = 0;
                            int spanExpandCount = 0;
                            k2 = 0;
                            while (k2 < vSpan) {
                                spanHeight += heights[i10 - k2];
                                if (expandRow[i10 - k2]) {
                                    ++spanExpandCount;
                                }
                                ++k2;
                            }
                            int n18 = h4 = !data10.grabExcessVerticalSpace || data10.minimumHeight == -1 ? data10.cacheHeight : data10.minimumHeight;
                            if ((h4 += data10.verticalIndent - spanHeight - (vSpan - 1) * this.verticalSpacing) > 0) {
                                if (spanExpandCount == 0) {
                                    int n19 = i10;
                                    heights[n19] = heights[n19] + h4;
                                } else {
                                    int delta2 = h4 / spanExpandCount;
                                    int remainder2 = h4 % spanExpandCount;
                                    int last2 = -1;
                                    int k9 = 0;
                                    while (k9 < vSpan) {
                                        if (expandRow[i10 - k9]) {
                                            last2 = i10 - k9;
                                            heights[last2] = heights[last2] + delta2;
                                        }
                                        ++k9;
                                    }
                                    if (last2 > -1) {
                                        int n20 = last2;
                                        heights[n20] = heights[n20] + remainder2;
                                    }
                                }
                            }
                        }
                        ++j6;
                    }
                    ++i10;
                }
                if (c3 == 0) break;
                totalHeight = 0;
                i10 = 0;
                while (i10 < rowCount) {
                    totalHeight += heights[i10];
                    ++i10;
                }
                delta = (availableHeight - totalHeight) / c3;
                remainder = (availableHeight - totalHeight) % c3;
                last = -1;
            }
        }
        if (move2) {
            int gridY = y2 + this.marginTop + this.marginHeight;
            int i11 = 0;
            while (i11 < rowCount) {
                int gridX = x2 + this.marginLeft + this.marginWidth;
                int j7 = 0;
                while (j7 < columnCount) {
                    GridData data11 = this.getData(grid, i11, j7, rowCount, columnCount, true);
                    if (data11 != null) {
                        int hSpan = Math.max(1, Math.min(data11.horizontalSpan, columnCount));
                        int vSpan = Math.max(1, data11.verticalSpan);
                        int cellWidth = 0;
                        int cellHeight = 0;
                        k3 = 0;
                        while (k3 < hSpan) {
                            cellWidth += widths[j7 + k3];
                            ++k3;
                        }
                        k3 = 0;
                        while (k3 < vSpan) {
                            cellHeight += heights[i11 + k3];
                            ++k3;
                        }
                        int childX = gridX + data11.horizontalIndent;
                        int childWidth = Math.min(data11.cacheWidth, cellWidth += this.horizontalSpacing * (hSpan - 1));
                        switch (data11.horizontalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                childX += Math.max(0, (cellWidth - data11.horizontalIndent - childWidth) / 2);
                                break;
                            }
                            case 3: 
                            case 131072: 
                            case 0x1000008: {
                                childX += Math.max(0, cellWidth - data11.horizontalIndent - childWidth);
                                break;
                            }
                            case 4: {
                                childWidth = cellWidth - data11.horizontalIndent;
                            }
                        }
                        int childY = gridY + data11.verticalIndent;
                        int childHeight = Math.min(data11.cacheHeight, cellHeight += this.verticalSpacing * (vSpan - 1));
                        switch (data11.verticalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                childY += Math.max(0, (cellHeight - data11.verticalIndent - childHeight) / 2);
                                break;
                            }
                            case 3: 
                            case 1024: 
                            case 0x1000008: {
                                childY += Math.max(0, cellHeight - data11.verticalIndent - childHeight);
                                break;
                            }
                            case 4: {
                                childHeight = cellHeight - data11.verticalIndent;
                            }
                        }
                        Control child = grid[i11][j7];
                        if (child != null) {
                            child.setBounds(childX, childY, childWidth, childHeight);
                        }
                    }
                    gridX += widths[j7] + this.horizontalSpacing;
                    ++j7;
                }
                gridY += heights[i11] + this.verticalSpacing;
                ++i11;
            }
        }
        i2 = 0;
        while (i2 < flushLength) {
            flush[i2].cacheHeight = -1;
            flush[i2].cacheWidth = -1;
            ++i2;
        }
        int totalDefaultWidth = 0;
        int totalDefaultHeight = 0;
        int i12 = 0;
        while (i12 < columnCount) {
            totalDefaultWidth += widths[i12];
            ++i12;
        }
        i12 = 0;
        while (i12 < rowCount) {
            totalDefaultHeight += heights[i12];
            ++i12;
        }
        return new Point(totalDefaultWidth += this.horizontalSpacing * (columnCount - 1) + this.marginLeft + this.marginWidth * 2 + this.marginRight, totalDefaultHeight += this.verticalSpacing * (rowCount - 1) + this.marginTop + this.marginHeight * 2 + this.marginBottom);
    }

    String getName() {
        String string2 = this.getClass().getName();
        int index = string2.lastIndexOf(46);
        if (index == -1) {
            return string2;
        }
        return string2.substring(index + 1, string2.length());
    }

    public String toString() {
        String string2 = String.valueOf(this.getName()) + " {";
        if (this.numColumns != 1) {
            string2 = String.valueOf(string2) + "numColumns=" + this.numColumns + " ";
        }
        if (this.makeColumnsEqualWidth) {
            string2 = String.valueOf(string2) + "makeColumnsEqualWidth=" + this.makeColumnsEqualWidth + " ";
        }
        if (this.marginWidth != 0) {
            string2 = String.valueOf(string2) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string2 = String.valueOf(string2) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string2 = String.valueOf(string2) + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            string2 = String.valueOf(string2) + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            string2 = String.valueOf(string2) + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            string2 = String.valueOf(string2) + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.horizontalSpacing != 0) {
            string2 = String.valueOf(string2) + "horizontalSpacing=" + this.horizontalSpacing + " ";
        }
        if (this.verticalSpacing != 0) {
            string2 = String.valueOf(string2) + "verticalSpacing=" + this.verticalSpacing + " ";
        }
        string2 = string2.trim();
        string2 = String.valueOf(string2) + "}";
        return string2;
    }
}

