/*
 * Decompiled with CFR 0.152.
 */
package gde.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final String lineSep = System.getProperty("line.separator");
    Date date = new Date();
    private static final String format = "{0,date,yyyy-MM-dd HH:mm:ss.SSS} {1,number,000000} {2} {3}.{4}() - {5}" + lineSep;
    private Object[] args = new Object[6];
    private MessageFormat formatter;

    @Override
    public synchronized String format(LogRecord logRecord) {
        this.date.setTime(logRecord.getMillis());
        this.args[0] = this.date;
        this.args[1] = logRecord.getThreadID();
        this.args[2] = String.format("%-7s", logRecord.getLevel());
        this.args[3] = logRecord.getLoggerName();
        this.args[4] = logRecord.getSourceMethodName();
        this.args[5] = logRecord.getParameters() != null && logRecord.getParameters().length > 0 ? (logRecord.getParameters()[0] == null ? logRecord.getMessage() : (logRecord.getParameters()[0] instanceof String ? logRecord.getMessage() + " " + (String)logRecord.getParameters()[0] : (logRecord.getParameters()[0] instanceof Number ? logRecord.getMessage() + " " + NumberFormat.getInstance().format(logRecord.getParameters()[0]) : (logRecord.getParameters()[0] instanceof Date ? logRecord.getMessage() + " " + DateFormat.getDateTimeInstance(3, 3).format(logRecord.getParameters()[0]) : logRecord.getMessage() + " " + logRecord.getParameters()[0].toString())))) : logRecord.getMessage();
        StringBuffer text = new StringBuffer();
        if (this.formatter == null) {
            this.formatter = new MessageFormat(format);
        }
        this.formatter.format(this.args, text, (FieldPosition)null);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                logRecord.getThrown().printStackTrace(pw);
                pw.close();
                text.append(sw.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return text.toString();
    }
}

