/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.MissMatchDeviceException;
import gde.exception.NotSupportedFileFormatException;
import gde.exception.UnitCompareException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.logging.Logger;

public class CSVReaderWriter {
    static Logger log = Logger.getLogger(CSVReaderWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;

    public static HashMap<String, String> getHeader(char separator, String filePath) throws NotSupportedFileFormatException, IOException {
        HashMap<String, String> header;
        block12: {
            String line = "*";
            header = new HashMap<String, String>();
            try (BufferedReader reader = null;){
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
                line = reader.readLine();
                String[] headerData = line.split("" + separator);
                if (headerData.length > 2) {
                    NotSupportedFileFormatException e = new NotSupportedFileFormatException("File does have required header information \"device_name[separator<channel/config_name>]\"");
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw e;
                }
                for (int i = 0; i < headerData.length; ++i) {
                    if (i == 0) {
                        header.put("DeviceName : ", headerData[i].split("\\r")[0].trim());
                    }
                    if (i != 1) continue;
                    header.put("Channel/Configuration Name: ", headerData[i].split(" ")[0].split("\\r")[0].trim());
                }
                while (!((line = reader.readLine()) == null || line.contains("[") && line.contains("]"))) {
                }
                header.put("CSV_data_header : ", line);
                if (header.size() >= 1) {
                    log.log(Level.FINE, "DeviceName : " + (String)header.get("DeviceName : "));
                    log.log(Level.FINE, "Channel/Configuration Name: " + (header.get("Channel/Configuration Name: ") != null ? (String)header.get("Channel/Configuration Name: ") : ""));
                    log.log(Level.FINE, "CSV_data_header : " + (header.get("CSV_data_header : ") != null ? (String)header.get("CSV_data_header : ") : ""));
                    break block12;
                }
                NotSupportedFileFormatException e = new NotSupportedFileFormatException("File does have required header information \"device_name[separator<channel/config_name>]\"");
                log.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
        }
        return header;
    }

    public static HashMap<String, String> evaluateType(char separator, HashMap<String, String> header, DeviceConfiguration deviceConfig) {
        int index = 0;
        int innerIndex = 0;
        int countRaw = 0;
        int countAbs = 0;
        StringBuilder sb_measurements = new StringBuilder();
        StringBuilder sb_units = new StringBuilder();
        boolean isRaw = false;
        String headerLine = header.get("CSV_data_header : ");
        while ((index = headerLine.indexOf(91, index + 1)) != -1) {
            innerIndex = headerLine.indexOf(93, index + 1);
            if (innerIndex != -1) {
                String subString = headerLine.substring(index + 1, innerIndex);
                if (subString.split("-").length == 0) {
                    ++countRaw;
                } else {
                    ++countAbs;
                }
            }
            ++index;
        }
        String[] headerLineArray = headerLine.split("" + separator);
        if (countAbs <= 1 && countRaw > 0 || headerLineArray.length - 1 < deviceConfig.getNumberOfMeasurements(1)) {
            header.put("CSV_data_type : ", "raw");
            isRaw = true;
        } else {
            header.put("CSV_data_type : ", "abs");
            isRaw = false;
        }
        log.log(Level.FINE, "CSV_data_type : " + header.get("CSV_data_type : "));
        String channelConfig = header.get("Channel/Configuration Name: ");
        int channelNumber = channels.getChannelNumber(channelConfig);
        if (channelConfig != null && !channels.getActiveChannel().getChannelConfigKey().equals(channelConfig) && channelNumber >= 1 && channelNumber <= deviceConfig.getChannelCount()) {
            channels.setActiveChannelNumber(channelNumber);
        } else {
            channelConfig = channels.getActiveChannel().getChannelConfigKey();
            channels.setActiveChannelNumber(channels.getActiveChannelNumber());
            channelNumber = channels.getActiveChannelNumber();
        }
        header.put("Channel/Configuration Name: ", channelConfig);
        header.put("Channel/Configuration Number : ", "" + channels.getActiveChannelNumber());
        log.log(Level.FINE, "Channel/Configuration Name: " + header.get("Channel/Configuration Number : ") + " : " + header.get("Channel/Configuration Name: "));
        int match = 0;
        StringBuilder unitCompare = new StringBuilder().append(lineSep);
        for (int i = 1; i < headerLineArray.length; ++i) {
            String expectUnit = deviceConfig.getMeasurementUnit(channelNumber, i - 1);
            String[] inHeaderMeasurement = headerLineArray[i].trim().split("\\[|]");
            String inMeasurement = inHeaderMeasurement.length >= 1 ? inHeaderMeasurement[0].trim() : "---";
            String inUnit = inHeaderMeasurement.length == 2 ? inHeaderMeasurement[1].trim() : "---";
            sb_measurements.append(inMeasurement).append(";");
            sb_units.append(inUnit).append(";");
            unitCompare.append(String.format("%-30s \t%s \n", inMeasurement, Messages.getString("GDE_MSGT0136", new Object[]{inUnit, expectUnit})));
            if (!inUnit.equals(expectUnit) && !inUnit.equals("---")) continue;
            ++match;
        }
        header.put("CSV_data_header_measurements : ", sb_measurements.toString());
        header.put("CSV_data_header_units : ", sb_units.toString());
        if (!isRaw) {
            log.log(Level.FINE, unitCompare.toString());
            if (match != headerLineArray.length - 1) {
                UnitCompareException e = new UnitCompareException(Messages.getString("GDE_MSGW0015", new Object[]{unitCompare.toString()}));
                log.log(Level.WARNING, e.getMessage());
                application.openMessageDialogAsync(e.getMessage());
            }
        }
        return header;
    }

    public static RecordSet read(char separator, String filePath, String recordSetNameExtend, boolean isRaw) throws NotSupportedFileFormatException, MissMatchDeviceException, IOException, DataInconsitsentException, DataTypeException {
        String line = "*";
        RecordSet recordSet = null;
        IDevice device = application.getActiveDevice();
        Channel activeChannel = null;
        try {
            HashMap<String, String> fileHeader = CSVReaderWriter.getHeader(separator, filePath);
            activeChannel = (Channel)channels.get(channels.getChannelNumber(fileHeader.get("Channel/Configuration Name: ")));
            Channel channel = activeChannel = activeChannel == null ? channels.getActiveChannel() : activeChannel;
            if (activeChannel != null) {
                GDE.getUiNotification().setStatusMessage(Messages.getString("GDE_MSGT0134") + filePath);
                long time_ms = 0L;
                if (!application.getActiveDevice().getName().equals(fileHeader.get("DeviceName : "))) {
                    MissMatchDeviceException e = new MissMatchDeviceException(Messages.getString("GDE_MSGW0013", new Object[]{fileHeader.get("DeviceName : ")}));
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw e;
                }
                if (isRaw != (fileHeader = CSVReaderWriter.evaluateType(separator, fileHeader, (DeviceConfiguration)((Object)device))).get("CSV_data_type : ").equals("raw")) {
                    throw new DataTypeException(Messages.getString("GDE_MSGW0014"));
                }
                log.log(Level.FINE, "device name check ok, channel/configuration ok");
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
                while ((line = reader.readLine()) == null || !line.contains("[") || !line.contains("]")) {
                }
                if (GDE.isWithUi()) {
                    channels.switchChannel(activeChannel.getNumber(), "");
                    application.getMenuToolBar().updateChannelSelector();
                    activeChannel = channels.getActiveChannel();
                }
                Object recordSetName = activeChannel.size() + 1 + ") " + recordSetNameExtend;
                String[] tmpRecordNames = fileHeader.get("CSV_data_header_measurements : ").split(";");
                String[] tmpRecordUnits = fileHeader.get("CSV_data_header_units : ").split(";");
                String[] recordNames = isRaw ? device.getMeasurementNamesReplacements(activeChannel.getNumber()) : new String[tmpRecordNames.length];
                String[] recordSymbols = new String[recordNames.length];
                String[] recordUnits = new String[recordNames.length];
                int i = 0;
                int j = 0;
                while (isRaw ? i < recordNames.length : i < tmpRecordNames.length) {
                    MeasurementType measurement = device.getMeasurement(activeChannel.getNumber(), i);
                    if (isRaw) {
                        if (!measurement.isCalculation()) {
                            recordNames[i] = tmpRecordNames[j];
                            recordSymbols[i] = measurement.getSymbol();
                            recordUnits[i] = measurement.getUnit();
                            ++j;
                        } else {
                            recordSymbols[i] = measurement.getSymbol();
                            recordUnits[i] = measurement.getUnit();
                        }
                    } else {
                        recordNames[i] = tmpRecordNames[i];
                        recordSymbols[i] = measurement.getSymbol();
                        recordUnits[i] = tmpRecordUnits[i];
                    }
                    ++i;
                }
                recordSet = RecordSet.createRecordSet((String)recordSetName, device, activeChannel.getNumber(), recordNames, recordSymbols, recordUnits, device.getTimeStep_ms(), isRaw, true, true);
                recordSetName = recordSet.getName();
                if (!isRaw) {
                    for (String recordKey : recordNames) {
                        recordSet.get(recordKey).setDisplayable(true);
                    }
                }
                Date date = null;
                int year = 0;
                int month = 0;
                int day = 0;
                long startTimeStamp = 0L;
                long lastTimeStamp = 0L;
                String[] updateRecordNames = isRaw ? recordSet.getNoneCalculationRecordNames() : recordNames;
                int[] points = new int[updateRecordNames.length];
                while ((line = reader.readLine()) != null) {
                    int second;
                    int minute;
                    int hour;
                    String[] dataStr = line.split("" + separator);
                    String data = dataStr[0].trim().replace(',', '.');
                    if (data.contains(" ")) {
                        GregorianCalendar calendar;
                        long timeStamp;
                        if (date == null) {
                            year = Integer.parseInt(data.substring(0, 4));
                            month = Integer.parseInt(data.substring(5, 7));
                            day = Integer.parseInt(data.substring(8, 10));
                        }
                        if (lastTimeStamp >= (timeStamp = (calendar = new GregorianCalendar(year, month - 1, day, hour = Integer.parseInt((data = data.split(" ")[1]).substring(0, 2)), minute = Integer.parseInt(data.substring(3, 5)), second = Integer.parseInt(data.substring(6, 8)))).getTimeInMillis() + (long)(data.contains(".") ? Integer.parseInt(data.substring(data.lastIndexOf(46) + 1)) : 0))) continue;
                        time_ms = lastTimeStamp == 0L ? 0L : time_ms + (timeStamp - lastTimeStamp);
                        lastTimeStamp = timeStamp;
                        date = calendar.getTime();
                        if (startTimeStamp == 0L) {
                            startTimeStamp = timeStamp;
                        }
                    } else {
                        if (startTimeStamp == 0L) {
                            startTimeStamp = new Date().getTime();
                        }
                        if (data.length() == 9) {
                            int minute2 = Integer.parseInt(data.substring(0, 2));
                            int second2 = Integer.parseInt(data.substring(3, 5));
                            time_ms = minute2 * 60 * 1000 + second2 * 1000 + Integer.parseInt(data.substring(data.lastIndexOf(46) + 1));
                        } else if (data.length() == 12) {
                            hour = Integer.parseInt(data.substring(0, 2));
                            minute = Integer.parseInt(data.substring(3, 5));
                            second = Integer.parseInt(data.substring(6, 8));
                            time_ms = hour * 60 * 60 * 1000 + minute * 60 * 1000 + second * 1000 + Integer.parseInt(data.substring(data.lastIndexOf(46) + 1));
                        }
                    }
                    for (int i2 = 0; i2 < updateRecordNames.length; ++i2) {
                        data = dataStr[i2 + 1].trim().replace(',', '.').replace(" ", "");
                        points[i2] = (int)(Double.valueOf(data) * 1000.0);
                    }
                    if (isRaw) {
                        recordSet.addNoneCalculationRecordsPoints(points, time_ms);
                        continue;
                    }
                    recordSet.addPoints(points, time_ms);
                }
                recordSet.setSaved(true);
                activeChannel.put(recordSetName, recordSet);
                activeChannel.setActiveRecordSet((String)recordSetName);
                if (isRaw) {
                    ((RecordSet)activeChannel.get(recordSetName)).checkAllDisplayable();
                }
                activeChannel.applyTemplate((String)recordSetName, true);
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet((String)recordSetName);
                    application.updateAllTabs(true, true);
                }
                reader.close();
                reader = null;
            }
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new UnsupportedEncodingException(Messages.getString("GDE_MSGW0010"));
        }
        catch (FileNotFoundException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new FileNotFoundException(Messages.getString("GDE_MSGW0011", new Object[]{filePath}));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException(Messages.getString("GDE_MSGW0012", new Object[]{filePath}));
        }
        finally {
            GDE.getUiNotification().setProgress(100);
            GDE.getUiNotification().setStatusMessage("");
            if (GDE.isWithUi()) {
                application.getMenuToolBar().updateChannelSelector();
                application.getMenuToolBar().updateRecordSetSelectCombo();
            }
        }
        return recordSet;
    }

    public static void write(char separator, String recordSetKey, String filePath, boolean isRaw, String encoding) throws Exception {
        try {
            long startTime;
            GDE.getUiNotification().setStatusMessage(Messages.getString("GDE_MSGT0138", new String[]{"csv", filePath}));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), encoding));
            char decimalSeparator = Settings.getInstance().getDecimalSeparator();
            boolean isTimeFormatAbsolute = Settings.getInstance().isTimeFormatAbsolute();
            df3.setGroupingUsed(false);
            sb = new StringBuffer();
            RecordSet recordSet = (RecordSet)Channels.getInstance().getActiveChannel().get(recordSetKey);
            IDevice device = DataExplorer.getInstance().getActiveDevice();
            sb.append(device.getName()).append(separator).append(recordSet.getChannelConfigName()).append(lineSep);
            writer.write(sb.toString());
            log.log(Level.FINE, "written header line = " + sb.toString());
            sb = new StringBuffer();
            sb.append(Messages.getString(isTimeFormatAbsolute ? "GDE_MSGT0436" : "GDE_MSGT0137")).append(separator);
            int i = 0;
            if (isRaw) {
                String[] recordNames = recordSet.getRecordNames();
                for (int j = 0; j < recordNames.length; ++j) {
                    Record record = recordSet.get(recordNames[j]);
                    MeasurementType measurement = device.getMeasurement(recordSet.getChannelConfigNumber(), record.getOrdinal());
                    log.log(Level.FINEST, "append " + record.getName());
                    if (measurement.isCalculation()) continue;
                    sb.append(record.getName()).append(" [---]").append(separator);
                    log.log(Level.FINEST, "append " + record.getName());
                }
                ++i;
            } else {
                for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                    log.log(Level.FINER, "append " + record.getName());
                    sb.append(record.getName()).append(" [").append(record.getUnit()).append(']').append(separator);
                    ++i;
                }
            }
            sb.deleteCharAt(sb.length() - 1).append(lineSep);
            log.log(Level.FINER, "header line = " + sb.toString());
            writer.write(sb.toString());
            try {
                startTime = new Date(recordSet.getTime(0)).getTime();
            }
            catch (Exception e) {
                startTime = new Date().getTime();
            }
            int recordEntries = recordSet.getRecordDataSize(false);
            int progressCycle = 0;
            GDE.getUiNotification().setProgress(progressCycle);
            for (i = 0; i < recordEntries; ++i) {
                String[] row;
                sb = new StringBuffer();
                if (isRaw) {
                    row = recordSet.getRawExportRow(i, isTimeFormatAbsolute);
                    row[0].replace(',', decimalSeparator);
                    for (String value : row) {
                        if (value != null) {
                            sb.append(value.trim());
                        }
                        sb.append(separator);
                    }
                } else {
                    row = recordSet.getDataTableRow(i, isTimeFormatAbsolute);
                    char currentDecimalSeparator = Character.valueOf(recordSet.get(0).getDecimalFormat().getDecimalFormatSymbols().getDecimalSeparator()).charValue();
                    char currentrGoupingSeparator = Character.valueOf(recordSet.get(0).getDecimalFormat().getDecimalFormatSymbols().getGroupingSeparator()).charValue();
                    sb.append(row[0].replace(',', decimalSeparator).trim()).append(separator);
                    int j = 0;
                    for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                        log.log(Level.FINEST, "append " + record.getName());
                        sb.append(row[j + 1].replace(currentrGoupingSeparator, ' ').replace(currentDecimalSeparator, decimalSeparator)).append(separator);
                        ++j;
                    }
                }
                sb.deleteCharAt(sb.length() - 1).append(lineSep);
                writer.write(sb.toString());
                if (i % 50 == 0) {
                    GDE.getUiNotification().setProgress(++progressCycle * 5000 / recordEntries);
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "data line = " + sb.toString());
            }
            sb = null;
            log.log(Level.TIME, "CSV file = " + filePath + " erfolgreich geschiebenwrite time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
            writer.flush();
            writer.close();
            writer = null;
            GDE.getUiNotification().setProgress(100);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString("GDE_MSGE0006", new Object[]{"csv", filePath, e.getMessage()}));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString("GDE_MSGE0007") + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        finally {
            GDE.getUiNotification().setStatusMessage("");
        }
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
    }
}

