/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.data.Record;
import gde.device.IChannelItem;
import gde.device.MeasurementType;
import gde.histo.cache.DataTypes;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.HistoVault;
import gde.histo.datasources.HistoSet;
import gde.histo.recordings.MeasurementTrailSelector;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordSet;
import java.util.stream.DoubleStream;

public final class MeasurementTrail
extends TrailRecord {
    private static final long serialVersionUID = 110124007964748556L;

    public MeasurementTrail(int newOrdinal, IChannelItem measurementType, TrailRecordSet parent, int initialCapacity) {
        super(measurementType, newOrdinal, parent, initialCapacity);
        this.setTrailSelector();
    }

    @Override
    public void setTrailSelector() {
        this.trailSelector = new MeasurementTrailSelector(this);
    }

    public MeasurementType getMeasurement() {
        return (MeasurementType)this.channelItem;
    }

    @Override
    protected boolean isAllowedBySetting() {
        return true;
    }

    @Override
    public boolean isScaleVisible() {
        return super.isScaleVisible();
    }

    @Override
    public Integer getVaultPoint(ExtendedVault vault, int trailOrdinal) {
        return vault.getMeasurementPoint(this.getOrdinal(), trailOrdinal);
    }

    @Override
    public boolean hasVaultOutliers(ExtendedVault vault) {
        return vault.hasMeasurementOutliers(this.getOrdinal());
    }

    @Override
    public boolean hasVaultScraps(ExtendedVault vault) {
        return vault.hasMeasurementScraps(this.getOrdinal());
    }

    @Override
    public DoubleStream getVaultOutliers(ExtendedVault vault) {
        return vault.getMeasurementOutliers(this.getOrdinal()).mapToDouble(p -> HistoSet.decodeVaultValue(this.getChannelItem(), (double)p / 1000.0));
    }

    @Override
    public DoubleStream getVaultScraps(ExtendedVault vault) {
        return vault.getMeasurementScraps(this.getOrdinal()).mapToDouble(p -> HistoSet.decodeVaultValue(this.getChannelItem(), (double)p / 1000.0));
    }

    @Override
    public Record.DataType getVaultDataType(HistoVault vault) {
        DataTypes dataType = vault.getMeasurementDataType(this.getOrdinal());
        return dataType != null ? DataTypes.toDataType(dataType) : null;
    }
}

