/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.cache;

import com.sun.istack.Nullable;
import gde.histo.cache.CompartmentType;
import gde.histo.cache.CompartmentsType;
import gde.histo.cache.DataTypes;
import gde.histo.cache.PointType;
import gde.histo.cache.PointsType;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.IntStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="histoVault", propOrder={"vaultName", "vaultDirectory", "vaultReaderSettings", "vaultCreated_ms", "vaultDataExplorerVersion", "vaultDeviceKey", "vaultDeviceName", "vaultChannelNumber", "vaultObjectKey", "vaultSamplingTimespan_ms", "logLinkPath", "logFilePath", "logFileLastModified", "logFileLength", "logObjectDirectory", "logFileVersion", "logRecordSetSize", "logRecordSetOrdinal", "logRecordsetBaseName", "logDeviceName", "logChannelNumber", "logObjectKey", "logStartTimestamp_ms", "measurements", "settlements", "scores"})
public class HistoVault {
    private static JAXBContext jaxbContext;
    @XmlElement(required=true)
    protected String vaultName;
    @XmlElement(required=true)
    protected String vaultDirectory;
    @XmlElement(required=true)
    protected String vaultReaderSettings;
    @XmlElement(required=true)
    protected long vaultCreated_ms;
    @XmlElement(required=true)
    protected String vaultDataExplorerVersion;
    @XmlElement(required=true)
    protected String vaultDeviceKey;
    @XmlElement(required=true)
    protected String vaultDeviceName;
    protected int vaultChannelNumber;
    @XmlElement(required=true)
    protected String vaultObjectKey;
    @XmlElement(required=true)
    protected long vaultSamplingTimespan_ms;
    @Deprecated
    @XmlElement(required=true)
    protected String logLinkPath;
    @XmlElement(required=true)
    protected String logFilePath;
    protected long logFileLastModified;
    protected long logFileLength;
    @Deprecated
    @XmlElement(required=true)
    protected String logObjectDirectory;
    protected int logFileVersion;
    protected int logRecordSetSize;
    protected int logRecordSetOrdinal;
    @XmlElement(required=true)
    protected String logRecordsetBaseName;
    @XmlElement(required=true)
    protected String logDeviceName;
    protected int logChannelNumber;
    @XmlElement(required=true)
    protected String logObjectKey;
    @XmlElement(required=true)
    protected long logStartTimestamp_ms;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=CompartmentsTypeAdapter.class)
    protected HashMap<Integer, CompartmentType> measurements;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=CompartmentsTypeAdapter.class)
    protected HashMap<Integer, CompartmentType> settlements;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=PointsTypeAdapter.class)
    protected HashMap<Integer, PointType> scores;

    public HistoVault() {
    }

    public HistoVault(HistoVault histoVault) {
        this.vaultName = histoVault.vaultName;
        this.vaultDirectory = histoVault.vaultDirectory;
        this.vaultCreated_ms = histoVault.vaultCreated_ms;
        this.vaultReaderSettings = histoVault.vaultReaderSettings;
        this.vaultDataExplorerVersion = histoVault.vaultDataExplorerVersion;
        this.vaultDeviceKey = histoVault.vaultDeviceKey;
        this.vaultDeviceName = histoVault.vaultDeviceName;
        this.vaultChannelNumber = histoVault.vaultChannelNumber;
        this.vaultObjectKey = histoVault.vaultObjectKey;
        this.vaultSamplingTimespan_ms = histoVault.vaultSamplingTimespan_ms;
        this.logLinkPath = histoVault.logLinkPath;
        this.logFilePath = histoVault.logFilePath;
        this.logFileLastModified = histoVault.logFileLastModified;
        this.logFileLength = histoVault.logFileLength;
        this.logFileVersion = histoVault.logFileVersion;
        this.logObjectDirectory = histoVault.logObjectDirectory;
        this.logRecordSetSize = histoVault.logRecordSetSize;
        this.logRecordSetOrdinal = histoVault.logRecordSetOrdinal;
        this.logRecordsetBaseName = histoVault.logRecordsetBaseName;
        this.logDeviceName = histoVault.logDeviceName;
        this.logChannelNumber = histoVault.logChannelNumber;
        this.logObjectKey = histoVault.logObjectKey;
        this.logStartTimestamp_ms = histoVault.logStartTimestamp_ms;
        this.measurements = histoVault.measurements;
        this.settlements = histoVault.settlements;
        this.scores = histoVault.scores;
    }

    public String getVaultName() {
        return this.vaultName;
    }

    public void setVaultName(String value) {
        this.vaultName = value;
    }

    public String getVaultDirectory() {
        return this.vaultDirectory;
    }

    public void setVaultDirectory(String value) {
        this.vaultDirectory = value;
    }

    public String getVaultReaderSettings() {
        return this.vaultReaderSettings;
    }

    public void setVaultReaderSettings(String value) {
        this.vaultReaderSettings = value;
    }

    public long getVaultCreated_ms() {
        return this.vaultCreated_ms;
    }

    public void setVaultCreated_ms(long value) {
        this.vaultCreated_ms = value;
    }

    public String getVaultDataExplorerVersion() {
        return this.vaultDataExplorerVersion;
    }

    public void setVaultDataExplorerVersion(String value) {
        this.vaultDataExplorerVersion = value;
    }

    public String getVaultDeviceKey() {
        return this.vaultDeviceKey;
    }

    public void setVaultDeviceKey(String value) {
        this.vaultDeviceKey = value;
    }

    public String getVaultDeviceName() {
        return this.vaultDeviceName;
    }

    public void setVaultDeviceName(String value) {
        this.vaultDeviceName = value;
    }

    public int getVaultChannelNumber() {
        return this.vaultChannelNumber;
    }

    public void setVaultChannelNumber(int value) {
        this.vaultChannelNumber = value;
    }

    public String getVaultObjectKey() {
        return this.vaultObjectKey;
    }

    public void setVaultObjectKey(String value) {
        this.vaultObjectKey = value;
    }

    public long getVaultSamplingTimespan_ms() {
        return this.vaultSamplingTimespan_ms;
    }

    public void setVaultSamplingTimespan_ms(long value) {
        this.vaultSamplingTimespan_ms = value;
    }

    @Deprecated
    public String getLogLinkPath() {
        return this.logLinkPath;
    }

    @Deprecated
    public void setLogLinkPath(String value) {
        this.logLinkPath = value;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String value) {
        this.logFilePath = value;
    }

    public long getLogFileLastModified() {
        return this.logFileLastModified;
    }

    public void setLogFileLastModified(long value) {
        this.logFileLastModified = value;
    }

    public long getLogFileLength() {
        return this.logFileLength;
    }

    public void setLogFileLength(long value) {
        this.logFileLength = value;
    }

    @Deprecated
    public String getLogObjectDirectory() {
        return this.logObjectDirectory;
    }

    @Deprecated
    public void setLogObjectDirectory(String value) {
        this.logObjectDirectory = value;
    }

    public int getLogFileVersion() {
        return this.logFileVersion;
    }

    public void setLogFileVersion(int value) {
        this.logFileVersion = value;
    }

    public int getLogRecordSetSize() {
        return this.logRecordSetSize;
    }

    public void setLogRecordSetSize(int value) {
        this.logRecordSetSize = value;
    }

    public int getLogRecordSetOrdinal() {
        return this.logRecordSetOrdinal;
    }

    public void setLogRecordSetOrdinal(int value) {
        this.logRecordSetOrdinal = value;
    }

    public String getLogRecordsetBaseName() {
        return this.logRecordsetBaseName;
    }

    public void setLogRecordsetBaseName(String value) {
        this.logRecordsetBaseName = value;
    }

    public String getLogDeviceName() {
        return this.logDeviceName;
    }

    public void setLogDeviceName(String value) {
        this.logDeviceName = value;
    }

    public int getLogChannelNumber() {
        return this.logChannelNumber;
    }

    public void setLogChannelNumber(int value) {
        this.logChannelNumber = value;
    }

    public String getLogObjectKey() {
        return this.logObjectKey;
    }

    public void setLogObjectKey(String value) {
        this.logObjectKey = value;
    }

    public long getLogStartTimestamp_ms() {
        return this.logStartTimestamp_ms;
    }

    public void setLogStartTimestamp_ms(long value) {
        this.logStartTimestamp_ms = value;
    }

    public HashMap<Integer, CompartmentType> getMeasurements() {
        if (this.measurements == null) {
            this.measurements = new HashMap();
        }
        return this.measurements;
    }

    public void setMeasurements(HashMap<Integer, CompartmentType> value) {
        this.measurements = value;
    }

    public HashMap<Integer, CompartmentType> getSettlements() {
        if (this.settlements == null) {
            this.settlements = new HashMap();
        }
        return this.settlements;
    }

    public void setSettlements(HashMap<Integer, CompartmentType> value) {
        this.settlements = value;
    }

    public HashMap<Integer, PointType> getScores() {
        if (this.scores == null) {
            this.scores = new HashMap();
        }
        return this.scores;
    }

    public void setScores(HashMap<Integer, PointType> value) {
        this.scores = value;
    }

    public HashMap<Integer, PointType> getMeasurementPoints(int measurementOrdinal) {
        return this.getMeasurements().containsKey(measurementOrdinal) ? new HashMap<Integer, PointType>() : this.getMeasurements().get(measurementOrdinal).getTrails();
    }

    @Nullable
    public Integer getMeasurementPoint(int measurementOrdinal, int trailOrdinal) {
        if (this.getMeasurements().containsKey(measurementOrdinal)) {
            return this.getMeasurements().get(measurementOrdinal).getTrails().containsKey(trailOrdinal) ? Integer.valueOf(this.getMeasurements().get((Object)Integer.valueOf((int)measurementOrdinal)).getTrails().get((Object)Integer.valueOf((int)trailOrdinal)).value) : null;
        }
        return null;
    }

    public IntStream getMeasurementOutliers(int measurementOrdinal) {
        String points;
        if (this.getMeasurements().containsKey(measurementOrdinal) && (points = this.getMeasurements().get(measurementOrdinal).getOutlierPoints()) != null) {
            return Arrays.stream(points.split(",")).mapToInt(Integer::parseInt);
        }
        return IntStream.empty();
    }

    public IntStream getMeasurementScraps(int measurementOrdinal) {
        String points;
        if (this.getMeasurements().containsKey(measurementOrdinal) && (points = this.getMeasurements().get(measurementOrdinal).getScrappedPoints()) != null) {
            return Arrays.stream(points.split(",")).mapToInt(Integer::parseInt);
        }
        return IntStream.empty();
    }

    public boolean hasMeasurementOutliers(int measurementOrdinal) {
        if (this.getMeasurements().containsKey(measurementOrdinal)) {
            return this.getMeasurements().get(measurementOrdinal).getOutlierPoints() != null;
        }
        return false;
    }

    @Nullable
    public DataTypes getMeasurementDataType(int measurementOrdinal) {
        if (this.getMeasurements().containsKey(measurementOrdinal)) {
            return this.getMeasurements().get((Object)Integer.valueOf((int)measurementOrdinal)).dataType;
        }
        return null;
    }

    public boolean hasMeasurementScraps(int measurementOrdinal) {
        if (this.getMeasurements().containsKey(measurementOrdinal)) {
            return this.getMeasurements().get(measurementOrdinal).getScrappedPoints() != null;
        }
        return false;
    }

    public HashMap<Integer, PointType> getSettlementPoints(int settlementId) {
        return this.getSettlements().containsKey(settlementId) ? new HashMap<Integer, PointType>() : this.getSettlements().get(settlementId).getTrails();
    }

    @Nullable
    public Integer getSettlementPoint(int settlementId, int trailOrdinal) {
        if (this.getSettlements().containsKey(settlementId)) {
            return this.getSettlements().get(settlementId).getTrails().containsKey(trailOrdinal) ? Integer.valueOf(this.getSettlements().get((Object)Integer.valueOf((int)settlementId)).getTrails().get((Object)Integer.valueOf((int)trailOrdinal)).value) : null;
        }
        return null;
    }

    public IntStream getSettlementOutliers(int settlementId) {
        String points;
        if (this.getMeasurements().containsKey(settlementId) && (points = this.getMeasurements().get(settlementId).getOutlierPoints()) != null) {
            return Arrays.stream(points.split(",")).mapToInt(Integer::parseInt);
        }
        return IntStream.empty();
    }

    public IntStream getSettlementScraps(int settlementId) {
        String points;
        if (this.getMeasurements().containsKey(settlementId) && (points = this.getMeasurements().get(settlementId).getScrappedPoints()) != null) {
            return Arrays.stream(points.split(",")).mapToInt(Integer::parseInt);
        }
        return IntStream.empty();
    }

    public boolean hasSettlementOutliers(int settlementId) {
        if (this.getSettlements().containsKey(settlementId)) {
            return this.getSettlements().get(settlementId).getOutlierPoints() != null;
        }
        return false;
    }

    public boolean hasSettlementScraps(int settlementId) {
        if (this.getSettlements().containsKey(settlementId)) {
            return this.getSettlements().get(settlementId).getScrappedPoints() != null;
        }
        return false;
    }

    @Nullable
    public DataTypes getSettlementDataType(int settlementId) {
        if (this.getSettlements().containsKey(settlementId)) {
            return this.getSettlements().get((Object)Integer.valueOf((int)settlementId)).dataType;
        }
        return null;
    }

    public Integer getScorePoint(int scoreLabelOrdinal) {
        try {
            return this.getScores().get(scoreLabelOrdinal).getValue();
        }
        catch (Exception e) {
            Logger log = Logger.getLogger(HistoVault.class.getName());
            log.log(Level.WARNING, this.getLogFilePath());
            log.log(Level.SEVERE, e.getMessage(), e);
            return 0;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String d = ", ";
        sb.append(this.vaultName).append(", ");
        sb.append("logRecordSetOrdinal=").append(this.logRecordSetOrdinal).append(", ");
        sb.append("logRecordsetBaseName=").append(this.logRecordsetBaseName).append(", ");
        sb.append("logChannelNumber=").append(this.logChannelNumber).append(", ");
        sb.append("logObjectKey=").append(this.logObjectKey).append(", ");
        sb.append("logStartTimestampMs=").append(this.logStartTimestamp_ms).append(", ");
        sb.append("vaultDirectory=").append(this.vaultDirectory);
        return sb.toString();
    }

    public static JAXBContext getJaxbContext() {
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance(HistoVault.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return jaxbContext;
    }

    public static class PointsTypeAdapter
    extends XmlAdapter<PointsType, HashMap<Integer, PointType>> {
        @Override
        public HashMap<Integer, PointType> unmarshal(PointsType values) {
            HashMap<Integer, PointType> map = new HashMap<Integer, PointType>();
            if (values != null) {
                for (PointType value : values.point) {
                    map.put(value.id, value);
                }
            }
            return map;
        }

        @Override
        public PointsType marshal(HashMap<Integer, PointType> map) {
            PointsType aList = new PointsType();
            aList.point = map == null ? new ArrayList<PointType>() : new ArrayList<PointType>(map.values());
            return aList;
        }
    }

    public static class CompartmentsTypeAdapter
    extends XmlAdapter<CompartmentsType, HashMap<Integer, CompartmentType>> {
        @Override
        public HashMap<Integer, CompartmentType> unmarshal(CompartmentsType values) {
            HashMap<Integer, CompartmentType> map = new HashMap<Integer, CompartmentType>();
            if (values != null) {
                for (CompartmentType value : values.compartment) {
                    map.put(value.id, value);
                }
            }
            return map;
        }

        @Override
        public CompartmentsType marshal(HashMap<Integer, CompartmentType> map) {
            CompartmentsType aList = new CompartmentsType();
            aList.compartment = map == null ? new ArrayList<CompartmentType>() : new ArrayList<CompartmentType>(new TreeMap<Integer, CompartmentType>(map).values());
            return aList;
        }
    }
}

