/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.HeaderBlock;
import com.monstarmike.tlmreader.primitives.Shorts;

public class HeaderDataBlock
extends HeaderBlock {
    boolean terminatingBlock = false;
    private short sensorType;

    public HeaderDataBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
    }

    public String getSensorTypeEnabled() {
        byte[] sensorTypeBytes = Shorts.toByteArray(this.sensorType);
        if (sensorTypeBytes[0] != sensorTypeBytes[1]) {
            return "invalid information! 0x4 does not equal 0x5";
        }
        switch (sensorTypeBytes[0]) {
            case 1: {
                return "Volts";
            }
            case 2: {
                return "Temperature";
            }
            case 3: {
                return "Amps";
            }
            case 10: {
                return "PowerBox";
            }
            case 17: {
                return "Speed";
            }
            case 18: {
                return "Altimeter";
            }
            case 20: {
                return "G-Force";
            }
            case 21: {
                return "JetCat";
            }
            case 22: {
                return "GPS";
            }
            case 23: {
                this.terminatingBlock = true;
                return "Terminating Block";
            }
        }
        return "Unknown Header Block";
    }

    public boolean isTerminatingBlock() {
        return this.terminatingBlock;
    }

    private void decode(byte[] rawData) {
        this.sensorType = Shorts.fromBytes(rawData[4], rawData[5]);
    }

    public String toString() {
        return "DataHeader; type: " + this.getSensorTypeEnabled();
    }
}

