/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.GPSLocationBlock;
import com.monstarmike.tlmreader.datablock.GPSStatusBlock;
import com.monstarmike.tlmreader.datablock.IBlock;
import java.util.List;

public class GPSCollectorBlock
extends DataBlock
implements IBlock {
    private static GPSCollectorBlock instance = null;
    private GPSLocationBlock locationData;
    private GPSStatusBlock statusData;
    private boolean isUpdateLocation = false;
    private boolean isUpdateStatus = false;

    private GPSCollectorBlock() {
        this.measurementNames.add("Altitude GPS");
        this.measurementNames.add("Latitude");
        this.measurementNames.add("Longitude");
        this.measurementNames.add("Speed GPS");
        this.measurementNames.add("Satellites GPS");
        this.measurementNames.add("Course");
        this.measurementNames.add("HDOP");
        this.measurementNames.add("GPSFix");
        this.measurementNames.add("UTC GPS");
        this.measurementUnits.add("m");
        this.measurementUnits.add("\u00b0 '");
        this.measurementUnits.add("\u00b0 '");
        this.measurementUnits.add("km/h");
        this.measurementUnits.add("#");
        this.measurementUnits.add("\u00b0");
        this.measurementUnits.add("");
        this.measurementUnits.add("");
        this.measurementUnits.add("");
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(0.1852);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
    }

    public static GPSCollectorBlock getInstance() {
        if (instance == null) {
            instance = new GPSCollectorBlock();
            return instance;
        }
        return instance;
    }

    public void updateLocation(GPSLocationBlock block) {
        this.locationData = new GPSLocationBlock(block);
        this.timestamp = this.locationData.getTimestamp();
        this.sequence = this.locationData.getSequence();
        this.isUpdateLocation = true;
    }

    public void updateStatus(GPSStatusBlock block) {
        this.statusData = new GPSStatusBlock(block);
        this.timestamp = this.statusData.getTimestamp();
        this.sequence = this.statusData.getSequence();
        this.isUpdateStatus = true;
    }

    public boolean isUpdated() {
        return this.locationData != null && this.statusData != null && (this.isUpdateLocation || this.isUpdateStatus);
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (this.locationData != null && this.statusData != null) {
            if (block instanceof GPSLocationBlock) {
                return this.locationData.areValuesEquals(block);
            }
            if (block instanceof GPSStatusBlock) {
                return this.statusData.areValuesEquals(block);
            }
        }
        return false;
    }

    @Override
    public List<String> getMeasurementNames() {
        return this.measurementNames;
    }

    @Override
    public List<String> getMeasurementUnits() {
        return this.measurementUnits;
    }

    @Override
    public List<Double> getMeasurementFactors() {
        return this.measurementFactors;
    }

    @Override
    public List<Integer> getMeasurementValues() {
        this.measurementValues.clear();
        int altitudeInTenthOfMeter = this.statusData.getAltitudeHightInMeter() * 10000 + this.locationData.getAltitudeLowInTenthOfMeter();
        this.measurementValues.add(altitudeInTenthOfMeter);
        this.measurementValues.add(this.locationData.getLatitude());
        this.measurementValues.add((this.locationData.getFlags() & 4) == 4 ? 1000000000 + this.locationData.getLongitude() : this.locationData.getLongitude());
        this.measurementValues.add(Integer.valueOf(this.statusData.getSpeedInTenthOfKnots()));
        this.measurementValues.add(Integer.valueOf(this.statusData.getNumSats()));
        this.measurementValues.add(Integer.valueOf(this.locationData.getCourseInTenthOfDegree()));
        this.measurementValues.add(Integer.valueOf(this.locationData.getHDOPInTenth()));
        this.measurementValues.add(this.locationData.getGPSFix());
        this.measurementValues.add(this.statusData.getUTC());
        return this.measurementValues;
    }
}

