/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.GDE;
import gde.config.Settings;
import gde.histo.recordings.HistoGraphicsMapper;
import gde.histo.recordings.TrailRecordSetFormatter;
import gde.histo.ui.AbstractMeasuring;
import gde.histo.ui.CurveSurvey;
import gde.histo.ui.GraphicsComposite;
import gde.histo.ui.Measure;
import gde.log.Logger;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.ColorUtils;
import gde.utils.StringHelper;
import java.util.Date;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public final class GraphicsMeasuring
extends AbstractMeasuring {
    private static final String $CLASS_NAME = GraphicsMeasuring.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    boolean isLeftMouseMeasure = false;
    boolean isRightMouseMeasure = false;
    private final GraphicsComposite graphicsComposite;
    private final CurveSurvey curveSurvey;
    private GC canvasGC;
    private MeasuringMode mode;
    public static int xPosMeasure = Integer.MIN_VALUE;
    public static int yPosMeasure = Integer.MIN_VALUE;
    public static int xPosDelta = Integer.MIN_VALUE;
    public static int yPosDelta = Integer.MIN_VALUE;

    public GraphicsMeasuring(GraphicsComposite graphicsComposite, Measure measure) {
        super(measure);
        this.graphicsComposite = graphicsComposite;
        this.mode = MeasuringMode.getMode(measure.isDeltaMeasure);
        this.mode.setMode(this);
        this.curveSurvey = new CurveSurvey(graphicsComposite, measure);
        this.curveSurvey.setMeasurePosition();
        this.curveSurvey.setDeltaPosition();
    }

    @Override
    public void drawMeasuring(GC canvasGC) {
        this.drawMeasuring(canvasGC, this.measure.getTimestampMeasure_ms(), this.measure.getTimestampDelta_ms());
    }

    private void drawMeasuring(GC canvasGC, long timestampMeasureNew_ms, long timestampDeltaNew_ms) {
        canvasGC.setForeground(ColorUtils.getColor(this.measure.measureRecord.getRGB()));
        this.curveSurvey.setCanvasGC(canvasGC);
        this.measure.setTimestampMeasure_ms(timestampMeasureNew_ms);
        this.measure.setTimestampDelta_ms(timestampDeltaNew_ms);
        this.curveSurvey.setMeasurePosition();
        this.curveSurvey.setDeltaPosition();
        this.mode.drawMeasurement(canvasGC, this);
    }

    @Override
    public void cleanMeasuring() {
        this.isLeftMouseMeasure = false;
        this.isRightMouseMeasure = false;
        if (this.curveSurvey != null) {
            this.curveSurvey.setCanvasGC(this.canvasGC);
        }
        this.graphicsComposite.cleanMeasurePopUp();
        this.graphicsComposite.graphicCanvas.redraw();
        this.graphicsComposite.setRecordSetCommentStandard();
    }

    @Override
    public void processMouseDownMove(long timestamp_ms) {
        if (this.isLeftMouseMeasure) {
            int height = this.graphicsComposite.curveAreaBounds.height;
            int yPosMeasureNew = HistoGraphicsMapper.getVerticalDisplayPos(this.graphicsComposite.getChartData(this.measure.measureRecord), height, this.measure.measureRecord.getParent().getIndex(timestamp_ms));
            if (this.curveSurvey.isNewMeasureSpot(timestamp_ms, yPosMeasureNew)) {
                this.measure.setTimestampMeasure_ms(timestamp_ms);
                this.curveSurvey.setMeasurePosition();
            }
        } else if (this.isRightMouseMeasure) {
            int height = this.graphicsComposite.curveAreaBounds.height;
            int yPosDeltaNew = HistoGraphicsMapper.getVerticalDisplayPos(this.graphicsComposite.getChartData(this.measure.measureRecord), height, this.measure.measureRecord.getParent().getIndex(timestamp_ms));
            if (this.curveSurvey.isNewDeltaSpot(timestamp_ms, yPosDeltaNew)) {
                this.measure.setTimestampDelta_ms(timestamp_ms);
                this.curveSurvey.setDeltaPosition();
            }
        }
        this.graphicsComposite.graphicCanvas.redraw();
    }

    @Override
    public void processMouseUpMove(Point point) {
        if (this.curveSurvey.isOverVerticalLine(point.x)) {
            this.graphicsComposite.graphicCanvas.setCursor(SWTResourceManager.getCursor(9));
        } else {
            this.graphicsComposite.graphicCanvas.setCursor(DataExplorer.getInstance().getCursor());
        }
    }

    @Override
    public void processMouseDownAction(Point point) {
        if (this.curveSurvey.isOverVerticalLine(point.x)) {
            if (this.curveSurvey.isNearMeasureLine(point.x)) {
                this.isLeftMouseMeasure = true;
                this.isRightMouseMeasure = false;
            } else if (this.curveSurvey.isNearDeltaLine(point.x)) {
                this.isRightMouseMeasure = true;
                this.isLeftMouseMeasure = false;
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void processMouseUpAction(Point point) {
        if (this.isLeftMouseMeasure) {
            this.isLeftMouseMeasure = false;
        } else if (this.isRightMouseMeasure) {
            this.isRightMouseMeasure = false;
        }
        log.time(() -> "isMouseMeasure = " + this.isLeftMouseMeasure + " isMouseDeltaMeasure = " + this.isRightMouseMeasure);
    }

    public static enum MeasuringMode {
        MEASURE{

            @Override
            void setMode(GraphicsMeasuring graphicsMeasuring) {
                graphicsMeasuring.isLeftMouseMeasure = true;
                graphicsMeasuring.isRightMouseMeasure = false;
            }

            @Override
            void drawMeasurement(GC canvasGC, GraphicsMeasuring hgm) {
                GraphicsComposite hgc = hgm.graphicsComposite;
                String statusMessage = hgm.curveSurvey.drawMeasurementGraphics();
                hgc.windowActor.setStatusMessage(statusMessage);
                if (Settings.getInstance().isUseMeasurementPopUp()) {
                    hgm.graphicsComposite.callMeasurePopUp(hgm.measure.getTimestampMeasure_ms());
                } else {
                    hgc.recordSetComment.setText(MeasuringMode.getSelectedMeasurementsAsTable(hgc.recordSetComment, hgm.measure.getTimestampMeasure_ms()));
                    hgc.recordSetComment.setToolTipText(Messages.getString("GDE_MSGT0897"));
                }
            }

            @Override
            void drawLeftMeasurement(GC canvasGC, GraphicsMeasuring hgm) {
                GraphicsComposite hgc = hgm.graphicsComposite;
                long startTime = new Date().getTime();
                String statusMessage = hgm.curveSurvey.drawMeasurementGraphics();
                hgc.windowActor.setStatusMessage(statusMessage);
                hgc.recordSetComment.setText(MeasuringMode.getSelectedMeasurementsAsTable(hgc.recordSetComment, hgm.measure.getTimestampMeasure_ms()));
                hgc.recordSetComment.setToolTipText(Messages.getString("GDE_MSGT0897"));
                log.time(() -> "draw time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
            }

            @Override
            void drawRightMeasurement(GC canvasGC, GraphicsMeasuring hgm) {
            }
        }
        ,
        MEASURE_DELTA{

            @Override
            void setMode(GraphicsMeasuring graphicsMeasuring) {
                graphicsMeasuring.isLeftMouseMeasure = false;
                graphicsMeasuring.isRightMouseMeasure = true;
            }

            @Override
            void drawMeasurement(GC canvasGC, GraphicsMeasuring hgm) {
                GraphicsComposite hgc = hgm.graphicsComposite;
                String statusMessage = hgm.curveSurvey.drawDeltaMeasurementGraphics();
                hgc.windowActor.setStatusMessage(statusMessage);
                hgc.recordSetComment.setText(MeasuringMode.getSelectedMeasurementsAsTable(hgc.recordSetComment, hgm.measure.getTimestampMeasure_ms()));
                hgc.recordSetComment.setToolTipText(Messages.getString("GDE_MSGT0897"));
            }

            @Override
            void drawLeftMeasurement(GC canvasGC, GraphicsMeasuring hgm) {
                GraphicsComposite hgc = hgm.graphicsComposite;
                long startTime = new Date().getTime();
                String statusMessage = hgm.curveSurvey.drawDeltaMeasurementGraphics();
                hgc.windowActor.setStatusMessage(statusMessage);
                hgc.recordSetComment.setText(MeasuringMode.getSelectedMeasurementsAsTable(hgc.recordSetComment, hgm.measure.getTimestampMeasure_ms()));
                hgc.recordSetComment.setToolTipText(Messages.getString("GDE_MSGT0897"));
                log.time(() -> "draw time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
            }

            @Override
            void drawRightMeasurement(GC canvasGC, GraphicsMeasuring hgm) {
                GraphicsComposite hgc = hgm.graphicsComposite;
                long startTime = new Date().getTime();
                String statusMessage = hgm.curveSurvey.drawDeltaMeasurementGraphics();
                hgc.windowActor.setStatusMessage(statusMessage);
                hgc.recordSetComment.setText(MeasuringMode.getSelectedMeasurementsAsTable(hgc.recordSetComment, hgm.measure.getTimestampMeasure_ms()));
                hgc.recordSetComment.setToolTipText(Messages.getString("GDE_MSGT0897"));
                log.time(() -> "draw time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
            }
        };


        abstract void setMode(GraphicsMeasuring var1);

        abstract void drawMeasurement(GC var1, GraphicsMeasuring var2);

        abstract void drawLeftMeasurement(GC var1, GraphicsMeasuring var2);

        abstract void drawRightMeasurement(GC var1, GraphicsMeasuring var2);

        private static String getSelectedMeasurementsAsTable(Text recordSetComment, long timestamp_ms) {
            recordSetComment.setFont(SWTResourceManager.getFont("Courier New", GDE.WIDGET_FONT_SIZE - 1, 1));
            return TrailRecordSetFormatter.getSelectedMeasurementsAsTable(timestamp_ms);
        }

        static MeasuringMode getMode(boolean isDeltaMeasuring) {
            if (isDeltaMeasuring) {
                return MEASURE_DELTA;
            }
            return MEASURE;
        }
    }
}

