/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.BoxCollector;
import org.xhtmlrenderer.layout.InlineBoxing;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.render.AnonymousBlockBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.CharCounts;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.JustificationInfo;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.TextDecoration;

public class InlineLayoutBox
extends Box
implements InlinePaintable {
    private int _baseline;
    private boolean _startsHere;
    private boolean _endsHere;
    private List _inlineChildren;
    private boolean _pending;
    private int _inlineWidth;
    private List _textDecorations;
    private int _containingBlockWidth;

    public InlineLayoutBox(LayoutContext c, Element elem, CalculatedStyle style, int cbWidth) {
        this();
        this.setElement(elem);
        this.setStyle(style);
        this.setContainingBlockWidth(cbWidth);
        this.setMarginTop(c, 0);
        this.setMarginBottom(c, 0);
        this.setPending(true);
        this.calculateHeight(c);
    }

    private InlineLayoutBox() {
        this.setState(3);
    }

    public InlineLayoutBox copyOf() {
        InlineLayoutBox result2 = new InlineLayoutBox();
        result2.setElement(this.getElement());
        result2.setStyle(this.getStyle());
        result2.setHeight(this.getHeight());
        result2._pending = this._pending;
        result2.setContainingLayer(this.getContainingLayer());
        return result2;
    }

    public void calculateHeight(LayoutContext c) {
        BorderPropertySet border = this.getBorder(c);
        RectPropertySet padding = this.getPadding(c);
        FSFontMetrics metrics = this.getStyle().getFSFontMetrics(c);
        this.setHeight((int)Math.ceil(border.top() + padding.top() + metrics.getAscent() + metrics.getDescent() + padding.bottom() + border.bottom()));
    }

    public int getBaseline() {
        return this._baseline;
    }

    public void setBaseline(int baseline) {
        this._baseline = baseline;
    }

    public int getInlineChildCount() {
        return this._inlineChildren == null ? 0 : this._inlineChildren.size();
    }

    public void addInlineChild(LayoutContext c, Object child) {
        this.addInlineChild(c, child, true);
    }

    public void addInlineChild(LayoutContext c, Object child, boolean callUnmarkPending) {
        if (this._inlineChildren == null) {
            this._inlineChildren = new ArrayList();
        }
        this._inlineChildren.add(child);
        if (callUnmarkPending && this.isPending()) {
            this.unmarkPending(c);
        }
        if (child instanceof Box) {
            Box b = (Box)child;
            b.setParent(this);
            b.initContainingLayer(c);
        } else if (child instanceof InlineText) {
            ((InlineText)child).setParent(this);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public List getInlineChildren() {
        return this._inlineChildren == null ? Collections.EMPTY_LIST : this._inlineChildren;
    }

    public Object getInlineChild(int i2) {
        if (this._inlineChildren == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._inlineChildren.get(i2);
    }

    public int getInlineWidth(CssContext cssCtx) {
        return this._inlineWidth;
    }

    public void prunePending() {
        if (this.getInlineChildCount() > 0) {
            Object child;
            for (int i2 = this.getInlineChildCount() - 1; i2 >= 0 && (child = this.getInlineChild(i2)) instanceof InlineLayoutBox; --i2) {
                InlineLayoutBox iB = (InlineLayoutBox)child;
                iB.prunePending();
                if (!iB.isPending()) break;
                this.removeChild(i2);
            }
        }
    }

    public boolean isEndsHere() {
        return this._endsHere;
    }

    public void setEndsHere(boolean endsHere) {
        this._endsHere = endsHere;
    }

    public boolean isStartsHere() {
        return this._startsHere;
    }

    public void setStartsHere(boolean startsHere) {
        this._startsHere = startsHere;
    }

    public boolean isPending() {
        return this._pending;
    }

    public void setPending(boolean b) {
        this._pending = b;
    }

    public void unmarkPending(LayoutContext c) {
        InlineLayoutBox iB;
        this._pending = false;
        if (this.getParent() instanceof InlineLayoutBox && (iB = (InlineLayoutBox)this.getParent()).isPending()) {
            iB.unmarkPending(c);
        }
        this.setStartsHere(true);
        if (this.getStyle().requiresLayer()) {
            c.pushLayer(this);
            this.getLayer().setInline(true);
            this.connectChildrenToCurrentLayer(c);
        }
    }

    @Override
    public void connectChildrenToCurrentLayer(LayoutContext c) {
        if (this.getInlineChildCount() > 0) {
            for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
                Object obj = this.getInlineChild(i2);
                if (!(obj instanceof Box)) continue;
                Box box = (Box)obj;
                box.setContainingLayer(c.getLayer());
                box.connectChildrenToCurrentLayer(c);
            }
        }
    }

    public void paintSelection(RenderingContext c) {
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object child = this.getInlineChild(i2);
            if (!(child instanceof InlineText)) continue;
            ((InlineText)child).paintSelection(c);
        }
    }

    @Override
    public void paintInline(RenderingContext c) {
        IdentValue ident;
        List textDecorations;
        if (!this.getStyle().isVisible()) {
            return;
        }
        this.paintBackground(c);
        this.paintBorder(c);
        if (c.debugDrawInlineBoxes()) {
            this.paintDebugOutline(c);
        }
        if ((textDecorations = this.getTextDecorations()) != null) {
            for (TextDecoration tD : textDecorations) {
                ident = tD.getIdentValue();
                if (ident != IdentValue.UNDERLINE && ident != IdentValue.OVERLINE) continue;
                c.getOutputDevice().drawTextDecoration(c, this, tD);
            }
        }
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object child = this.getInlineChild(i2);
            if (!(child instanceof InlineText)) continue;
            ((InlineText)child).paint(c);
        }
        if (textDecorations != null) {
            for (TextDecoration tD : textDecorations) {
                ident = tD.getIdentValue();
                if (ident != IdentValue.LINE_THROUGH) continue;
                c.getOutputDevice().drawTextDecoration(c, this, tD);
            }
        }
    }

    @Override
    public int getBorderSides() {
        int result2 = 5;
        if (this._startsHere) {
            result2 += 2;
        }
        if (this._endsHere) {
            result2 += 8;
        }
        return result2;
    }

    @Override
    public Rectangle getBorderEdge(int left2, int top2, CssContext cssCtx) {
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        if (this._startsHere || this._endsHere) {
            RectPropertySet margin = this.getMargin(cssCtx);
            if (this._startsHere) {
                marginLeft = margin.left();
            }
            if (this._endsHere) {
                marginRight = margin.right();
            }
        }
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet padding = this.getPadding(cssCtx);
        Rectangle result2 = new Rectangle((int)((float)left2 + marginLeft), (int)((float)top2 - border.top() - padding.top()), (int)((float)this.getInlineWidth(cssCtx) - marginLeft - marginRight), this.getHeight());
        return result2;
    }

    @Override
    public Rectangle getMarginEdge(int left2, int top2, CssContext cssCtx, int tx, int ty) {
        Rectangle result2 = this.getBorderEdge(left2, top2, cssCtx);
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        if (this._startsHere || this._endsHere) {
            RectPropertySet margin = this.getMargin(cssCtx);
            if (this._startsHere) {
                marginLeft = margin.left();
            }
            if (this._endsHere) {
                marginRight = margin.right();
            }
        }
        if (marginRight > 0.0f) {
            result2.width = (int)((float)result2.width + marginRight);
        }
        if (marginLeft > 0.0f) {
            result2.x = (int)((float)result2.x - marginLeft);
            result2.width = (int)((float)result2.width + marginLeft);
        }
        result2.translate(tx, ty);
        return result2;
    }

    @Override
    public Rectangle getContentAreaEdge(int left2, int top2, CssContext cssCtx) {
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet padding = this.getPadding(cssCtx);
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        float borderLeft = 0.0f;
        float borderRight = 0.0f;
        float paddingLeft = 0.0f;
        float paddingRight = 0.0f;
        if (this._startsHere || this._endsHere) {
            RectPropertySet margin = this.getMargin(cssCtx);
            if (this._startsHere) {
                marginLeft = margin.left();
                borderLeft = border.left();
                paddingLeft = padding.left();
            }
            if (this._endsHere) {
                marginRight = margin.right();
                borderRight = border.right();
                paddingRight = padding.right();
            }
        }
        Rectangle result2 = new Rectangle((int)((float)left2 + marginLeft + borderLeft + paddingLeft), (int)((float)top2 - border.top() - padding.top()), (int)((float)this.getInlineWidth(cssCtx) - marginLeft - borderLeft - paddingLeft - paddingRight - borderRight - marginRight), this.getHeight());
        return result2;
    }

    public int getLeftMarginBorderPadding(CssContext cssCtx) {
        if (this._startsHere) {
            return this.getMarginBorderPadding(cssCtx, 1);
        }
        return 0;
    }

    public int getRightMarginPaddingBorder(CssContext cssCtx) {
        if (this._endsHere) {
            return this.getMarginBorderPadding(cssCtx, 2);
        }
        return 0;
    }

    public int getInlineWidth() {
        return this._inlineWidth;
    }

    public void setInlineWidth(int inlineWidth) {
        this._inlineWidth = inlineWidth;
    }

    public boolean isContainsVisibleContent() {
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Box b;
            InlineLayoutBox iB;
            InlineText iT;
            Object child = this.getInlineChild(i2);
            if (!(child instanceof InlineText ? !(iT = (InlineText)child).isEmpty() : (child instanceof InlineLayoutBox ? (iB = (InlineLayoutBox)child).isContainsVisibleContent() : (b = (Box)child).getWidth() > 0 || b.getHeight() > 0))) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsInlineBlocks(CssContext cssCtx, Shape clip) {
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            BoxCollector collector;
            boolean possibleResult;
            Object obj = this.getInlineChild(i2);
            if (!(obj instanceof InlineLayoutBox ? (possibleResult = ((InlineLayoutBox)obj).intersectsInlineBlocks(cssCtx, clip)) : obj instanceof Box && (collector = new BoxCollector()).intersectsAny(cssCtx, clip, (Box)obj))) continue;
            return true;
        }
        return false;
    }

    public List getTextDecorations() {
        return this._textDecorations;
    }

    public void setTextDecorations(List textDecoration) {
        this._textDecorations = textDecoration;
    }

    private void addToContentList(List list2) {
        list2.add(this);
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object child = this.getInlineChild(i2);
            if (child instanceof InlineLayoutBox) {
                ((InlineLayoutBox)child).addToContentList(list2);
                continue;
            }
            if (!(child instanceof Box)) continue;
            list2.add(child);
        }
    }

    public LineBox getLineBox() {
        Box b = this.getParent();
        while (!(b instanceof LineBox)) {
            b = b.getParent();
        }
        return (LineBox)b;
    }

    public List getElementWithContent() {
        ArrayList result2 = new ArrayList();
        BlockBox container = (BlockBox)this.getLineBox().getParent();
        do {
            List elementBoxes = container.getElementBoxes(this.getElement());
            for (int i2 = 0; i2 < elementBoxes.size(); ++i2) {
                InlineLayoutBox iB = (InlineLayoutBox)elementBoxes.get(i2);
                iB.addToContentList(result2);
            }
        } while (container instanceof AnonymousBlockBox && !this.containsEnd(result2) && (container = this.addFollowingBlockBoxes(container, result2)) != null);
        return result2;
    }

    private AnonymousBlockBox addFollowingBlockBoxes(BlockBox container, List result2) {
        int current;
        Box parent = container.getParent();
        for (current = 0; current < parent.getChildCount(); ++current) {
            if (parent.getChild(current) != container) continue;
            ++current;
            break;
        }
        while (current < parent.getChildCount() && !(parent.getChild(current) instanceof AnonymousBlockBox)) {
            result2.add(parent.getChild(current));
            ++current;
        }
        return current == parent.getChildCount() ? null : (AnonymousBlockBox)parent.getChild(current);
    }

    private boolean containsEnd(List result2) {
        for (int i2 = 0; i2 < result2.size(); ++i2) {
            Box b = (Box)result2.get(i2);
            if (!(b instanceof InlineLayoutBox)) continue;
            InlineLayoutBox iB = (InlineLayoutBox)b;
            if (this.getElement() != iB.getElement() || !iB.isEndsHere()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getElementBoxes(Element elem) {
        ArrayList<Box> result2 = new ArrayList<Box>();
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object child = this.getInlineChild(i2);
            if (!(child instanceof Box)) continue;
            Box b = (Box)child;
            if (b.getElement() == elem) {
                result2.add(b);
            }
            result2.addAll(b.getElementBoxes(elem));
        }
        return result2;
    }

    @Override
    public Dimension positionRelative(CssContext cssCtx) {
        Dimension delta = super.positionRelative(cssCtx);
        this.setX(this.getX() - delta.width);
        this.setY(this.getY() - delta.height);
        List toTranslate = this.getElementWithContent();
        for (int i2 = 0; i2 < toTranslate.size(); ++i2) {
            Box b = (Box)toTranslate.get(i2);
            b.setX(b.getX() + delta.width);
            b.setY(b.getY() + delta.height);
            b.calcCanvasLocation();
            b.calcChildLocations();
        }
        return delta;
    }

    public void addAllChildren(List list2, Layer layer) {
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object child = this.getInlineChild(i2);
            if (!(child instanceof Box) || ((Box)child).getContainingLayer() != layer) continue;
            list2.add(child);
            if (!(child instanceof InlineLayoutBox)) continue;
            ((InlineLayoutBox)child).addAllChildren(list2, layer);
        }
    }

    public void paintDebugOutline(RenderingContext c) {
        c.getOutputDevice().drawDebugOutline(c, this, FSRGBColor.BLUE);
    }

    @Override
    protected void resetChildren(LayoutContext c) {
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object object = this.getInlineChild(i2);
            if (!(object instanceof Box)) continue;
            ((Box)object).reset(c);
        }
    }

    @Override
    public void removeChild(Box child) {
        if (this._inlineChildren != null) {
            this._inlineChildren.remove(child);
        }
    }

    @Override
    public void removeChild(int i2) {
        if (this._inlineChildren != null) {
            this._inlineChildren.remove(i2);
        }
    }

    @Override
    protected Box getPrevious(Box child) {
        if (this._inlineChildren == null) {
            return null;
        }
        for (int i2 = 0; i2 < this._inlineChildren.size() - 1; ++i2) {
            Object obj = this._inlineChildren.get(i2);
            if (obj != child) continue;
            if (i2 == 0) {
                return null;
            }
            Object previous = this._inlineChildren.get(i2 - 1);
            return previous instanceof Box ? (Box)previous : null;
        }
        return null;
    }

    @Override
    protected Box getNext(Box child) {
        if (this._inlineChildren == null) {
            return null;
        }
        for (int i2 = 0; i2 < this._inlineChildren.size() - 1; ++i2) {
            Object obj = this._inlineChildren.get(i2);
            if (obj != child) continue;
            Object next = this._inlineChildren.get(i2 + 1);
            return next instanceof Box ? (Box)next : null;
        }
        return null;
    }

    @Override
    public void calcCanvasLocation() {
        LineBox lineBox = this.getLineBox();
        this.setAbsX(lineBox.getAbsX() + this.getX());
        this.setAbsY(lineBox.getAbsY() + this.getY());
    }

    @Override
    public void calcChildLocations() {
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object obj = this.getInlineChild(i2);
            if (!(obj instanceof Box)) continue;
            Box child = (Box)obj;
            child.calcCanvasLocation();
            child.calcChildLocations();
        }
    }

    @Override
    public void clearSelection(List modified) {
        boolean changed2 = false;
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object obj = this.getInlineChild(i2);
            if (obj instanceof Box) {
                ((Box)obj).clearSelection(modified);
                continue;
            }
            changed2 |= ((InlineText)obj).clearSelection();
        }
        if (changed2) {
            modified.add(this);
        }
    }

    @Override
    public void selectAll() {
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object obj = this.getInlineChild(i2);
            if (obj instanceof Box) {
                ((Box)obj).selectAll();
                continue;
            }
            ((InlineText)obj).selectAll();
        }
    }

    @Override
    protected void calcChildPaintingInfo(CssContext c, PaintingInfo result2, boolean useCache) {
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object obj = this.getInlineChild(i2);
            if (!(obj instanceof Box)) continue;
            PaintingInfo info = ((Box)obj).calcPaintingInfo(c, useCache);
            this.moveIfGreater(result2.getOuterMarginCorner(), info.getOuterMarginCorner());
            result2.getAggregateBounds().add(info.getAggregateBounds());
        }
    }

    public void lookForDynamicFunctions(RenderingContext c) {
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object obj = this.getInlineChild(i2);
            if (obj instanceof InlineText) {
                InlineText iT = (InlineText)obj;
                if (!iT.isDynamicFunction()) continue;
                iT.updateDynamicValue(c);
                continue;
            }
            if (!(obj instanceof InlineLayoutBox)) continue;
            ((InlineLayoutBox)obj).lookForDynamicFunctions(c);
        }
    }

    public InlineText findTrailingText() {
        if (this.getInlineChildCount() == 0) {
            return null;
        }
        InlineText result2 = null;
        for (int offset = this.getInlineChildCount() - 1; offset >= 0; --offset) {
            Object child = this.getInlineChild(offset);
            if (child instanceof InlineText) {
                result2 = (InlineText)child;
                if (result2.isEmpty()) continue;
                return result2;
            }
            if (child instanceof InlineLayoutBox) {
                result2 = ((InlineLayoutBox)child).findTrailingText();
                if (result2 != null && result2.isEmpty()) continue;
                return result2;
            }
            return null;
        }
        return result2;
    }

    public void calculateTextDecoration(LayoutContext c) {
        List decorations = InlineBoxing.calculateTextDecorations(this, this.getBaseline(), this.getStyle().getFSFontMetrics(c));
        this.setTextDecorations(decorations);
    }

    @Override
    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        PaintingInfo pI = this.getPaintingInfo();
        if (pI != null && !pI.getAggregateBounds().contains(absX, absY)) {
            return null;
        }
        Box result2 = null;
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object child = this.getInlineChild(i2);
            if (!(child instanceof Box) || (result2 = ((Box)child).find(cssCtx, absX, absY, findAnonymous)) == null) continue;
            return result2;
        }
        Rectangle edge = this.getContentAreaEdge(this.getAbsX(), this.getAbsY(), cssCtx);
        Box box = result2 = edge.contains(absX, absY) && this.getStyle().isVisible() ? this : null;
        if (!findAnonymous && result2 != null && this.getElement() == null) {
            return this.getParent().getParent();
        }
        return result2;
    }

    @Override
    public int getContainingBlockWidth() {
        return this._containingBlockWidth;
    }

    public void setContainingBlockWidth(int containingBlockWidth) {
        this._containingBlockWidth = containingBlockWidth;
    }

    @Override
    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append("InlineLayoutBox: ");
        if (this.getElement() != null) {
            result2.append("<");
            result2.append(this.getElement().getNodeName());
            result2.append("> ");
        } else {
            result2.append("(anonymous) ");
        }
        if (this.isStartsHere() || this.isEndsHere()) {
            result2.append("(");
            if (this.isStartsHere()) {
                result2.append("S");
            }
            if (this.isEndsHere()) {
                result2.append("E");
            }
            result2.append(") ");
        }
        result2.append("(baseline=");
        result2.append(this._baseline);
        result2.append(") ");
        result2.append("(" + this.getAbsX() + "," + this.getAbsY() + ")->(" + this.getInlineWidth() + " x " + this.getHeight() + ")");
        return result2.toString();
    }

    @Override
    public String dump(LayoutContext c, String indent, int which) {
        if (which != 2) {
            throw new IllegalArgumentException();
        }
        StringBuffer result2 = new StringBuffer(indent);
        result2.append(this);
        result2.append('\n');
        Iterator i2 = this.getInlineChildren().iterator();
        while (i2.hasNext()) {
            Object obj = i2.next();
            if (obj instanceof Box) {
                Box b = (Box)obj;
                result2.append(b.dump(c, indent + "  ", which));
                if (result2.charAt(result2.length() - 1) == '\n') {
                    result2.deleteCharAt(result2.length() - 1);
                }
            } else {
                result2.append(indent + "  ");
                result2.append(obj.toString());
            }
            if (!i2.hasNext()) continue;
            result2.append('\n');
        }
        return result2.toString();
    }

    @Override
    public void restyle(LayoutContext c) {
        super.restyle(c);
        this.calculateTextDecoration(c);
    }

    @Override
    protected void restyleChildren(LayoutContext c) {
        for (int i2 = 0; i2 < this.getInlineChildCount(); ++i2) {
            Object obj = this.getInlineChild(i2);
            if (!(obj instanceof Box)) continue;
            ((Box)obj).restyle(c);
        }
    }

    @Override
    public Box getRestyleTarget() {
        Box result2 = this.getParent();
        while (result2 instanceof InlineLayoutBox) {
            result2 = result2.getParent();
        }
        return result2.getParent();
    }

    @Override
    public void collectText(RenderingContext c, StringBuffer buffer) throws IOException {
        for (Object obj : this.getInlineChildren()) {
            if (obj instanceof InlineText) {
                buffer.append(((InlineText)obj).getTextExportText());
                continue;
            }
            ((Box)obj).collectText(c, buffer);
        }
    }

    public void countJustifiableChars(CharCounts counts) {
        boolean justifyThis = this.getStyle().isTextJustify();
        for (Object o : this.getInlineChildren()) {
            if (o instanceof InlineLayoutBox) {
                ((InlineLayoutBox)o).countJustifiableChars(counts);
                continue;
            }
            if (!(o instanceof InlineText) || !justifyThis) continue;
            ((InlineText)o).countJustifiableChars(counts);
        }
    }

    public float adjustHorizontalPosition(JustificationInfo info, float adjust) {
        float runningTotal = adjust;
        float result2 = 0.0f;
        for (Object o : this.getInlineChildren()) {
            float adj;
            if (o instanceof InlineText) {
                InlineText iT = (InlineText)o;
                iT.setX(iT.getX() + Math.round(result2));
                adj = iT.calcTotalAdjustment(info);
                result2 += adj;
                runningTotal += adj;
                continue;
            }
            Box b = (Box)o;
            b.setX(b.getX() + Math.round(runningTotal));
            if (!(b instanceof InlineLayoutBox)) continue;
            adj = ((InlineLayoutBox)b).adjustHorizontalPosition(info, runningTotal);
            result2 += adj;
            runningTotal += adj;
        }
        return result2;
    }

    @Override
    public int getEffectiveWidth() {
        return this.getInlineWidth();
    }
}

