/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

@Deprecated
public class TableTree
extends Composite {
    Table table;
    TableTreeItem[] items = EMPTY_ITEMS;
    Image plusImage;
    Image minusImage;
    Image sizeImage;
    Listener listener;
    boolean inDispose = false;
    static final TableTreeItem[] EMPTY_ITEMS = new TableTreeItem[0];
    static final String[] EMPTY_TEXTS = new String[0];
    static final Image[] EMPTY_IMAGES = new Image[0];
    static final String ITEMID = "TableTreeItemID";

    public TableTree(Composite parent, int style) {
        super(parent, TableTree.checkStyle(style));
        this.table = new Table(this, style);
        Listener tableListener = e -> {
            switch (e.type) {
                case 3: {
                    this.onMouseDown(e);
                    break;
                }
                case 13: {
                    this.onSelection(e);
                    break;
                }
                case 14: {
                    this.onSelection(e);
                    break;
                }
                case 1: {
                    this.onKeyDown(e);
                }
            }
        };
        int[] tableEvents = new int[]{3, 13, 14, 1};
        int i2 = 0;
        while (i2 < tableEvents.length) {
            this.table.addListener(tableEvents[i2], tableListener);
            ++i2;
        }
        this.listener = e -> {
            switch (e.type) {
                case 12: {
                    this.onDispose(e);
                    break;
                }
                case 11: {
                    this.onResize(e);
                    break;
                }
                case 15: {
                    this.onFocusIn(e);
                }
            }
        };
        int[] events = new int[]{12, 11, 15};
        int i3 = 0;
        while (i3 < events.length) {
            this.addListener(events[i3], this.listener);
            ++i3;
        }
    }

    int addItem(TableTreeItem item2, int index) {
        if (index < 0 || index > this.items.length) {
            SWT.error(5);
        }
        TableTreeItem[] newItems = new TableTreeItem[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = item2;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        if (index == this.items.length - 1) {
            return this.table.getItemCount();
        }
        return this.table.indexOf(this.items[index + 1].tableItem);
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    private static int checkStyle(int style) {
        int mask = 0x6000000;
        return style &= mask;
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed2) {
        this.checkWidget();
        return this.table.computeSize(wHint, hHint, changed2);
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        return this.table.computeTrim(x, y, width, height);
    }

    public void deselectAll() {
        this.checkWidget();
        this.table.deselectAll();
    }

    void expandItem(TableTreeItem item2) {
        if (item2 == null) {
            return;
        }
        this.expandItem(item2.parentItem);
        if (!item2.getVisible()) {
            item2.setVisible(true);
        }
        if (!item2.expanded && item2.items.length > 0) {
            item2.setExpanded(true);
            Event event = new Event();
            event.item = item2;
            this.notifyListeners(17, event);
        }
    }

    @Override
    public Color getBackground() {
        return this.table.getBackground();
    }

    @Override
    public Rectangle getClientArea() {
        return this.table.getClientArea();
    }

    @Override
    public Color getForeground() {
        return this.table.getForeground();
    }

    @Override
    public Font getFont() {
        return this.table.getFont();
    }

    public int getItemCount() {
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.table.getItemHeight();
    }

    public TableTreeItem[] getItems() {
        TableTreeItem[] newItems = new TableTreeItem[this.items.length];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        return newItems;
    }

    public TableTreeItem[] getSelection() {
        this.checkWidget();
        TableItem[] selection2 = this.table.getSelection();
        TableTreeItem[] result2 = new TableTreeItem[selection2.length];
        int i2 = 0;
        while (i2 < selection2.length) {
            result2[i2] = (TableTreeItem)selection2[i2].getData(ITEMID);
            ++i2;
        }
        return result2;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.table.getSelectionCount();
    }

    @Override
    public int getStyle() {
        this.checkWidget();
        return this.table.getStyle();
    }

    public Table getTable() {
        return this.table;
    }

    void createImages() {
        int itemHeight = this.sizeImage.getBounds().height;
        int indent = Math.min(6, (itemHeight - 9) / 2);
        indent = Math.max(0, indent);
        int size = Math.max(10, itemHeight - 2 * indent);
        size = (size + 1) / 2 * 2;
        int midpoint = indent + size / 2;
        Color foreground = this.getForeground();
        Color plusMinus = this.getDisplay().getSystemColor(18);
        Color background = this.getBackground();
        PaletteData palette = new PaletteData(foreground.getRGB(), background.getRGB(), plusMinus.getRGB());
        ImageData imageData = new ImageData(itemHeight, itemHeight, 4, palette);
        imageData.transparentPixel = 1;
        this.plusImage = new Image((Device)this.getDisplay(), imageData);
        GC gc = new GC(this.plusImage);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, itemHeight, itemHeight);
        gc.setForeground(plusMinus);
        gc.drawRectangle(indent, indent, size, size);
        gc.setForeground(foreground);
        gc.drawLine(midpoint, indent + 2, midpoint, indent + size - 2);
        gc.drawLine(indent + 2, midpoint, indent + size - 2, midpoint);
        gc.dispose();
        palette = new PaletteData(foreground.getRGB(), background.getRGB(), plusMinus.getRGB());
        imageData = new ImageData(itemHeight, itemHeight, 4, palette);
        imageData.transparentPixel = 1;
        this.minusImage = new Image((Device)this.getDisplay(), imageData);
        gc = new GC(this.minusImage);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, itemHeight, itemHeight);
        gc.setForeground(plusMinus);
        gc.drawRectangle(indent, indent, size, size);
        gc.setForeground(foreground);
        gc.drawLine(indent + 2, midpoint, indent + size - 2, midpoint);
        gc.dispose();
    }

    Image getPlusImage() {
        if (this.plusImage == null) {
            this.createImages();
        }
        return this.plusImage;
    }

    Image getMinusImage() {
        if (this.minusImage == null) {
            this.createImages();
        }
        return this.minusImage;
    }

    public int indexOf(TableTreeItem item2) {
        int i2 = 0;
        while (i2 < this.items.length) {
            if (item2 == this.items[i2]) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    void onDispose(Event e) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, e);
        e.type = 0;
        this.inDispose = true;
        int i2 = 0;
        while (i2 < this.items.length) {
            this.items[i2].dispose();
            ++i2;
        }
        this.inDispose = false;
        if (this.plusImage != null) {
            this.plusImage.dispose();
        }
        if (this.minusImage != null) {
            this.minusImage.dispose();
        }
        if (this.sizeImage != null) {
            this.sizeImage.dispose();
        }
        this.sizeImage = null;
        this.minusImage = null;
        this.plusImage = null;
    }

    void onResize(Event e) {
        Point size = this.getSize();
        this.table.setBounds(0, 0, size.x, size.y);
    }

    void onSelection(Event e) {
        Event event = new Event();
        TableItem tableItem = (TableItem)e.item;
        TableTreeItem item2 = this.getItem(tableItem);
        event.item = item2;
        if (e.type == 13 && e.detail == 32 && item2 != null) {
            event.detail = 32;
            item2.checked = tableItem.getChecked();
        }
        this.notifyListeners(e.type, event);
    }

    public TableTreeItem getItem(int index) {
        this.checkWidget();
        int count = this.items.length;
        if (index < 0 || index >= count) {
            SWT.error(6);
        }
        return this.items[index];
    }

    public TableTreeItem getItem(Point point) {
        this.checkWidget();
        TableItem item2 = this.table.getItem(point);
        if (item2 == null) {
            return null;
        }
        return this.getItem(item2);
    }

    TableTreeItem getItem(TableItem tableItem) {
        if (tableItem == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.items.length) {
            TableTreeItem item2 = this.items[i2].getItem(tableItem);
            if (item2 != null) {
                return item2;
            }
            ++i2;
        }
        return null;
    }

    void onFocusIn(Event e) {
        this.table.setFocus();
    }

    void onKeyDown(Event e) {
        TableTreeItem[] selection2 = this.getSelection();
        if (selection2.length == 0) {
            return;
        }
        TableTreeItem item2 = selection2[0];
        int type2 = 0;
        if (e.keyCode == 0x1000004 || e.keyCode == 0x1000003) {
            int trailKey;
            int n = trailKey = (this.getStyle() & 0x8000000) != 0 ? 0x1000003 : 0x1000004;
            if (e.keyCode == trailKey) {
                if (item2.getItemCount() == 0) {
                    return;
                }
                if (item2.getExpanded()) {
                    TableTreeItem newSelection = item2.getItems()[0];
                    this.table.setSelection(new TableItem[]{newSelection.tableItem});
                    this.showItem(newSelection);
                    type2 = 13;
                } else {
                    item2.setExpanded(true);
                    type2 = 17;
                }
            } else if (item2.getExpanded()) {
                item2.setExpanded(false);
                type2 = 18;
            } else {
                TableTreeItem parent = item2.getParentItem();
                if (parent != null) {
                    int index = parent.indexOf(item2);
                    if (index != 0) {
                        return;
                    }
                    this.table.setSelection(new TableItem[]{parent.tableItem});
                    type2 = 13;
                }
            }
        }
        if (e.character == '*') {
            item2.expandAll(true);
        }
        if (e.character == '-' && item2.getExpanded()) {
            item2.setExpanded(false);
            type2 = 18;
        }
        if (e.character == '+' && item2.getItemCount() > 0 && !item2.getExpanded()) {
            item2.setExpanded(true);
            type2 = 17;
        }
        if (type2 == 0) {
            return;
        }
        Event event = new Event();
        event.item = item2;
        this.notifyListeners(type2, event);
    }

    void onMouseDown(Event event) {
        TableItem[] items = this.table.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            Rectangle rect = items[i2].getImageBounds(0);
            if (rect.contains(event.x, event.y)) {
                TableTreeItem item2 = (TableTreeItem)items[i2].getData(ITEMID);
                event = new Event();
                event.item = item2;
                item2.setExpanded(!item2.getExpanded());
                if (item2.getExpanded()) {
                    this.notifyListeners(17, event);
                } else {
                    this.notifyListeners(18, event);
                }
                return;
            }
            ++i2;
        }
    }

    public void removeAll() {
        this.checkWidget();
        this.setRedraw(false);
        int i2 = this.items.length - 1;
        while (i2 >= 0) {
            this.items[i2].dispose();
            --i2;
        }
        this.items = EMPTY_ITEMS;
        this.setRedraw(true);
    }

    void removeItem(TableTreeItem item2) {
        int index = 0;
        while (index < this.items.length && this.items[index] != item2) {
            ++index;
        }
        if (index == this.items.length) {
            return;
        }
        TableTreeItem[] newItems = new TableTreeItem[this.items.length - 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
        this.items = newItems;
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener2);
        this.removeListener(14, listener2);
    }

    public void removeTreeListener(TreeListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        this.removeListener(17, listener2);
        this.removeListener(18, listener2);
    }

    public void selectAll() {
        this.checkWidget();
        this.table.selectAll();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.table.setBackground(color);
        if (this.sizeImage != null) {
            GC gc = new GC(this.sizeImage);
            gc.setBackground(this.getBackground());
            Rectangle size = this.sizeImage.getBounds();
            gc.fillRectangle(size);
            gc.dispose();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.table.setFont(font);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.table.setForeground(color);
    }

    @Override
    public void setMenu(Menu menu2) {
        super.setMenu(menu2);
        this.table.setMenu(menu2);
    }

    public void setSelection(TableTreeItem[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            SWT.error(4);
        }
        if ((length = items.length) == 0 || (this.table.getStyle() & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        TableItem[] tableItems = new TableItem[length];
        int i2 = 0;
        while (i2 < length) {
            if (items[i2] == null) {
                SWT.error(4);
            }
            if (!items[i2].getVisible()) {
                this.expandItem(items[i2]);
            }
            tableItems[i2] = items[i2].tableItem;
            ++i2;
        }
        this.table.setSelection(tableItems);
    }

    @Override
    public void setToolTipText(String string2) {
        super.setToolTipText(string2);
        this.table.setToolTipText(string2);
    }

    public void showItem(TableTreeItem item2) {
        this.checkWidget();
        if (item2 == null) {
            SWT.error(4);
        }
        if (!item2.getVisible()) {
            this.expandItem(item2);
        }
        TableItem tableItem = item2.tableItem;
        this.table.showItem(tableItem);
    }

    public void showSelection() {
        this.checkWidget();
        this.table.showSelection();
    }
}

