/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderLayout;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;

public class CTabFolder
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    @Deprecated
    public int MIN_TAB_WIDTH = 4;
    @Deprecated
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    @Deprecated
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    @Deprecated
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    boolean onBottom = false;
    boolean single = false;
    boolean simple = true;
    int fixedTabHeight = -1;
    int tabHeight;
    int minChars = 20;
    boolean borderVisible = false;
    CTabFolderRenderer renderer;
    CTabItem[] items = new CTabItem[0];
    int firstIndex = -1;
    int selectedIndex = -1;
    int[] priority = new int[0];
    boolean mru = false;
    Listener listener;
    boolean ignoreTraverse;
    boolean useDefaultRenderer;
    CTabFolder2Listener[] folderListeners = new CTabFolder2Listener[0];
    CTabFolderListener[] tabListeners = new CTabFolderListener[0];
    Image selectionBgImage;
    Color[] selectionGradientColors;
    int[] selectionGradientPercents;
    boolean selectionGradientVertical;
    Color selectionForeground;
    Color selectionBackground;
    Color[] gradientColors;
    int[] gradientPercents;
    boolean gradientVertical;
    boolean showUnselectedImage = true;
    boolean showClose = false;
    boolean showUnselectedClose = true;
    boolean showMin = false;
    boolean minimized = false;
    boolean showMax = false;
    boolean maximized = false;
    ToolBar minMaxTb;
    ToolItem maxItem;
    ToolItem minItem;
    Image maxImage;
    Image minImage;
    boolean hoverTb;
    Rectangle hoverRect = new Rectangle(0, 0, 0, 0);
    boolean hovering;
    boolean hoverTimerRunning;
    boolean highlight;
    boolean highlightEnabled = true;
    boolean showChevron = false;
    Menu showMenu;
    ToolBar chevronTb;
    ToolItem chevronItem;
    int chevronCount;
    boolean chevronVisible = true;
    Image chevronImage;
    Control topRight;
    int topRightAlignment = 131072;
    boolean ignoreResize;
    Control[] controls;
    int[] controlAlignments;
    Rectangle[] controlRects;
    Image[] controlBkImages;
    int updateFlags;
    static final int REDRAW = 2;
    static final int REDRAW_TABS = 4;
    static final int UPDATE_TAB_HEIGHT = 8;
    Runnable updateRun;
    boolean inDispose = false;
    Point oldSize;
    Font oldFont;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int SELECTION_FOREGROUND = 24;
    static final int SELECTION_BACKGROUND = 25;
    static final int FOREGROUND = 21;
    static final int BACKGROUND = 22;
    static final int SPACING = 3;

    public CTabFolder(Composite parent, int style) {
        super(parent, CTabFolder.checkStyle(parent, style));
        this.init(style);
    }

    void init(int style) {
        super.setLayout(new CTabFolderLayout());
        int style2 = super.getStyle();
        this.oldFont = this.getFont();
        this.onBottom = (style2 & 0x400) != 0;
        this.showClose = (style2 & 0x40) != 0;
        this.single = (style2 & 4) != 0;
        this.borderVisible = (style & 0x800) != 0;
        Display display = this.getDisplay();
        this.selectionForeground = display.getSystemColor(24);
        this.selectionBackground = display.getSystemColor(25);
        this.renderer = new CTabFolderRenderer(this);
        this.useDefaultRenderer = true;
        this.controls = new Control[0];
        this.controlAlignments = new int[0];
        this.controlRects = new Rectangle[0];
        this.controlBkImages = new Image[0];
        this.updateTabHeight(false);
        this.listener = event -> {
            switch (event.type) {
                case 12: {
                    this.onDispose(event);
                    break;
                }
                case 29: {
                    this.onDragDetect(event);
                    break;
                }
                case 15: {
                    this.onFocus(event);
                    break;
                }
                case 16: {
                    this.onFocus(event);
                    break;
                }
                case 1: {
                    this.onKeyDown(event);
                    break;
                }
                case 35: {
                    this.onMenuDetect(event);
                    break;
                }
                case 8: {
                    this.onMouseDoubleClick(event);
                    break;
                }
                case 3: {
                    this.onMouse(event);
                    break;
                }
                case 6: {
                    this.onMouse(event);
                    break;
                }
                case 7: {
                    this.onMouse(event);
                    break;
                }
                case 32: {
                    this.onMouse(event);
                    break;
                }
                case 5: {
                    this.onMouse(event);
                    break;
                }
                case 4: {
                    this.onMouse(event);
                    break;
                }
                case 9: {
                    this.onPaint(event);
                    break;
                }
                case 11: {
                    this.onResize(event);
                    break;
                }
                case 31: {
                    this.onTraverse(event);
                    break;
                }
                case 13: {
                    this.onSelection(event);
                    break;
                }
                case 26: {
                    this.onActivate(event);
                    break;
                }
                case 27: {
                    this.onDeactivate(event);
                }
            }
        };
        int[] folderEvents = new int[]{12, 29, 15, 16, 1, 35, 8, 3, 6, 7, 32, 5, 4, 9, 11, 31, 26, 27};
        int i2 = 0;
        while (i2 < folderEvents.length) {
            this.addListener(folderEvents[i2], this.listener);
            ++i2;
        }
        this.initAccessible();
    }

    void onDeactivate(Event event) {
        if (!this.highlightEnabled) {
            return;
        }
        this.highlight = false;
        this.redraw();
    }

    void onActivate(Event event) {
        if (!this.highlightEnabled) {
            return;
        }
        this.highlight = true;
        this.redraw();
    }

    static int checkStyle(Composite parent, int style) {
        int mask = 109053126;
        if (((style &= mask) & 0x80) != 0) {
            style &= 0xFFFFFBFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFFFFFFB;
        }
        if (((style |= 0x100000) & 0x4000000) != 0) {
            return style;
        }
        if ((parent.getStyle() & 0x8000000) != 0 && (style & 0x2000000) == 0) {
            return style;
        }
        return style | 0x20000000;
    }

    public void addCTabFolder2Listener(CTabFolder2Listener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        CTabFolder2Listener[] newListeners = new CTabFolder2Listener[this.folderListeners.length + 1];
        System.arraycopy(this.folderListeners, 0, newListeners, 0, this.folderListeners.length);
        this.folderListeners = newListeners;
        this.folderListeners[this.folderListeners.length - 1] = listener2;
    }

    @Deprecated
    public void addCTabFolderListener(CTabFolderListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        CTabFolderListener[] newTabListeners = new CTabFolderListener[this.tabListeners.length + 1];
        System.arraycopy(this.tabListeners, 0, newTabListeners, 0, this.tabListeners.length);
        this.tabListeners = newTabListeners;
        this.tabListeners[this.tabListeners.length - 1] = listener2;
        if (!this.showClose) {
            this.showClose = true;
            this.updateFolder(2);
        }
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    Rectangle[] computeControlBounds(Point size, boolean[][] position) {
        Point ctrlSize;
        int alignment;
        int i2;
        if (this.controls == null || this.controls.length == 0) {
            return new Rectangle[0];
        }
        Rectangle[] rects = new Rectangle[this.controls.length];
        int i3 = 0;
        while (i3 < rects.length) {
            rects[i3] = new Rectangle(0, 0, 0, 0);
            ++i3;
        }
        Rectangle trim = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int borderRight = trim.width + trim.x;
        int borderLeft = -trim.x;
        int borderBottom = trim.height + trim.y;
        int borderTop = -trim.y;
        Point[] tabControlSize = new Point[this.controls.length];
        boolean[] overflow = new boolean[this.controls.length];
        int leftWidth = 0;
        int x = borderLeft + 3;
        int rightWidth = 0;
        int allWidth = 0;
        int i4 = 0;
        while (i4 < this.controls.length) {
            tabControlSize[i4] = !this.controls[i4].isDisposed() && this.controls[i4].getVisible() ? this.controls[i4].computeSize(-1, -1) : new Point(0, 0);
            Point ctrlSize2 = tabControlSize[i4];
            int alignment2 = this.controlAlignments[i4];
            if ((alignment2 & 0x4000) != 0) {
                rects[i4].width = ctrlSize2.x;
                rects[i4].height = this.getControlHeight(ctrlSize2);
                rects[i4].x = x;
                rects[i4].y = this.getControlY(size, rects, borderBottom, borderTop, i4);
                x += ctrlSize2.x;
                leftWidth += ctrlSize2.x;
            } else {
                if ((alignment2 & 0x44) == 0) {
                    rightWidth += ctrlSize2.x;
                }
                allWidth += ctrlSize2.x;
            }
            ++i4;
        }
        if (leftWidth > 0) {
            leftWidth += 6;
        }
        int itemWidth = 0;
        int i5 = 0;
        while (i5 < this.items.length) {
            if (this.items[i5].showing) {
                itemWidth += this.items[i5].width;
            }
            ++i5;
        }
        int maxWidth = size.x - borderLeft - leftWidth - borderRight;
        int availableWidth = Math.max(0, maxWidth - itemWidth - rightWidth);
        if (rightWidth > 0) {
            availableWidth -= 6;
        }
        x = size.x - borderRight - 3;
        if (itemWidth + allWidth <= maxWidth) {
            i2 = 0;
            while (i2 < this.controls.length) {
                alignment = this.controlAlignments[i2];
                if ((alignment & 0x20000) != 0) {
                    ctrlSize = tabControlSize[i2];
                    rects[i2].width = ctrlSize.x;
                    rects[i2].height = this.getControlHeight(ctrlSize);
                    rects[i2].x = x -= ctrlSize.x;
                    rects[i2].y = this.getControlY(size, rects, borderBottom, borderTop, i2);
                    if ((alignment & 0x44) != 0) {
                        availableWidth -= ctrlSize.x;
                    }
                }
                if (tabControlSize[i2].y >= this.tabHeight && this.fixedTabHeight == -1) {
                    overflow[i2] = true;
                }
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < this.controls.length) {
                alignment = this.controlAlignments[i2];
                ctrlSize = tabControlSize[i2];
                if ((alignment & 0x20000) != 0) {
                    if ((alignment & 0x44) == 0) {
                        rects[i2].width = ctrlSize.x;
                        rects[i2].height = this.getControlHeight(ctrlSize);
                        rects[i2].x = x -= ctrlSize.x;
                        rects[i2].y = this.getControlY(size, rects, borderBottom, borderTop, i2);
                    } else if ((alignment & 0x40) != 0 && ctrlSize.x < availableWidth) {
                        rects[i2].width = ctrlSize.x;
                        rects[i2].height = this.getControlHeight(ctrlSize);
                        rects[i2].x = x -= ctrlSize.x;
                        rects[i2].y = this.getControlY(size, rects, borderBottom, borderTop, i2);
                        availableWidth -= ctrlSize.x;
                    } else if ((alignment & 4) != 0 && (alignment & 0x40) == 0) {
                        rects[i2].width = 0;
                        rects[i2].height = this.getControlHeight(ctrlSize);
                        rects[i2].x = x;
                        rects[i2].y = this.getControlY(size, rects, borderBottom, borderTop, i2);
                    } else if ((alignment & 0x40) != 0) {
                        overflow[i2] = true;
                    }
                }
                ++i2;
            }
        }
        if (availableWidth > 0) {
            int fillCount = 0;
            int i6 = 0;
            while (i6 < this.controls.length) {
                int alignment3 = this.controlAlignments[i6];
                if ((alignment3 & 0x20000) != 0 && (alignment3 & 4) != 0 && !overflow[i6]) {
                    ++fillCount;
                }
                ++i6;
            }
            if (fillCount != 0) {
                int extraSpace = availableWidth / fillCount;
                int addedSpace = 0;
                int i7 = 0;
                while (i7 < this.controls.length) {
                    int alignment4 = this.controlAlignments[i7];
                    if ((alignment4 & 0x20000) != 0) {
                        if ((alignment4 & 4) != 0 && !overflow[i7]) {
                            rects[i7].width += extraSpace;
                            addedSpace += extraSpace;
                        }
                        if (!overflow[i7]) {
                            rects[i7].x -= addedSpace;
                        }
                    }
                    ++i7;
                }
            }
        }
        Rectangle bodyTrim = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
        int bodyRight = bodyTrim.width + bodyTrim.x;
        int bodyLeft = -bodyTrim.x;
        int bodyWidth = size.x - bodyLeft - bodyRight;
        x = size.x - bodyRight;
        int y = this.onBottom ? this.getSize().y - this.getTabHeight() + 2 * bodyTrim.y : -bodyTrim.y;
        availableWidth = bodyWidth;
        int maxHeight = 0;
        int i8 = 0;
        while (i8 < this.controls.length) {
            Point ctrlSize3 = tabControlSize[i8];
            if (overflow[i8]) {
                if (availableWidth > ctrlSize3.x) {
                    rects[i8].width = ctrlSize3.x;
                    rects[i8].y = this.onBottom ? y - ctrlSize3.y : y;
                    rects[i8].height = ctrlSize3.y;
                    rects[i8].x = x -= ctrlSize3.x;
                    availableWidth -= ctrlSize3.x;
                    maxHeight = Math.max(maxHeight, ctrlSize3.y);
                } else {
                    x = size.x - bodyRight;
                    y += maxHeight;
                    maxHeight = 0;
                    availableWidth = bodyWidth;
                    if (availableWidth > ctrlSize3.x) {
                        --i8;
                    } else {
                        ctrlSize3 = this.controls[i8].isDisposed() ? new Point(0, 0) : this.controls[i8].computeSize(bodyWidth, -1);
                        rects[i8].width = bodyWidth;
                        rects[i8].y = this.onBottom ? y - ctrlSize3.y : y;
                        rects[i8].height = ctrlSize3.y;
                        rects[i8].x = size.x - ctrlSize3.x - bodyRight;
                        y += ctrlSize3.y;
                    }
                }
            }
            ++i8;
        }
        if (this.showChevron) {
            i8 = 0;
            int lastIndex = -1;
            while (i8 < this.priority.length && this.items[this.priority[i8]].showing) {
                lastIndex = Math.max(lastIndex, this.priority[i8++]);
            }
            if (lastIndex == -1) {
                lastIndex = this.selectedIndex;
            }
            if (lastIndex != -1) {
                CTabItem lastItem = this.items[lastIndex];
                int w = lastItem.x + lastItem.width + 3;
                if (!this.simple && lastIndex == this.selectedIndex) {
                    w -= this.renderer.curveIndent - 7;
                }
                rects[this.controls.length - 1].x = w;
            }
        }
        if (position != null) {
            position[0] = overflow;
        }
        return rects;
    }

    int getControlHeight(Point ctrlSize) {
        return this.fixedTabHeight == -1 ? Math.max(this.tabHeight - 1, ctrlSize.y) : ctrlSize.y;
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = this.renderer.computeTrim(-1, 0, x, y, width, height);
        Point size = new Point(width, height);
        int wrapHeight = this.getWrappedHeight(size);
        if (this.onBottom) {
            trim.height += wrapHeight;
        } else {
            trim.y -= wrapHeight;
            trim.height += wrapHeight;
        }
        return trim;
    }

    Image createButtonImage(Display display, int button2) {
        GC tempGC = new GC(this);
        Point size = this.renderer.computeSize(button2, 0, tempGC, -1, -1);
        tempGC.dispose();
        Rectangle trim = this.renderer.computeTrim(button2, 0, 0, 0, 0, 0);
        Image image = new Image((Device)display, size.x - trim.width, size.y - trim.height);
        GC gc = new GC(image);
        Color transColor = this.renderer.parent.getBackground();
        gc.setBackground(transColor);
        gc.fillRectangle(image.getBounds());
        this.renderer.draw(button2, 0, new Rectangle(trim.x, trim.y, size.x, size.y), gc);
        gc.dispose();
        ImageData imageData = image.getImageData(DPIUtil.getDeviceZoom());
        imageData.transparentPixel = imageData.palette.getPixel(transColor.getRGB());
        image.dispose();
        image = new Image((Device)display, new DPIUtil.AutoScaleImageDataProvider(display, imageData, DPIUtil.getDeviceZoom()));
        return image;
    }

    void createItem(CTabItem item2, int index) {
        if (index < 0 || index > this.getItemCount()) {
            SWT.error(6);
        }
        item2.parent = this;
        CTabItem[] newItems = new CTabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = item2;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        if (this.selectedIndex >= index) {
            ++this.selectedIndex;
        }
        int[] newPriority = new int[this.priority.length + 1];
        int next = 0;
        int priorityIndex = this.priority.length;
        int i2 = 0;
        while (i2 < this.priority.length) {
            if (!this.mru && this.priority[i2] == index) {
                priorityIndex = next++;
            }
            newPriority[next++] = this.priority[i2] >= index ? this.priority[i2] + 1 : this.priority[i2];
            ++i2;
        }
        newPriority[priorityIndex] = index;
        this.priority = newPriority;
        if (this.items.length == 1) {
            this.updateFolder(10);
        } else {
            this.updateFolder(4);
        }
    }

    void destroyItem(CTabItem item2) {
        if (this.inDispose) {
            return;
        }
        int index = this.indexOf(item2);
        if (index == -1) {
            return;
        }
        if (this.items.length == 1) {
            this.items = new CTabItem[0];
            this.priority = new int[0];
            this.firstIndex = -1;
            this.selectedIndex = -1;
            Control control = item2.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            this.setToolTipText(null);
            GC gc = new GC(this);
            this.setButtonBounds(gc);
            gc.dispose();
            this.redraw();
            return;
        }
        CTabItem[] newItems = new CTabItem[this.items.length - 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
        this.items = newItems;
        int[] newPriority = new int[this.priority.length - 1];
        int next = 0;
        int i2 = 0;
        while (i2 < this.priority.length) {
            if (this.priority[i2] != index) {
                newPriority[next++] = this.priority[i2] > index ? this.priority[i2] - 1 : this.priority[i2];
            }
            ++i2;
        }
        this.priority = newPriority;
        if (this.selectedIndex == index) {
            Control control = item2.getControl();
            this.selectedIndex = -1;
            int nextSelection = this.mru ? this.priority[0] : Math.max(0, index - 1);
            this.setSelection(nextSelection, true);
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        } else if (this.selectedIndex > index) {
            --this.selectedIndex;
        }
        this.requestLayout();
        this.updateFolder(12);
    }

    public boolean getBorderVisible() {
        this.checkWidget();
        return this.borderVisible;
    }

    ToolBar getChevron() {
        if (this.chevronTb == null) {
            this.chevronTb = new ToolBar(this, 0x800000);
            this.initAccessibleChevronTb();
            this.addTabControl(this.chevronTb, 131072, -1, false);
        }
        if (this.chevronItem == null) {
            this.chevronItem = new ToolItem(this.chevronTb, 8);
            this.chevronItem.setToolTipText(SWT.getMessage("SWT_ShowList"));
            this.chevronItem.addListener(13, this.listener);
        }
        return this.chevronTb;
    }

    boolean getChevronVisible() {
        this.checkWidget();
        return this.chevronVisible;
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle trim = this.renderer.computeTrim(-1, 4, 0, 0, 0, 0);
        Point size = this.getSize();
        int wrapHeight = this.getWrappedHeight(size);
        if (this.onBottom) {
            trim.height += wrapHeight;
        } else {
            trim.y -= wrapHeight;
            trim.height += wrapHeight;
        }
        if (this.minimized) {
            return new Rectangle(-trim.x, -trim.y, 0, 0);
        }
        int width = size.x - trim.width;
        int height = size.y - trim.height;
        return new Rectangle(-trim.x, -trim.y, width, height);
    }

    public CTabItem getItem(int index) {
        if (index < 0 || index >= this.items.length) {
            SWT.error(6);
        }
        return this.items[index];
    }

    public CTabItem getItem(Point pt) {
        if (this.items.length == 0) {
            return null;
        }
        this.runUpdate();
        Point size = this.getSize();
        Rectangle trim = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        if (size.x <= trim.width) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.priority.length) {
            CTabItem item2 = this.items[this.priority[i2]];
            Rectangle rect = item2.getBounds();
            if (rect.contains(pt)) {
                return item2;
            }
            ++i2;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem[] getItems() {
        CTabItem[] tabItems = new CTabItem[this.items.length];
        System.arraycopy(this.items, 0, tabItems, 0, this.items.length);
        return tabItems;
    }

    int getLeftItemEdge(GC gc, int part) {
        Rectangle trim = this.renderer.computeTrim(part, 0, 0, 0, 0, 0);
        int x = -trim.x;
        int width = 0;
        int i2 = 0;
        while (i2 < this.controls.length) {
            if ((this.controlAlignments[i2] & 0x4000) != 0 && !this.controls[i2].isDisposed() && this.controls[i2].getVisible()) {
                width += this.controls[i2].computeSize((int)-1, (int)-1).x;
            }
            ++i2;
        }
        if (width != 0) {
            width += 6;
        }
        return Math.max(0, x += width);
    }

    char _findMnemonic(String string2) {
        if (string2 == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string2.length();
        while (true) {
            if (index < length && string2.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string2.charAt(index) != '&') {
                return Character.toLowerCase(string2.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    String stripMnemonic(String string2) {
        int index = 0;
        int length = string2.length();
        while (true) {
            if (index < length && string2.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string2;
            }
            if (string2.charAt(index) != '&') {
                return String.valueOf(string2.substring(0, index - 1)) + string2.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string2;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    public boolean getMinimizeVisible() {
        this.checkWidget();
        return this.showMin;
    }

    public int getMinimumCharacters() {
        this.checkWidget();
        return this.minChars;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public boolean getMaximizeVisible() {
        this.checkWidget();
        return this.showMax;
    }

    public boolean getMRUVisible() {
        this.checkWidget();
        return this.mru;
    }

    public CTabFolderRenderer getRenderer() {
        this.checkWidget();
        return this.renderer;
    }

    int getRightItemEdge(GC gc) {
        Rectangle trim = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int x = this.getSize().x - (trim.width + trim.x);
        int width = 0;
        int i2 = 0;
        while (i2 < this.controls.length) {
            int align = this.controlAlignments[i2];
            if ((align & 0x40) == 0 && (align & 0x4000) == 0 && !this.controls[i2].isDisposed() && this.controls[i2].getVisible()) {
                Point rightSize = this.controls[i2].computeSize(-1, -1);
                width += rightSize.x;
            }
            ++i2;
        }
        if (width != 0) {
            width += 6;
        }
        return Math.max(0, x -= width);
    }

    public CTabItem getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        return this.selectionForeground;
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    public boolean getSingle() {
        this.checkWidget();
        return this.single;
    }

    @Override
    public int getStyle() {
        int style = super.getStyle();
        style &= 0xFFFFFB7F;
        style |= this.onBottom ? 1024 : 128;
        style &= 0xFFFFFFF9;
        style |= this.single ? 4 : 2;
        if (this.borderVisible) {
            style |= 0x800;
        }
        style &= 0xFFFFFFBF;
        if (this.showClose) {
            style |= 0x40;
        }
        return style;
    }

    public int getTabHeight() {
        this.checkWidget();
        if (this.fixedTabHeight != -1) {
            return this.fixedTabHeight;
        }
        return this.tabHeight - 1;
    }

    public int getTabPosition() {
        this.checkWidget();
        return this.onBottom ? 1024 : 128;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public int getTopRightAlignment() {
        this.checkWidget();
        return this.topRightAlignment;
    }

    public boolean getUnselectedCloseVisible() {
        this.checkWidget();
        return this.showUnselectedClose;
    }

    public boolean getUnselectedImageVisible() {
        this.checkWidget();
        return this.showUnselectedImage;
    }

    public int indexOf(CTabItem item2) {
        this.checkWidget();
        if (item2 == null) {
            SWT.error(4);
        }
        int i2 = 0;
        while (i2 < this.items.length) {
            if (this.items[i2] == item2) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent e) {
                Item item2 = null;
                int childID = e.childID;
                if (childID == -1) {
                    if (CTabFolder.this.selectedIndex != -1) {
                        item2 = CTabFolder.this.items[CTabFolder.this.selectedIndex];
                    }
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    item2 = CTabFolder.this.items[childID];
                }
                e.result = item2 == null ? null : CTabFolder.this.stripMnemonic(item2.getText());
            }

            @Override
            public void getHelp(AccessibleEvent e) {
                String help = null;
                int childID = e.childID;
                if (childID == -1) {
                    help = CTabFolder.this.getToolTipText();
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    help = CTabFolder.this.items[childID].getToolTipText();
                }
                e.result = help;
            }

            @Override
            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text2;
                String shortcut2 = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length && (text2 = CTabFolder.this.items[childID].getText()) != null && (mnemonic = CTabFolder.this._findMnemonic(text2)) != '\u0000') {
                    shortcut2 = SWT.getMessage("SWT_Page_Mnemonic", new Object[]{Character.valueOf(mnemonic)});
                }
                if (childID == -1) {
                    shortcut2 = SWT.getMessage("SWT_SwitchPage_Shortcut");
                }
                e.result = shortcut2;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = CTabFolder.this.toControl(e.x, e.y);
                int childID = -2;
                int i2 = 0;
                while (i2 < CTabFolder.this.items.length) {
                    if (CTabFolder.this.items[i2].getBounds().contains(testPoint)) {
                        childID = i2;
                        break;
                    }
                    ++i2;
                }
                if (childID == -2) {
                    Rectangle location = CTabFolder.this.getBounds();
                    location.y = 0;
                    location.x = 0;
                    location.height -= CTabFolder.this.getClientArea().height;
                    if (location.contains(testPoint)) {
                        childID = -1;
                    }
                }
                e.childID = childID;
            }

            @Override
            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = null;
                Point pt = null;
                int childID = e.childID;
                if (childID == -1) {
                    location = CTabFolder.this.getBounds();
                    pt = CTabFolder.this.getParent().toDisplay(location.x, location.y);
                } else {
                    if (childID >= 0 && childID < CTabFolder.this.items.length && CTabFolder.this.items[childID].showing) {
                        location = CTabFolder.this.items[childID].getBounds();
                    }
                    if (location != null) {
                        pt = CTabFolder.this.toDisplay(location.x, location.y);
                    }
                }
                if (location != null && pt != null) {
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            @Override
            public void getChildCount(AccessibleControlEvent e) {
                e.detail = CTabFolder.this.items.length;
            }

            @Override
            public void getDefaultAction(AccessibleControlEvent e) {
                String action2 = null;
                int childID = e.childID;
                if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    action2 = SWT.getMessage("SWT_Switch");
                }
                e.result = action2;
            }

            @Override
            public void getFocus(AccessibleControlEvent e) {
                int childID = -2;
                if (CTabFolder.this.isFocusControl()) {
                    childID = CTabFolder.this.selectedIndex == -1 ? -1 : CTabFolder.this.selectedIndex;
                }
                e.childID = childID;
            }

            @Override
            public void getRole(AccessibleControlEvent e) {
                int role = 0;
                int childID = e.childID;
                if (childID == -1) {
                    role = 60;
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    role = 37;
                }
                e.detail = role;
            }

            @Override
            public void getSelection(AccessibleControlEvent e) {
                e.childID = CTabFolder.this.selectedIndex == -1 ? -2 : CTabFolder.this.selectedIndex;
            }

            @Override
            public void getState(AccessibleControlEvent e) {
                int state = 0;
                int childID = e.childID;
                if (childID == -1) {
                    state = 0;
                } else if (childID >= 0 && childID < CTabFolder.this.items.length) {
                    state = 0x200000;
                    if (CTabFolder.this.isFocusControl()) {
                        state |= 0x100000;
                    }
                    if (CTabFolder.this.selectedIndex == childID) {
                        state |= 2;
                        if (CTabFolder.this.isFocusControl()) {
                            state |= 4;
                        }
                    }
                }
                e.detail = state;
            }

            @Override
            public void getChildren(AccessibleControlEvent e) {
                int childIdCount = CTabFolder.this.items.length;
                Object[] children = new Object[childIdCount];
                int i2 = 0;
                while (i2 < childIdCount) {
                    children[i2] = i2;
                    ++i2;
                }
                e.children = children;
            }
        });
        this.addListener(13, event -> {
            if (this.isFocusControl()) {
                if (this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(this.selectedIndex);
                }
            }
        });
        this.addListener(15, event -> {
            if (this.selectedIndex == -1) {
                accessible.setFocus(-1);
            } else {
                accessible.setFocus(this.selectedIndex);
            }
        });
    }

    void initAccessibleMinMaxTb() {
        this.minMaxTb.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    if (CTabFolder.this.minItem != null && e.childID == CTabFolder.this.minMaxTb.indexOf(CTabFolder.this.minItem)) {
                        e.result = CTabFolder.this.minItem.getToolTipText();
                    } else if (CTabFolder.this.maxItem != null && e.childID == CTabFolder.this.minMaxTb.indexOf(CTabFolder.this.maxItem)) {
                        e.result = CTabFolder.this.maxItem.getToolTipText();
                    }
                }
            }
        });
    }

    void initAccessibleChevronTb() {
        this.chevronTb.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent e) {
                if (e.childID != -1 && CTabFolder.this.chevronItem != null && e.childID == CTabFolder.this.chevronTb.indexOf(CTabFolder.this.chevronItem)) {
                    e.result = CTabFolder.this.chevronItem.getToolTipText();
                }
            }
        });
    }

    void onKeyDown(Event event) {
        this.runUpdate();
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                int index;
                int offset;
                int count = this.items.length;
                if (count == 0) {
                    return;
                }
                if (this.selectedIndex == -1) {
                    return;
                }
                int leadKey = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                int n = offset = event.keyCode == leadKey ? -1 : 1;
                if (!this.mru) {
                    index = this.selectedIndex + offset;
                } else {
                    int[] visible = new int[this.items.length];
                    int idx = 0;
                    int current = -1;
                    int i2 = 0;
                    while (i2 < this.items.length) {
                        if (this.items[i2].showing) {
                            if (i2 == this.selectedIndex) {
                                current = idx;
                            }
                            visible[idx++] = i2;
                        }
                        ++i2;
                    }
                    if (current + offset >= 0 && current + offset < idx) {
                        index = visible[current + offset];
                    } else {
                        if (this.showChevron) {
                            Rectangle chevronRect = this.chevronItem.getBounds();
                            chevronRect = event.display.map((Control)this.chevronTb, (Control)this, chevronRect);
                            CTabFolderEvent e = new CTabFolderEvent(this);
                            e.widget = this;
                            e.time = event.time;
                            e.x = chevronRect.x;
                            e.y = chevronRect.y;
                            e.width = chevronRect.width;
                            e.height = chevronRect.height;
                            e.doit = true;
                            int i3 = 0;
                            while (i3 < this.folderListeners.length) {
                                this.folderListeners[i3].showList(e);
                                ++i3;
                            }
                            if (e.doit && !this.isDisposed()) {
                                this.showList(chevronRect);
                            }
                        }
                        return;
                    }
                }
                if (index < 0 || index >= count) {
                    return;
                }
                this.setSelection(index, true);
                this.forceFocus();
            }
        }
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        if (this.showMenu != null && !this.showMenu.isDisposed()) {
            this.showMenu.dispose();
            this.showMenu = null;
        }
        int length = this.items.length;
        int i2 = 0;
        while (i2 < length) {
            if (this.items[i2] != null) {
                this.items[i2].dispose();
            }
            ++i2;
        }
        this.gradientColors = null;
        this.selectionGradientColors = null;
        this.selectionGradientPercents = null;
        this.selectionBgImage = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        if (this.controlBkImages != null) {
            i2 = 0;
            while (i2 < this.controlBkImages.length) {
                if (this.controlBkImages[i2] != null) {
                    this.controlBkImages[i2].dispose();
                    this.controlBkImages[i2] = null;
                }
                ++i2;
            }
            this.controlBkImages = null;
        }
        this.controls = null;
        this.controlAlignments = null;
        this.controlRects = null;
        if (this.maxImage != null) {
            this.maxImage.dispose();
        }
        this.maxImage = null;
        if (this.minImage != null) {
            this.minImage.dispose();
        }
        this.minImage = null;
        if (this.chevronImage != null) {
            this.chevronImage.dispose();
        }
        this.chevronImage = null;
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.renderer = null;
        this.minItem = null;
        this.maxItem = null;
        this.minMaxTb = null;
        this.chevronItem = null;
        this.chevronTb = null;
        if (this.folderListeners.length != 0) {
            this.folderListeners = new CTabFolder2Listener[0];
        }
        if (this.tabListeners.length != 0) {
            this.tabListeners = new CTabFolderListener[0];
        }
    }

    void onDragDetect(Event event) {
        boolean consume2 = false;
        int i2 = 0;
        while (i2 < this.items.length) {
            if (this.items[i2].closeRect.contains(event.x, event.y)) {
                consume2 = true;
                break;
            }
            ++i2;
        }
        if (consume2) {
            event.type = 0;
        }
    }

    void onFocus(Event event) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redraw();
        } else {
            this.setSelection(0, true);
        }
    }

    boolean onMnemonic(Event event, boolean doit) {
        char key2 = event.character;
        int i2 = 0;
        while (i2 < this.items.length) {
            char mnemonic;
            if (this.items[i2] != null && (mnemonic = this._findMnemonic(this.items[i2].getText())) != '\u0000' && Character.toLowerCase(key2) == mnemonic) {
                if (doit) {
                    this.setSelection(i2, true);
                    this.forceFocus();
                }
                return true;
            }
            ++i2;
        }
        return false;
    }

    void onMenuDetect(Event event) {
        if (event.detail == 1 && this.selectedIndex != -1) {
            CTabItem item2 = this.items[this.selectedIndex];
            Rectangle rect = this.getDisplay().map((Control)this, null, item2.getBounds());
            if (!rect.contains(event.x, event.y)) {
                Rectangle itemTrim = this.renderer.computeTrim(this.selectedIndex, 0, 0, 0, 0, 0);
                Rectangle closeTrim = this.renderer.computeTrim(-8, 0, 0, 0, 0, 0);
                event.x = rect.x + rect.width - item2.closeRect.width + itemTrim.x - closeTrim.width;
                event.y = rect.y - itemTrim.y - closeTrim.y;
            }
        }
    }

    void onMouseDoubleClick(Event event) {
        if (event.button != 1 || (event.stateMask & 0x100000) != 0 || (event.stateMask & 0x200000) != 0) {
            return;
        }
        Event e = new Event();
        e.item = this.getItem(new Point(event.x, event.y));
        if (e.item != null) {
            this.notifyListeners(14, e);
        }
    }

    void onMouse(Event event) {
        if (this.isDisposed()) {
            return;
        }
        int x = event.x;
        int y = event.y;
        switch (event.type) {
            case 6: {
                this.setToolTipText(null);
                break;
            }
            case 7: {
                int i2 = 0;
                while (i2 < this.items.length) {
                    CTabItem item2 = this.items[i2];
                    if (i2 != this.selectedIndex && item2.closeImageState != 8) {
                        item2.closeImageState = 8;
                        this.redraw(item2.closeRect.x, item2.closeRect.y, item2.closeRect.width, item2.closeRect.height, false);
                    }
                    if ((item2.state & 0x20) != 0) {
                        item2.state &= 0xFFFFFFDF;
                        this.redraw(item2.x, item2.y, item2.width, item2.height, false);
                    }
                    if (i2 == this.selectedIndex && item2.closeImageState != 0) {
                        item2.closeImageState = 0;
                        this.redraw(item2.closeRect.x, item2.closeRect.y, item2.closeRect.width, item2.closeRect.height, false);
                    }
                    ++i2;
                }
                break;
            }
            case 3: 
            case 32: {
                if (this.hoverTb && this.hoverRect.contains(x, y) && !this.hovering) {
                    this.hovering = true;
                    this.updateItems();
                    this.hoverTimerRunning = true;
                    event.display.timerExec(2000, new Runnable(){

                        @Override
                        public void run() {
                            if (CTabFolder.this.isDisposed()) {
                                return;
                            }
                            if (CTabFolder.this.hovering) {
                                Display display = CTabFolder.this.getDisplay();
                                Control c = display.getCursorControl();
                                boolean reschedule = false;
                                if (c != null) {
                                    int i2 = 0;
                                    while (i2 < CTabFolder.this.controls.length) {
                                        Control temp = c;
                                        do {
                                            if (temp.equals(CTabFolder.this.controls[i2])) {
                                                reschedule = true;
                                                continue;
                                            }
                                            if ((temp = temp.getParent()) == null || temp.equals(CTabFolder.this)) break;
                                        } while (!reschedule);
                                        if (reschedule) break;
                                        ++i2;
                                    }
                                }
                                if (reschedule && CTabFolder.this.hoverTimerRunning) {
                                    display.timerExec(2000, this);
                                } else {
                                    CTabFolder.this.hovering = false;
                                    CTabFolder.this.updateItems();
                                }
                            }
                        }
                    });
                    return;
                }
                if (event.button != 1) {
                    return;
                }
                CTabItem item3 = null;
                if (this.single) {
                    Rectangle bounds;
                    if (this.selectedIndex != -1 && (bounds = this.items[this.selectedIndex].getBounds()).contains(x, y)) {
                        item3 = this.items[this.selectedIndex];
                    }
                } else {
                    int i3 = 0;
                    while (i3 < this.items.length) {
                        Rectangle bounds = this.items[i3].getBounds();
                        if (bounds.contains(x, y)) {
                            item3 = this.items[i3];
                        }
                        ++i3;
                    }
                }
                if (item3 == null) break;
                if (item3.closeRect.contains(x, y)) {
                    item3.closeImageState = 2;
                    this.redraw(item3.closeRect.x, item3.closeRect.y, item3.closeRect.width, item3.closeRect.height, false);
                    this.update();
                    return;
                }
                int index = this.indexOf(item3);
                if (item3.showing) {
                    int oldSelectedIndex = this.selectedIndex;
                    this.setSelection(index, true);
                    if (oldSelectedIndex == this.selectedIndex) {
                        this.forceFocus();
                    }
                }
                return;
            }
            case 5: {
                this._setToolTipText(event.x, event.y);
                boolean close = false;
                int i4 = 0;
                while (i4 < this.items.length) {
                    CTabItem item4 = this.items[i4];
                    close = false;
                    if (item4.getBounds().contains(x, y)) {
                        close = true;
                        if (item4.closeRect.contains(x, y)) {
                            if (item4.closeImageState != 2 && item4.closeImageState != 32) {
                                item4.closeImageState = 32;
                                this.redraw(item4.closeRect.x, item4.closeRect.y, item4.closeRect.width, item4.closeRect.height, false);
                            }
                        } else if (item4.closeImageState != 0) {
                            item4.closeImageState = 0;
                            this.redraw(item4.closeRect.x, item4.closeRect.y, item4.closeRect.width, item4.closeRect.height, false);
                        }
                        if ((item4.state & 0x20) == 0) {
                            item4.state |= 0x20;
                            this.redraw(item4.x, item4.y, item4.width, item4.height, false);
                        }
                    }
                    if (i4 != this.selectedIndex && item4.closeImageState != 8 && !close) {
                        item4.closeImageState = 8;
                        this.redraw(item4.closeRect.x, item4.closeRect.y, item4.closeRect.width, item4.closeRect.height, false);
                    }
                    if ((item4.state & 0x20) != 0 && !close) {
                        item4.state &= 0xFFFFFFDF;
                        this.redraw(item4.x, item4.y, item4.width, item4.height, false);
                    }
                    if (i4 == this.selectedIndex && item4.closeImageState != 0 && !close) {
                        item4.closeImageState = 0;
                        this.redraw(item4.closeRect.x, item4.closeRect.y, item4.closeRect.width, item4.closeRect.height, false);
                    }
                    ++i4;
                }
                break;
            }
            case 4: {
                SWTEventListener listener2;
                if (event.button != 1) {
                    return;
                }
                CTabItem item5 = null;
                if (this.single) {
                    Rectangle bounds;
                    if (this.selectedIndex != -1 && (bounds = this.items[this.selectedIndex].getBounds()).contains(x, y)) {
                        item5 = this.items[this.selectedIndex];
                    }
                } else {
                    int i5 = 0;
                    while (i5 < this.items.length) {
                        Rectangle bounds = this.items[i5].getBounds();
                        if (bounds.contains(x, y)) {
                            item5 = this.items[i5];
                        }
                        ++i5;
                    }
                }
                if (item5 == null || !item5.closeRect.contains(x, y)) break;
                boolean selected = item5.closeImageState == 2;
                item5.closeImageState = 32;
                this.redraw(item5.closeRect.x, item5.closeRect.y, item5.closeRect.width, item5.closeRect.height, false);
                if (!selected) {
                    return;
                }
                CTabFolderEvent e = new CTabFolderEvent(this);
                e.widget = this;
                e.time = event.time;
                e.item = item5;
                e.doit = true;
                int j = 0;
                while (j < this.folderListeners.length) {
                    listener2 = this.folderListeners[j];
                    listener2.close(e);
                    ++j;
                }
                j = 0;
                while (j < this.tabListeners.length) {
                    listener2 = this.tabListeners[j];
                    listener2.itemClosed(e);
                    ++j;
                }
                if (e.doit) {
                    item5.dispose();
                }
                if (!this.isDisposed() && item5.isDisposed()) {
                    Display display = this.getDisplay();
                    Point pt = display.getCursorLocation();
                    pt = display.map(null, this, pt.x, pt.y);
                    CTabItem nextItem = this.getItem(pt);
                    if (nextItem != null) {
                        if (nextItem.closeRect.contains(pt)) {
                            if (nextItem.closeImageState != 2 && nextItem.closeImageState != 32) {
                                nextItem.closeImageState = 32;
                                this.redraw(nextItem.closeRect.x, nextItem.closeRect.y, nextItem.closeRect.width, nextItem.closeRect.height, false);
                            }
                        } else if (nextItem.closeImageState != 0) {
                            nextItem.closeImageState = 0;
                            this.redraw(nextItem.closeRect.x, nextItem.closeRect.y, nextItem.closeRect.width, nextItem.closeRect.height, false);
                        }
                    }
                }
                return;
            }
        }
    }

    void onPageTraversal(Event event) {
        int count = this.items.length;
        if (count == 0) {
            return;
        }
        int index = this.selectedIndex;
        if (index == -1) {
            index = 0;
        } else {
            int offset;
            int n = offset = event.detail == 512 ? 1 : -1;
            if (!this.mru) {
                index = (this.selectedIndex + offset + count) % count;
            } else {
                int[] visible = new int[this.items.length];
                int idx = 0;
                int current = -1;
                int i2 = 0;
                while (i2 < this.items.length) {
                    if (this.items[i2].showing) {
                        if (i2 == this.selectedIndex) {
                            current = idx;
                        }
                        visible[idx++] = i2;
                    }
                    ++i2;
                }
                if (current + offset >= 0 && current + offset < idx) {
                    index = visible[current + offset];
                } else if (this.showChevron) {
                    Rectangle chevronRect = this.chevronItem.getBounds();
                    chevronRect = event.display.map((Control)this.chevronTb, (Control)this, chevronRect);
                    CTabFolderEvent e = new CTabFolderEvent(this);
                    e.widget = this;
                    e.time = event.time;
                    e.x = chevronRect.x;
                    e.y = chevronRect.y;
                    e.width = chevronRect.width;
                    e.height = chevronRect.height;
                    e.doit = true;
                    int i3 = 0;
                    while (i3 < this.folderListeners.length) {
                        this.folderListeners[i3].showList(e);
                        ++i3;
                    }
                    if (e.doit && !this.isDisposed()) {
                        this.showList(chevronRect);
                    }
                }
            }
        }
        this.setSelection(index, true);
    }

    void onPaint(Event event) {
        if (this.inDispose) {
            return;
        }
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals(font)) {
            this.oldFont = font;
            if (!this.updateTabHeight(false)) {
                this.updateItems();
                this.redraw();
                return;
            }
        }
        GC gc = event.gc;
        Font gcFont = gc.getFont();
        Color gcBackground = gc.getBackground();
        Color gcForeground = gc.getForeground();
        Point size = this.getSize();
        Rectangle bodyRect = new Rectangle(0, 0, size.x, size.y);
        this.renderer.draw(-1, 24, bodyRect, gc);
        gc.setFont(gcFont);
        gc.setForeground(gcForeground);
        gc.setBackground(gcBackground);
        this.renderer.draw(-2, 24, bodyRect, gc);
        gc.setFont(gcFont);
        gc.setForeground(gcForeground);
        gc.setBackground(gcBackground);
        if (!this.single) {
            int i2 = 0;
            while (i2 < this.items.length) {
                Rectangle itemBounds = this.items[i2].getBounds();
                if (i2 != this.selectedIndex && event.getBounds().intersects(itemBounds)) {
                    this.renderer.draw(i2, 0x18 | this.items[i2].state, itemBounds, gc);
                }
                ++i2;
            }
        }
        gc.setFont(gcFont);
        gc.setForeground(gcForeground);
        gc.setBackground(gcBackground);
        if (this.selectedIndex != -1) {
            this.renderer.draw(this.selectedIndex, this.items[this.selectedIndex].state | 8 | 0x10, this.items[this.selectedIndex].getBounds(), gc);
        }
        gc.setFont(gcFont);
        gc.setForeground(gcForeground);
        gc.setBackground(gcBackground);
        if (this.hoverTb) {
            Rectangle trim = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
            int x = this.getSize().x - (trim.width + trim.x);
            this.hoverRect = new Rectangle(x - 16 - 3, 2, 16, this.getTabHeight() - 2);
            gc.setForeground(gc.getDevice().getSystemColor(18));
            x = this.hoverRect.x;
            int y = this.hoverRect.y;
            gc.setBackground(gc.getDevice().getSystemColor(1));
            gc.fillRectangle(x + this.hoverRect.width - 6, y, 5, 5);
            gc.drawRectangle(x + this.hoverRect.width - 6, y, 5, 5);
            gc.drawLine(x + this.hoverRect.width - 6, y + 2, x + this.hoverRect.width - 6 + 5, y + 2);
            gc.fillRectangle(x, y, 5, 2);
            gc.drawRectangle(x, y, 5, 2);
        }
        gc.setFont(gcFont);
        gc.setForeground(gcForeground);
        gc.setBackground(gcBackground);
    }

    void onResize(Event event) {
        if (this.inDispose) {
            return;
        }
        if (this.ignoreResize) {
            return;
        }
        if (this.updateItems()) {
            this.redrawTabs();
        }
        Point size = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && size.y != this.oldSize.y) {
            this.redraw();
        } else {
            int x1 = Math.min(size.x, this.oldSize.x);
            Rectangle trim = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
            if (size.x != this.oldSize.x) {
                x1 -= trim.width + trim.x - this.marginWidth + 2;
            }
            if (!this.simple) {
                x1 -= 5;
            }
            int y1 = Math.min(size.y, this.oldSize.y);
            if (size.y != this.oldSize.y) {
                y1 -= trim.height + trim.y - this.marginHeight;
            }
            int x2 = Math.max(size.x, this.oldSize.x);
            int y2 = Math.max(size.y, this.oldSize.y);
            this.redraw(0, y1, x2, y2 - y1, false);
            this.redraw(x1, 0, x2 - x1, y2, false);
            if (this.hoverTb) {
                this.redraw(this.hoverRect.x, this.hoverRect.y, this.hoverRect.width, this.hoverRect.height, false);
            }
        }
        this.oldSize = size;
    }

    void onSelection(Event event) {
        if (this.hovering) {
            this.hovering = false;
            this.updateItems();
        }
        if (event.widget == this.maxItem) {
            CTabFolderEvent e = new CTabFolderEvent(this);
            e.widget = this;
            e.time = event.time;
            int i2 = 0;
            while (i2 < this.folderListeners.length) {
                if (this.maximized) {
                    this.folderListeners[i2].restore(e);
                } else {
                    this.folderListeners[i2].maximize(e);
                }
                ++i2;
            }
        } else if (event.widget == this.minItem) {
            CTabFolderEvent e = new CTabFolderEvent(this);
            e.widget = this;
            e.time = event.time;
            int i3 = 0;
            while (i3 < this.folderListeners.length) {
                if (this.minimized) {
                    this.folderListeners[i3].restore(e);
                } else {
                    this.folderListeners[i3].minimize(e);
                }
                ++i3;
            }
        } else if (event.widget == this.chevronItem) {
            Rectangle chevronRect = this.chevronItem.getBounds();
            chevronRect = event.display.map((Control)this.chevronTb, (Control)this, chevronRect);
            CTabFolderEvent e = new CTabFolderEvent(this);
            e.widget = this;
            e.time = event.time;
            e.x = chevronRect.x;
            e.y = chevronRect.y;
            e.width = chevronRect.width;
            e.height = chevronRect.height;
            e.doit = true;
            int i4 = 0;
            while (i4 < this.folderListeners.length) {
                this.folderListeners[i4].showList(e);
                ++i4;
            }
            if (e.doit && !this.isDisposed()) {
                this.showList(chevronRect);
            }
        }
    }

    void onTraverse(Event event) {
        if (this.ignoreTraverse) {
            return;
        }
        this.runUpdate();
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl != this) break;
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event, false);
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.items.length > 0;
            }
        }
        this.ignoreTraverse = true;
        this.notifyListeners(31, event);
        this.ignoreTraverse = false;
        event.type = 0;
        if (this.isDisposed()) {
            return;
        }
        if (!event.doit) {
            return;
        }
        switch (event.detail) {
            case 128: {
                this.onMnemonic(event, true);
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                this.onPageTraversal(event);
                event.detail = 0;
            }
        }
    }

    void redrawTabs() {
        Point size = this.getSize();
        Rectangle trim = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
        if (this.onBottom) {
            int h = trim.height + trim.y - this.marginHeight;
            this.redraw(0, size.y - h - 1, size.x, h + 1, false);
        } else {
            this.redraw(0, 0, size.x, -trim.y - this.marginHeight + 1, false);
        }
    }

    public void removeCTabFolder2Listener(CTabFolder2Listener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        if (this.folderListeners.length == 0) {
            return;
        }
        int index = -1;
        int i2 = 0;
        while (i2 < this.folderListeners.length) {
            if (listener2 == this.folderListeners[i2]) {
                index = i2;
                break;
            }
            ++i2;
        }
        if (index == -1) {
            return;
        }
        if (this.folderListeners.length == 1) {
            this.folderListeners = new CTabFolder2Listener[0];
            return;
        }
        CTabFolder2Listener[] newTabListeners = new CTabFolder2Listener[this.folderListeners.length - 1];
        System.arraycopy(this.folderListeners, 0, newTabListeners, 0, index);
        System.arraycopy(this.folderListeners, index + 1, newTabListeners, index, this.folderListeners.length - index - 1);
        this.folderListeners = newTabListeners;
    }

    @Deprecated
    public void removeCTabFolderListener(CTabFolderListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        if (this.tabListeners.length == 0) {
            return;
        }
        int index = -1;
        int i2 = 0;
        while (i2 < this.tabListeners.length) {
            if (listener2 == this.tabListeners[i2]) {
                index = i2;
                break;
            }
            ++i2;
        }
        if (index == -1) {
            return;
        }
        if (this.tabListeners.length == 1) {
            this.tabListeners = new CTabFolderListener[0];
            return;
        }
        CTabFolderListener[] newTabListeners = new CTabFolderListener[this.tabListeners.length - 1];
        System.arraycopy(this.tabListeners, 0, newTabListeners, 0, index);
        System.arraycopy(this.tabListeners, index + 1, newTabListeners, index, this.tabListeners.length - index - 1);
        this.tabListeners = newTabListeners;
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener2);
        this.removeListener(14, listener2);
    }

    @Override
    public void reskin(int flags) {
        super.reskin(flags);
        int i2 = 0;
        while (i2 < this.items.length) {
            this.items[i2].reskin(flags);
            ++i2;
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.renderer.createAntialiasColors();
        this.updateBkImages();
        this.redraw();
    }

    public void setBackground(Color[] colors, int[] percents) {
        this.setBackground(colors, percents, false);
    }

    public void setBackground(Color[] colors, int[] percents, boolean vertical) {
        int i2;
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error(5);
            }
            i2 = 0;
            while (i2 < percents.length) {
                if (percents[i2] < 0 || percents[i2] > 100) {
                    SWT.error(5);
                }
                if (i2 > 0 && percents[i2] < percents[i2 - 1]) {
                    SWT.error(5);
                }
                ++i2;
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colors.length - 1]};
                percents = new int[]{};
            }
        }
        if (this.gradientColors != null && colors != null && this.gradientColors.length == colors.length) {
            boolean same = false;
            int i3 = 0;
            while (i3 < this.gradientColors.length) {
                same = this.gradientColors[i3] == null ? colors[i3] == null : this.gradientColors[i3].equals(colors[i3]);
                if (!same) break;
                ++i3;
            }
            if (same) {
                i3 = 0;
                while (i3 < this.gradientPercents.length) {
                    boolean bl = same = this.gradientPercents[i3] == percents[i3];
                    if (!same) break;
                    ++i3;
                }
            }
            if (same && this.gradientVertical == vertical) {
                return;
            }
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
            this.setBackground(null);
        } else {
            this.gradientColors = new Color[colors.length];
            i2 = 0;
            while (i2 < colors.length) {
                this.gradientColors[i2] = colors[i2];
                ++i2;
            }
            this.gradientPercents = new int[percents.length];
            i2 = 0;
            while (i2 < percents.length) {
                this.gradientPercents[i2] = percents[i2];
                ++i2;
            }
            this.gradientVertical = vertical;
            this.setBackground(this.gradientColors[this.gradientColors.length - 1]);
        }
        this.redraw();
    }

    @Override
    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        this.renderer.createAntialiasColors();
        this.redraw();
    }

    public void setBorderVisible(boolean show2) {
        this.checkWidget();
        if (this.borderVisible == show2) {
            return;
        }
        this.borderVisible = show2;
        this.updateFolder(2);
    }

    void setButtonBounds(GC gc) {
        int i2;
        Point size = this.getSize();
        Display display = this.getDisplay();
        if (this.showMax) {
            if (this.minMaxTb == null) {
                this.minMaxTb = new ToolBar(this, 0x800000);
                this.initAccessibleMinMaxTb();
                this.addTabControl(this.minMaxTb, 131072, 0, false);
            }
            if (this.maxItem == null) {
                this.maxItem = new ToolItem(this.minMaxTb, 8);
                if (this.maxImage == null) {
                    this.maxImage = this.createButtonImage(display, -5);
                }
                this.maxItem.setImage(this.maxImage);
                this.maxItem.setToolTipText(this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize"));
                this.maxItem.addListener(13, this.listener);
            }
        } else if (this.maxItem != null) {
            this.maxItem.dispose();
            this.maxItem = null;
        }
        if (this.showMin) {
            if (this.minMaxTb == null) {
                this.minMaxTb = new ToolBar(this, 0x800000);
                this.initAccessibleMinMaxTb();
                this.addTabControl(this.minMaxTb, 131072, 0, false);
            }
            if (this.minItem == null) {
                this.minItem = new ToolItem(this.minMaxTb, 8, 0);
                if (this.minImage == null) {
                    this.minImage = this.createButtonImage(display, -6);
                }
                this.minItem.setImage(this.minImage);
                this.minItem.setToolTipText(this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize"));
                this.minItem.addListener(13, this.listener);
            }
        } else if (this.minItem != null) {
            this.minItem.dispose();
            this.minItem = null;
        }
        if (this.minMaxTb != null && this.minMaxTb.getItemCount() == 0) {
            this.removeTabControl(this.minMaxTb, false);
            this.minMaxTb.dispose();
            this.minMaxTb = null;
        }
        if (this.showChevron) {
            int count;
            int itemCount = this.items.length;
            if (this.single) {
                count = this.selectedIndex == -1 ? itemCount : itemCount - 1;
            } else {
                int showCount = 0;
                while (showCount < this.priority.length && this.items[this.priority[showCount]].showing) {
                    ++showCount;
                }
                count = itemCount - showCount;
            }
            if (count != this.chevronCount) {
                this.chevronCount = count;
                if (this.chevronImage != null) {
                    this.chevronImage.dispose();
                }
                this.chevronImage = this.createButtonImage(display, -7);
                this.chevronItem.setImage(this.chevronImage);
            }
        }
        boolean[][] overflow = new boolean[1][0];
        Rectangle[] rects = this.computeControlBounds(size, overflow);
        if (this.fixedTabHeight != -1) {
            int height = this.fixedTabHeight;
            if (!this.hovering) {
                this.hoverTb = false;
                Rectangle tabBounds = this.getBounds();
                i2 = 0;
                while (i2 < rects.length) {
                    if (!overflow[0][i2] && rects[i2].height > height) {
                        this.hoverTb = true;
                        break;
                    }
                    ++i2;
                }
                if (this.hoverTb) {
                    i2 = 0;
                    while (i2 < rects.length) {
                        if (!overflow[0][i2] && rects[i2].height > height) {
                            rects[i2].x = tabBounds.width + 20;
                        }
                        ++i2;
                    }
                }
            }
        }
        int headerHeight = 0;
        int i3 = 0;
        while (i3 < rects.length) {
            if (!overflow[0][i3]) {
                headerHeight = Math.max(rects[i3].height, headerHeight);
            }
            ++i3;
        }
        boolean changed2 = false;
        this.ignoreResize = true;
        i2 = 0;
        while (i2 < this.controls.length) {
            if (!this.controls[i2].isDisposed()) {
                if (overflow[0][i2]) {
                    this.controls[i2].setBounds(rects[i2]);
                } else {
                    this.controls[i2].moveAbove(null);
                    this.controls[i2].setBounds(rects[i2].x, rects[i2].y, rects[i2].width, headerHeight);
                }
            }
            if (!changed2 && !rects[i2].equals(this.controlRects[i2])) {
                changed2 = true;
            }
            ++i2;
        }
        this.ignoreResize = false;
        this.controlRects = rects;
        if (changed2 || this.hovering) {
            this.updateBkImages();
        }
    }

    @Override
    public boolean setFocus() {
        CTabItem item2;
        this.checkWidget();
        Control focusControl = this.getDisplay().getFocusControl();
        boolean fixFocus = this.isAncestor(focusControl);
        if (fixFocus && (item2 = this.getSelection()) != null && item2.setFocus()) {
            return true;
        }
        return super.setFocus();
    }

    boolean isAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.getParent();
        }
        return control == this;
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        this.updateFolder(2);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
    }

    public void setInsertMark(CTabItem item2, boolean after) {
        this.checkWidget();
    }

    public void setInsertMark(int index, boolean after) {
        this.checkWidget();
        if (index < -1 || index >= this.getItemCount()) {
            SWT.error(5);
        }
    }

    boolean setItemLocation(GC gc) {
        boolean changed2 = false;
        if (this.items.length == 0) {
            return false;
        }
        Rectangle trim = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int borderBottom = trim.height + trim.y;
        int borderTop = -trim.y;
        Point size = this.getSize();
        int y = this.onBottom ? Math.max(borderBottom, size.y - borderBottom - this.tabHeight) : borderTop;
        Point closeButtonSize = this.renderer.computeSize(-8, 0, gc, -1, -1);
        int leftItemEdge = this.getLeftItemEdge(gc, -3);
        if (this.single) {
            int defaultX = this.getDisplay().getBounds().width + 10;
            int i2 = 0;
            while (i2 < this.items.length) {
                CTabItem item2 = this.items[i2];
                if (i2 == this.selectedIndex) {
                    this.firstIndex = this.selectedIndex;
                    int oldX = item2.x;
                    int oldY = item2.y;
                    item2.x = leftItemEdge;
                    item2.y = y;
                    item2.showing = true;
                    if (this.showClose || item2.showClose) {
                        item2.closeRect.x = leftItemEdge - this.renderer.computeTrim((int)i2, (int)0, (int)0, (int)0, (int)0, (int)0).x;
                        int n = item2.closeRect.y = this.onBottom ? size.y - borderBottom - this.tabHeight + (this.tabHeight - closeButtonSize.y) / 2 : borderTop + (this.tabHeight - closeButtonSize.y) / 2;
                    }
                    if (item2.x != oldX || item2.y != oldY) {
                        changed2 = true;
                    }
                } else {
                    item2.x = defaultX;
                    item2.showing = false;
                }
                ++i2;
            }
        } else {
            int rightItemEdge = this.getRightItemEdge(gc);
            int maxWidth = rightItemEdge - leftItemEdge;
            int width = 0;
            int i3 = 0;
            while (i3 < this.priority.length) {
                CTabItem item3 = this.items[this.priority[i3]];
                item3.showing = i3 == 0 ? true : item3.width > 0 && (width += item3.width) <= maxWidth;
                ++i3;
            }
            int x = this.getLeftItemEdge(gc, -2);
            int defaultX = this.getDisplay().getBounds().width + 10;
            this.firstIndex = this.items.length - 1;
            int i4 = 0;
            while (i4 < this.items.length) {
                CTabItem item4 = this.items[i4];
                if (!item4.showing) {
                    if (item4.x != defaultX) {
                        changed2 = true;
                    }
                    item4.x = defaultX;
                } else {
                    this.firstIndex = Math.min(this.firstIndex, i4);
                    if (item4.x != x || item4.y != y) {
                        changed2 = true;
                    }
                    item4.x = x;
                    item4.y = y;
                    int state = 0;
                    if (i4 == this.selectedIndex) {
                        state |= 2;
                    }
                    Rectangle edgeTrim = this.renderer.computeTrim(i4, state, 0, 0, 0, 0);
                    item4.closeRect.x = item4.x + item4.width - (edgeTrim.width + edgeTrim.x) - closeButtonSize.x;
                    item4.closeRect.y = this.onBottom ? size.y - borderBottom - this.tabHeight + (this.tabHeight - closeButtonSize.y) / 2 : borderTop + (this.tabHeight - closeButtonSize.y) / 2;
                    x += item4.width;
                    if (!this.simple && i4 == this.selectedIndex) {
                        x -= this.renderer.curveIndent;
                    }
                }
                ++i4;
            }
        }
        return changed2;
    }

    void setItemOrder(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error(4);
        }
        if (indices.length != this.items.length) {
            SWT.error(5);
        }
        int newSelectedIndex = -1;
        boolean[] seen = new boolean[this.items.length];
        CTabItem[] temp = new CTabItem[this.items.length];
        int i2 = 0;
        while (i2 < indices.length) {
            int index = indices[i2];
            if (index < 0 || index >= this.items.length) {
                SWT.error(5);
            }
            if (seen[index]) {
                SWT.error(5);
            }
            seen[index] = true;
            if (index == this.selectedIndex) {
                newSelectedIndex = i2;
            }
            temp[i2] = this.items[index];
            ++i2;
        }
        this.items = temp;
        this.selectedIndex = newSelectedIndex;
        this.updateFolder(2);
    }

    boolean setItemSize(GC gc) {
        int[] widths;
        boolean changed2 = false;
        if (this.isDisposed()) {
            return changed2;
        }
        Point size = this.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return changed2;
        }
        ToolBar chevron = this.getChevron();
        if (chevron != null) {
            chevron.setVisible(false);
        }
        this.showChevron = false;
        if (this.single) {
            boolean bl = this.showChevron = this.chevronVisible && this.items.length > 1;
            if (this.showChevron) {
                chevron.setVisible(true);
            }
            if (this.selectedIndex != -1) {
                CTabItem tab2 = this.items[this.selectedIndex];
                int width = this.renderer.computeSize((int)this.selectedIndex, (int)2, (GC)gc, (int)-1, (int)-1).x;
                width = Math.min(width, this.getRightItemEdge(gc) - this.getLeftItemEdge(gc, -3));
                if (tab2.height != this.tabHeight || tab2.width != width) {
                    changed2 = true;
                    tab2.shortenedText = null;
                    tab2.shortenedTextWidth = 0;
                    tab2.height = this.tabHeight;
                    tab2.width = width;
                    tab2.closeRect.height = 0;
                    tab2.closeRect.width = 0;
                    if (this.showClose || tab2.showClose) {
                        Point closeSize = this.renderer.computeSize(-8, 2, gc, -1, -1);
                        tab2.closeRect.width = closeSize.x;
                        tab2.closeRect.height = closeSize.y;
                    }
                }
            }
            return changed2;
        }
        if (this.items.length == 0) {
            return changed2;
        }
        int tabAreaWidth = Math.max(0, this.getRightItemEdge(gc) - this.getLeftItemEdge(gc, -3));
        int minWidth = 0;
        int[] minWidths = new int[this.items.length];
        int i2 = 0;
        while (i2 < this.priority.length) {
            int index = this.priority[i2];
            int state = 0x1000000;
            if (index == this.selectedIndex) {
                state |= 2;
            }
            minWidths[index] = this.renderer.computeSize((int)index, (int)state, (GC)gc, (int)-1, (int)-1).x;
            if ((minWidth += minWidths[index]) > tabAreaWidth) break;
            ++i2;
        }
        if (minWidth > tabAreaWidth) {
            int index;
            boolean bl = this.showChevron = this.chevronVisible && this.items.length > 1;
            if (this.showChevron) {
                tabAreaWidth -= chevron.computeSize((int)-1, (int)-1).x;
                chevron.setVisible(true);
            }
            widths = minWidths;
            int n = index = this.selectedIndex != -1 ? this.selectedIndex : 0;
            if (tabAreaWidth < widths[index]) {
                widths[index] = Math.max(0, tabAreaWidth);
            }
        } else {
            int maxWidth = 0;
            int[] maxWidths = new int[this.items.length];
            int i3 = 0;
            while (i3 < this.items.length) {
                int state = 0;
                if (i3 == this.selectedIndex) {
                    state |= 2;
                }
                maxWidths[i3] = this.renderer.computeSize((int)i3, (int)state, (GC)gc, (int)-1, (int)-1).x;
                maxWidth += maxWidths[i3];
                ++i3;
            }
            if (maxWidth <= tabAreaWidth) {
                widths = maxWidths;
            } else {
                int extra = (tabAreaWidth - minWidth) / this.items.length;
                while (true) {
                    int large = 0;
                    int totalWidth = 0;
                    int i4 = 0;
                    while (i4 < this.items.length) {
                        if (maxWidths[i4] > minWidths[i4] + extra) {
                            totalWidth += minWidths[i4] + extra;
                            ++large;
                        } else {
                            totalWidth += maxWidths[i4];
                        }
                        ++i4;
                    }
                    if (totalWidth >= tabAreaWidth) {
                        --extra;
                        break;
                    }
                    if (large == 0 || tabAreaWidth - totalWidth < large) break;
                    ++extra;
                }
                widths = new int[this.items.length];
                int i5 = 0;
                while (i5 < this.items.length) {
                    widths[i5] = Math.min(maxWidths[i5], minWidths[i5] + extra);
                    ++i5;
                }
            }
        }
        i2 = 0;
        while (i2 < this.items.length) {
            CTabItem tab3 = this.items[i2];
            int width = widths[i2];
            if (tab3.height != this.tabHeight || tab3.width != width) {
                changed2 = true;
                tab3.shortenedText = null;
                tab3.shortenedTextWidth = 0;
                tab3.height = this.tabHeight;
                tab3.width = width;
                tab3.closeRect.height = 0;
                tab3.closeRect.width = 0;
                if ((this.showClose || tab3.showClose) && (i2 == this.selectedIndex || this.showUnselectedClose)) {
                    Point closeSize = this.renderer.computeSize(-8, 0, gc, -1, -1);
                    tab3.closeRect.width = closeSize.x;
                    tab3.closeRect.height = closeSize.y;
                }
            }
            ++i2;
        }
        return changed2;
    }

    public void setMaximizeVisible(boolean visible) {
        this.checkWidget();
        if (this.showMax == visible) {
            return;
        }
        this.showMax = visible;
        this.updateFolder(10);
    }

    @Override
    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximized(boolean maximize) {
        this.checkWidget();
        if (this.maximized == maximize) {
            return;
        }
        if (maximize && this.minimized) {
            this.setMinimized(false);
        }
        this.maximized = maximize;
        if (this.minMaxTb != null && this.maxItem != null) {
            if (this.maxImage != null) {
                this.maxImage.dispose();
            }
            this.maxImage = this.createButtonImage(this.getDisplay(), -5);
            this.maxItem.setImage(this.maxImage);
            this.maxItem.setToolTipText(this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize"));
        }
    }

    public void setMinimizeVisible(boolean visible) {
        this.checkWidget();
        if (this.showMin == visible) {
            return;
        }
        this.showMin = visible;
        this.updateFolder(10);
    }

    public void setMinimized(boolean minimize) {
        this.checkWidget();
        if (this.minimized == minimize) {
            return;
        }
        if (minimize && this.maximized) {
            this.setMaximized(false);
        }
        this.minimized = minimize;
        if (this.minMaxTb != null && this.minItem != null) {
            if (this.minImage != null) {
                this.minImage.dispose();
            }
            this.minImage = this.createButtonImage(this.getDisplay(), -6);
            this.minItem.setImage(this.minImage);
            this.minItem.setToolTipText(this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize"));
        }
    }

    public void setMinimumCharacters(int count) {
        this.checkWidget();
        if (count < 0) {
            SWT.error(6);
        }
        if (this.minChars == count) {
            return;
        }
        this.minChars = count;
        this.updateFolder(4);
    }

    public void setMRUVisible(boolean show2) {
        this.checkWidget();
        if (this.mru == show2) {
            return;
        }
        this.mru = show2;
        if (!this.mru) {
            if (this.firstIndex == -1) {
                return;
            }
            int idx = this.firstIndex;
            int next = 0;
            int i2 = this.firstIndex;
            while (i2 < this.items.length) {
                this.priority[next++] = i2++;
            }
            i2 = 0;
            while (i2 < idx) {
                this.priority[next++] = i2++;
            }
            this.updateFolder(4);
        }
    }

    public void setRenderer(CTabFolderRenderer renderer) {
        this.checkWidget();
        if (this.renderer == renderer || this.useDefaultRenderer && renderer == null) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        boolean bl = this.useDefaultRenderer = renderer == null;
        if (this.useDefaultRenderer) {
            renderer = new CTabFolderRenderer(this);
        }
        this.renderer = renderer;
        this.updateFolder(2);
    }

    public void setSelection(CTabItem item2) {
        this.checkWidget();
        if (item2 == null) {
            SWT.error(4);
        }
        int index = this.indexOf(item2);
        this.setSelection(index);
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        CTabItem selection2 = this.items[index];
        if (this.selectedIndex == index) {
            this.showItem(selection2);
            return;
        }
        int oldIndex = this.selectedIndex;
        this.selectedIndex = index;
        if (oldIndex != -1) {
            this.items[oldIndex].closeImageState = 8;
            this.items[oldIndex].state &= 0xFFFFFFFD;
        }
        selection2.closeImageState = 0;
        selection2.showing = false;
        selection2.state |= 2;
        Control newControl = selection2.control;
        Control oldControl = null;
        if (oldIndex != -1) {
            oldControl = this.items[oldIndex].control;
        }
        if (newControl != oldControl) {
            if (newControl != null && !newControl.isDisposed()) {
                newControl.setBounds(this.getClientArea());
                newControl.setVisible(true);
            }
            if (oldControl != null && !oldControl.isDisposed()) {
                oldControl.setVisible(false);
            }
        }
        this.showItem(selection2);
        this.redraw();
    }

    void setSelection(int index, boolean notify) {
        int oldSelectedIndex = this.selectedIndex;
        this.setSelection(index);
        if (notify && this.selectedIndex != oldSelectedIndex && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    public void setSelectionBackground(Color color) {
        if (this.inDispose) {
            return;
        }
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        this.renderer.createAntialiasColors();
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Color[] colors, int[] percents) {
        this.setSelectionBackground(colors, percents, false);
    }

    public void setSelectionBackground(Color[] colors, int[] percents, boolean vertical) {
        int colorsLength;
        int i2;
        this.checkWidget();
        Color highlightBeginColor = null;
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1 && percents.length != colors.length - 2) {
                SWT.error(5);
            }
            i2 = 0;
            while (i2 < percents.length) {
                if (percents[i2] < 0 || percents[i2] > 100) {
                    SWT.error(5);
                }
                if (i2 > 0 && percents[i2] < percents[i2 - 1]) {
                    SWT.error(5);
                }
                ++i2;
            }
            if (percents.length == colors.length - 2) {
                highlightBeginColor = colors[colors.length - 1];
                colorsLength = colors.length - 1;
            } else {
                colorsLength = colors.length;
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colorsLength - 1]};
                colorsLength = colors.length;
                percents = new int[]{};
            }
        } else {
            colorsLength = 0;
        }
        if (this.selectionBgImage == null) {
            if (this.selectionGradientColors != null && colors != null && this.selectionGradientColors.length == colorsLength) {
                boolean same = false;
                int i3 = 0;
                while (i3 < this.selectionGradientColors.length) {
                    same = this.selectionGradientColors[i3] == null ? colors[i3] == null : this.selectionGradientColors[i3].equals(colors[i3]);
                    if (!same) break;
                    ++i3;
                }
                if (same) {
                    i3 = 0;
                    while (i3 < this.selectionGradientPercents.length) {
                        boolean bl = same = this.selectionGradientPercents[i3] == percents[i3];
                        if (!same) break;
                        ++i3;
                    }
                }
                if (same && this.selectionGradientVertical == vertical) {
                    return;
                }
            }
        } else {
            this.selectionBgImage = null;
        }
        if (colors == null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.selectionGradientVertical = false;
            this.setSelectionBackground((Color)null);
            this.setSelectionHighlightGradientColor(null);
        } else {
            this.selectionGradientColors = new Color[colorsLength];
            i2 = 0;
            while (i2 < colorsLength) {
                this.selectionGradientColors[i2] = colors[i2];
                ++i2;
            }
            this.selectionGradientPercents = new int[percents.length];
            i2 = 0;
            while (i2 < percents.length) {
                this.selectionGradientPercents[i2] = percents[i2];
                ++i2;
            }
            this.selectionGradientVertical = vertical;
            this.setSelectionBackground(this.selectionGradientColors[this.selectionGradientColors.length - 1]);
            this.setSelectionHighlightGradientColor(highlightBeginColor);
        }
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    void setSelectionHighlightGradientColor(Color start) {
        if (this.inDispose) {
            return;
        }
        this.renderer.setSelectionHighlightGradientColor(start);
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (image == this.selectionBgImage) {
            return;
        }
        if (image != null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.renderer.disposeSelectionHighlightGradientColors();
        }
        this.selectionBgImage = image;
        this.renderer.createAntialiasColors();
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(24);
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSimple(boolean simple) {
        this.checkWidget();
        if (this.simple != simple) {
            this.simple = simple;
            this.updateFolder(10);
        }
    }

    public void setSingle(boolean single) {
        this.checkWidget();
        if (this.single != single) {
            this.single = single;
            if (!single) {
                int i2 = 0;
                while (i2 < this.items.length) {
                    if (i2 != this.selectedIndex && this.items[i2].closeImageState == 0) {
                        this.items[i2].closeImageState = 8;
                    }
                    ++i2;
                }
            }
            this.updateFolder(2);
        }
    }

    int getControlY(Point size, Rectangle[] rects, int borderBottom, int borderTop, int i2) {
        int center2 = this.fixedTabHeight != -1 ? 0 : (this.tabHeight - rects[i2].height) / 2;
        return this.onBottom ? size.y - borderBottom - this.tabHeight + center2 : 1 + borderTop + center2;
    }

    public void setTabHeight(int height) {
        this.checkWidget();
        if (height < -1) {
            SWT.error(5);
        }
        this.fixedTabHeight = height;
        this.updateFolder(8);
    }

    public void setTabPosition(int position) {
        this.checkWidget();
        if (position != 128 && position != 1024) {
            SWT.error(5);
        }
        if (this.onBottom != (position == 1024)) {
            this.onBottom = position == 1024;
            this.updateFolder(2);
        }
    }

    public void setTopRight(Control control) {
        this.setTopRight(control, 131072);
    }

    public void setTopRight(Control control, int alignment) {
        this.checkWidget();
        if (alignment != 131072 && alignment != 4 && alignment != 131136) {
            SWT.error(5);
        }
        if (control != null && (control.isDisposed() || control.getParent() != this)) {
            SWT.error(5);
        }
        if (this.topRight == control && this.topRightAlignment == alignment) {
            return;
        }
        if (this.topRight != null && !this.topRight.isDisposed()) {
            this.removeTabControl(this.topRight, false);
        }
        this.topRight = control;
        this.topRightAlignment = alignment;
        alignment &= 0xFFFDFFFF;
        if (control != null) {
            this.addTabControl(control, 0x20000 | alignment, -1, false);
        }
        this.updateFolder(10);
    }

    public void setUnselectedCloseVisible(boolean visible) {
        this.checkWidget();
        if (this.showUnselectedClose == visible) {
            return;
        }
        this.showUnselectedClose = visible;
        this.updateFolder(2);
    }

    public void setUnselectedImageVisible(boolean visible) {
        this.checkWidget();
        if (this.showUnselectedImage == visible) {
            return;
        }
        this.showUnselectedImage = visible;
        this.updateFolder(2);
    }

    public void showItem(CTabItem item2) {
        int index;
        this.checkWidget();
        if (item2 == null) {
            SWT.error(4);
        }
        if (item2.isDisposed()) {
            SWT.error(5);
        }
        if ((index = this.indexOf(item2)) == -1) {
            SWT.error(5);
        }
        int idx = -1;
        int i2 = 0;
        while (i2 < this.priority.length) {
            if (this.priority[i2] == index) {
                idx = i2;
                break;
            }
            ++i2;
        }
        if (this.mru) {
            int[] newPriority = new int[this.priority.length];
            System.arraycopy(this.priority, 0, newPriority, 1, idx);
            System.arraycopy(this.priority, idx + 1, newPriority, idx + 1, this.priority.length - idx - 1);
            newPriority[0] = index;
            this.priority = newPriority;
        }
        if (item2.showing) {
            return;
        }
        this.updateFolder(4);
    }

    void showList(Rectangle rect) {
        if (this.items.length == 0 || !this.showChevron) {
            return;
        }
        if (this.showMenu == null || this.showMenu.isDisposed()) {
            this.showMenu = new Menu(this.getShell(), this.getStyle() & 0x6000000);
        } else {
            MenuItem[] items = this.showMenu.getItems();
            int i2 = 0;
            while (i2 < items.length) {
                items[i2].dispose();
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < this.items.length) {
            CTabItem tab2 = this.items[i3];
            if (!tab2.showing) {
                MenuItem item2 = new MenuItem(this.showMenu, 0);
                item2.setText(tab2.getText().replace("\n", " "));
                item2.setImage(tab2.getImage());
                item2.setData("CTabFolder_showList_Index", tab2);
                item2.addSelectionListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        MenuItem menuItem = (MenuItem)e.widget;
                        int index = CTabFolder.this.indexOf((CTabItem)menuItem.getData("CTabFolder_showList_Index"));
                        CTabFolder.this.setSelection(index, true);
                    }
                });
            }
            ++i3;
        }
        int x = rect.x;
        int y = rect.y + rect.height;
        Point location = this.getDisplay().map(this, null, x, y);
        this.showMenu.setLocation(location.x, location.y);
        this.showMenu.setVisible(true);
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    void _setToolTipText(int x, int y) {
        String oldTip = this.getToolTipText();
        String newTip = this._getToolTip(x, y);
        if (newTip == null || !newTip.equals(oldTip)) {
            this.setToolTipText(newTip);
        }
    }

    boolean updateItems() {
        return this.updateItems(this.selectedIndex);
    }

    boolean updateItems(int showIndex) {
        GC gc = new GC(this);
        if (!this.single && !this.mru && showIndex != -1) {
            int firstIndex = showIndex;
            if (this.priority[0] < showIndex) {
                int state;
                int maxWidth = this.getRightItemEdge(gc) - this.getLeftItemEdge(gc, -3);
                int width = 0;
                int[] widths = new int[this.items.length];
                int i2 = this.priority[0];
                while (i2 <= showIndex) {
                    state = 0x1000000;
                    if (i2 == this.selectedIndex) {
                        state |= 2;
                    }
                    widths[i2] = this.renderer.computeSize((int)i2, (int)state, (GC)gc, (int)-1, (int)-1).x;
                    if ((width += widths[i2]) > maxWidth) break;
                    ++i2;
                }
                if (width > maxWidth) {
                    width = 0;
                    i2 = showIndex;
                    while (i2 >= 0) {
                        state = 0x1000000;
                        if (i2 == this.selectedIndex) {
                            state |= 2;
                        }
                        if (widths[i2] == 0) {
                            widths[i2] = this.renderer.computeSize((int)i2, (int)state, (GC)gc, (int)-1, (int)-1).x;
                        }
                        if ((width += widths[i2]) <= maxWidth) {
                            firstIndex = i2--;
                            continue;
                        }
                        break;
                    }
                } else {
                    firstIndex = this.priority[0];
                    i2 = showIndex + 1;
                    while (i2 < this.items.length) {
                        state = 0x1000000;
                        if (i2 == this.selectedIndex) {
                            state |= 2;
                        }
                        widths[i2] = this.renderer.computeSize((int)i2, (int)state, (GC)gc, (int)-1, (int)-1).x;
                        if ((width += widths[i2]) >= maxWidth) break;
                        ++i2;
                    }
                    if (width < maxWidth) {
                        i2 = this.priority[0] - 1;
                        while (i2 >= 0) {
                            state = 0x1000000;
                            if (i2 == this.selectedIndex) {
                                state |= 2;
                            }
                            if (widths[i2] == 0) {
                                widths[i2] = this.renderer.computeSize((int)i2, (int)state, (GC)gc, (int)-1, (int)-1).x;
                            }
                            if ((width += widths[i2]) <= maxWidth) {
                                firstIndex = i2--;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (firstIndex != this.priority[0]) {
                int index = 0;
                int i3 = firstIndex;
                while (i3 < this.items.length) {
                    this.priority[index++] = i3++;
                }
                i3 = firstIndex - 1;
                while (i3 >= 0) {
                    this.priority[index++] = i3--;
                }
            }
        }
        boolean oldShowChevron = this.showChevron;
        boolean changed2 = this.setItemSize(gc);
        changed2 |= this.setItemLocation(gc);
        this.setButtonBounds(gc);
        if ((changed2 |= this.showChevron ^ oldShowChevron) && this.getToolTipText() != null) {
            Point pt = this.getDisplay().getCursorLocation();
            pt = this.toControl(pt);
            this._setToolTipText(pt.x, pt.y);
        }
        gc.dispose();
        return changed2;
    }

    boolean updateTabHeight(boolean force) {
        int oldHeight = this.tabHeight;
        GC gc = new GC(this);
        this.tabHeight = this.renderer.computeSize((int)-2, (int)0, (GC)gc, (int)-1, (int)-1).y;
        gc.dispose();
        if (this.fixedTabHeight == -1 && this.controls != null && this.controls.length > 0) {
            int i2 = 0;
            while (i2 < this.controls.length) {
                if ((this.controlAlignments[i2] & 0x40) == 0 && !this.controls[i2].isDisposed() && this.controls[i2].getVisible()) {
                    int topHeight = this.controls[i2].computeSize((int)-1, (int)-1).y;
                    this.tabHeight = Math.max(topHeight += this.renderer.computeTrim((int)-2, (int)0, (int)0, (int)0, (int)0, (int)0).height + 1, this.tabHeight);
                }
                ++i2;
            }
        }
        if (!force && this.tabHeight == oldHeight) {
            return false;
        }
        this.oldSize = null;
        return true;
    }

    void updateFolder(int flags) {
        this.updateFlags |= flags;
        if (this.updateRun != null) {
            return;
        }
        this.updateRun = () -> {
            this.updateRun = null;
            if (this.isDisposed()) {
                return;
            }
            this.runUpdate();
        };
        this.getDisplay().asyncExec(this.updateRun);
    }

    void runUpdate() {
        if (this.updateFlags == 0) {
            return;
        }
        int flags = this.updateFlags;
        this.updateFlags = 0;
        Rectangle rectBefore = this.getClientArea();
        this.updateTabHeight(false);
        this.updateItems(this.selectedIndex);
        if ((flags & 2) != 0) {
            this.redraw();
        } else if ((flags & 4) != 0) {
            this.redrawTabs();
        }
        Rectangle rectAfter = this.getClientArea();
        if (!rectBefore.equals(rectAfter)) {
            this.notifyListeners(11, new Event());
            this.layout();
        }
    }

    void updateBkImages() {
        if (this.controls != null && this.controls.length > 0) {
            int i2 = 0;
            while (i2 < this.controls.length) {
                Control control = this.controls[i2];
                if (!control.isDisposed()) {
                    if (this.hovering) {
                        if (control instanceof Composite) {
                            ((Composite)control).setBackgroundMode(0);
                        }
                        control.setBackgroundImage((Image)null);
                        control.setBackground(this.getBackground());
                    } else {
                        boolean wrapped;
                        if (control instanceof Composite) {
                            ((Composite)control).setBackgroundMode(1);
                        }
                        Rectangle bounds = control.getBounds();
                        int tabHeight = this.getTabHeight();
                        int height = this.getSize().y;
                        boolean bl = this.onBottom ? bounds.y + bounds.height < height - tabHeight : (wrapped = bounds.y > tabHeight);
                        if (wrapped || this.gradientColors == null) {
                            control.setBackgroundImage((Image)null);
                            control.setBackground(this.getBackground());
                        } else {
                            bounds.width = 10;
                            if (!this.onBottom) {
                                bounds.y = -bounds.y;
                                bounds.height -= 2 * bounds.y - 1;
                            } else {
                                bounds.height += height - (bounds.y + bounds.height);
                                bounds.y = -1;
                            }
                            bounds.x = 0;
                            if (this.controlBkImages[i2] != null) {
                                this.controlBkImages[i2].dispose();
                            }
                            this.controlBkImages[i2] = new Image((Device)control.getDisplay(), bounds);
                            GC gc = new GC(this.controlBkImages[i2]);
                            this.renderer.draw(-4, 0, bounds, gc);
                            gc.dispose();
                            control.setBackground(null);
                            control.setBackgroundImage(this.controlBkImages[i2]);
                        }
                    }
                }
                ++i2;
            }
        }
    }

    String _getToolTip(int x, int y) {
        CTabItem item2 = this.getItem(new Point(x, y));
        if (item2 == null) {
            return null;
        }
        if (!item2.showing) {
            return null;
        }
        if ((this.showClose || item2.showClose) && item2.closeRect.contains(x, y)) {
            return SWT.getMessage("SWT_Close");
        }
        return item2.getToolTipText();
    }

    void addTabControl(Control control, int flags) {
        this.checkWidget();
        this.addTabControl(control, flags, -1, true);
    }

    void addTabControl(Control control, int flags, int index, boolean update) {
        switch (flags) {
            case 16384: 
            case 131072: 
            case 131076: 
            case 131136: 
            case 131140: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        int i2 = 0;
        while (i2 < this.controls.length) {
            if (this.controls[i2] == control) {
                SWT.error(5);
            }
            ++i2;
        }
        int length = this.controls.length;
        control.addListener(11, this.listener);
        Control[] newControls = new Control[length + 1];
        System.arraycopy(this.controls, 0, newControls, 0, length);
        this.controls = newControls;
        int[] newAlignment = new int[length + 1];
        System.arraycopy(this.controlAlignments, 0, newAlignment, 0, length);
        this.controlAlignments = newAlignment;
        Rectangle[] newRect = new Rectangle[length + 1];
        System.arraycopy(this.controlRects, 0, newRect, 0, length);
        this.controlRects = newRect;
        Image[] newImage = new Image[length + 1];
        System.arraycopy(this.controlBkImages, 0, newImage, 0, length);
        this.controlBkImages = newImage;
        if (index == -1) {
            index = length;
            if (this.chevronTb != null && control != this.chevronTb) {
                --index;
            }
        }
        System.arraycopy(this.controls, index, this.controls, index + 1, length - index);
        System.arraycopy(this.controlAlignments, index, this.controlAlignments, index + 1, length - index);
        System.arraycopy(this.controlRects, index, this.controlRects, index + 1, length - index);
        System.arraycopy(this.controlBkImages, index, this.controlBkImages, index + 1, length - index);
        this.controls[index] = control;
        this.controlAlignments[index] = flags;
        this.controlRects[index] = new Rectangle(0, 0, 0, 0);
        if (update) {
            this.updateFolder(10);
        }
    }

    void removeTabControl(Control control) {
        this.checkWidget();
        this.removeTabControl(control, true);
    }

    void removeTabControl(Control control, boolean update) {
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        int index = -1;
        int i2 = 0;
        while (i2 < this.controls.length) {
            if (this.controls[i2] == control) {
                index = i2;
                break;
            }
            ++i2;
        }
        if (index == -1) {
            return;
        }
        if (!control.isDisposed()) {
            control.removeListener(11, this.listener);
            control.setBackground(null);
            control.setBackgroundImage((Image)null);
            if (control instanceof Composite) {
                ((Composite)control).setBackgroundMode(0);
            }
        }
        if (this.controlBkImages[index] != null && !this.controlBkImages[index].isDisposed()) {
            this.controlBkImages[index].dispose();
        }
        if (this.controls.length == 1) {
            this.controls = new Control[0];
            this.controlAlignments = new int[0];
            this.controlRects = new Rectangle[0];
            this.controlBkImages = new Image[0];
        } else {
            Control[] newControls = new Control[this.controls.length - 1];
            System.arraycopy(this.controls, 0, newControls, 0, index);
            System.arraycopy(this.controls, index + 1, newControls, index, this.controls.length - index - 1);
            this.controls = newControls;
            int[] newAlignments = new int[this.controls.length];
            System.arraycopy(this.controlAlignments, 0, newAlignments, 0, index);
            System.arraycopy(this.controlAlignments, index + 1, newAlignments, index, this.controls.length - index);
            this.controlAlignments = newAlignments;
            Rectangle[] newRects = new Rectangle[this.controls.length];
            System.arraycopy(this.controlRects, 0, newRects, 0, index);
            System.arraycopy(this.controlRects, index + 1, newRects, index, this.controls.length - index);
            this.controlRects = newRects;
            Image[] newBkImages = new Image[this.controls.length];
            System.arraycopy(this.controlBkImages, 0, newBkImages, 0, index);
            System.arraycopy(this.controlBkImages, index + 1, newBkImages, index, this.controls.length - index);
            this.controlBkImages = newBkImages;
        }
        if (update) {
            this.updateFolder(10);
        }
    }

    int getWrappedHeight(Point size) {
        boolean[][] positions = new boolean[1][];
        Rectangle[] rects = this.computeControlBounds(size, positions);
        int minY = Integer.MAX_VALUE;
        int maxY = 0;
        int wrapHeight = 0;
        int i2 = 0;
        while (i2 < rects.length) {
            if (positions[0][i2]) {
                minY = Math.min(minY, rects[i2].y);
                maxY = Math.max(maxY, rects[i2].y + rects[i2].height);
                wrapHeight = maxY - minY;
            }
            ++i2;
        }
        return wrapHeight;
    }

    void setChevronVisible(boolean visible) {
        this.checkWidget();
        if (this.chevronVisible == visible) {
            return;
        }
        this.chevronVisible = visible;
        this.updateFolder(10);
    }

    boolean shouldHighlight() {
        return this.highlight && this.highlightEnabled;
    }

    public void setHighlightEnabled(boolean enabled) {
        this.checkWidget();
        if (this.highlightEnabled == enabled) {
            return;
        }
        this.highlightEnabled = enabled;
        this.updateFolder(2);
    }

    public boolean getHighlightEnabled() {
        this.checkWidget();
        return this.highlightEnabled;
    }
}

