/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.linear.AbstractFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.util.OpenIntToFieldHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T> {
    private final OpenIntToFieldHashMap<T> entries;
    private final int rows;
    private final int columns;

    public SparseFieldMatrix(Field<T> field2) {
        super(field2);
        this.rows = 0;
        this.columns = 0;
        this.entries = new OpenIntToFieldHashMap<T>(field2);
    }

    public SparseFieldMatrix(Field<T> field2, int rowDimension, int columnDimension) {
        super(field2, rowDimension, columnDimension);
        this.rows = rowDimension;
        this.columns = columnDimension;
        this.entries = new OpenIntToFieldHashMap<T>(field2);
    }

    public SparseFieldMatrix(SparseFieldMatrix<T> other) {
        super(other.getField(), other.getRowDimension(), other.getColumnDimension());
        this.rows = other.getRowDimension();
        this.columns = other.getColumnDimension();
        this.entries = new OpenIntToFieldHashMap<T>(other.entries);
    }

    public SparseFieldMatrix(FieldMatrix<T> other) {
        super(other.getField(), other.getRowDimension(), other.getColumnDimension());
        this.rows = other.getRowDimension();
        this.columns = other.getColumnDimension();
        this.entries = new OpenIntToFieldHashMap(this.getField());
        for (int i2 = 0; i2 < this.rows; ++i2) {
            for (int j = 0; j < this.columns; ++j) {
                this.setEntry(i2, j, other.getEntry(i2, j));
            }
        }
    }

    @Override
    public void addToEntry(int row2, int column2, T increment) {
        this.checkRowIndex(row2);
        this.checkColumnIndex(column2);
        int key2 = this.computeKey(row2, column2);
        FieldElement value = (FieldElement)this.entries.get(key2).add(increment);
        if (((FieldElement)this.getField().getZero()).equals(value)) {
            this.entries.remove(key2);
        } else {
            this.entries.put(key2, value);
        }
    }

    @Override
    public FieldMatrix<T> copy() {
        return new SparseFieldMatrix<T>(this);
    }

    @Override
    public FieldMatrix<T> createMatrix(int rowDimension, int columnDimension) {
        return new SparseFieldMatrix(this.getField(), rowDimension, columnDimension);
    }

    @Override
    public int getColumnDimension() {
        return this.columns;
    }

    @Override
    public T getEntry(int row2, int column2) {
        this.checkRowIndex(row2);
        this.checkColumnIndex(column2);
        return this.entries.get(this.computeKey(row2, column2));
    }

    @Override
    public int getRowDimension() {
        return this.rows;
    }

    @Override
    public void multiplyEntry(int row2, int column2, T factor) {
        this.checkRowIndex(row2);
        this.checkColumnIndex(column2);
        int key2 = this.computeKey(row2, column2);
        FieldElement value = (FieldElement)this.entries.get(key2).multiply(factor);
        if (((FieldElement)this.getField().getZero()).equals(value)) {
            this.entries.remove(key2);
        } else {
            this.entries.put(key2, value);
        }
    }

    @Override
    public void setEntry(int row2, int column2, T value) {
        this.checkRowIndex(row2);
        this.checkColumnIndex(column2);
        if (((FieldElement)this.getField().getZero()).equals(value)) {
            this.entries.remove(this.computeKey(row2, column2));
        } else {
            this.entries.put(this.computeKey(row2, column2), value);
        }
    }

    private int computeKey(int row2, int column2) {
        return row2 * this.columns + column2;
    }
}

