/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class LogKitLogger
implements Log,
Serializable {
    private static final long serialVersionUID = 3768538055836059519L;
    protected volatile transient Logger logger = null;
    protected String name = null;

    public LogKitLogger(String name) {
        this.name = name;
        this.logger = this.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger() {
        Logger result2 = this.logger;
        if (result2 == null) {
            LogKitLogger logKitLogger = this;
            synchronized (logKitLogger) {
                result2 = this.logger;
                if (result2 == null) {
                    this.logger = result2 = Hierarchy.getDefaultHierarchy().getLoggerFor(this.name);
                }
            }
        }
        return result2;
    }

    public void trace(Object message2) {
        this.debug(message2);
    }

    public void trace(Object message2, Throwable t) {
        this.debug(message2, t);
    }

    public void debug(Object message2) {
        if (message2 != null) {
            this.getLogger().debug(String.valueOf(message2));
        }
    }

    public void debug(Object message2, Throwable t) {
        if (message2 != null) {
            this.getLogger().debug(String.valueOf(message2), t);
        }
    }

    public void info(Object message2) {
        if (message2 != null) {
            this.getLogger().info(String.valueOf(message2));
        }
    }

    public void info(Object message2, Throwable t) {
        if (message2 != null) {
            this.getLogger().info(String.valueOf(message2), t);
        }
    }

    public void warn(Object message2) {
        if (message2 != null) {
            this.getLogger().warn(String.valueOf(message2));
        }
    }

    public void warn(Object message2, Throwable t) {
        if (message2 != null) {
            this.getLogger().warn(String.valueOf(message2), t);
        }
    }

    public void error(Object message2) {
        if (message2 != null) {
            this.getLogger().error(String.valueOf(message2));
        }
    }

    public void error(Object message2, Throwable t) {
        if (message2 != null) {
            this.getLogger().error(String.valueOf(message2), t);
        }
    }

    public void fatal(Object message2) {
        if (message2 != null) {
            this.getLogger().fatalError(String.valueOf(message2));
        }
    }

    public void fatal(Object message2, Throwable t) {
        if (message2 != null) {
            this.getLogger().fatalError(String.valueOf(message2), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isFatalErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }
}

