/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.annotation.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;

public class CollapsedStringAdapter
extends XmlAdapter<String, String> {
    @Override
    public String unmarshal(String text2) {
        int s;
        if (text2 == null) {
            return null;
        }
        int len = text2.length();
        for (s = 0; s < len && !CollapsedStringAdapter.isWhiteSpace(text2.charAt(s)); ++s) {
        }
        if (s == len) {
            return text2;
        }
        StringBuilder result2 = new StringBuilder(len);
        if (s != 0) {
            for (int i2 = 0; i2 < s; ++i2) {
                result2.append(text2.charAt(i2));
            }
            result2.append(' ');
        }
        boolean inStripMode = true;
        for (int i3 = s + 1; i3 < len; ++i3) {
            char ch = text2.charAt(i3);
            boolean b = CollapsedStringAdapter.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            if (inStripMode) {
                result2.append(' ');
                continue;
            }
            result2.append(ch);
        }
        len = result2.length();
        if (len > 0 && result2.charAt(len - 1) == ' ') {
            result2.setLength(len - 1);
        }
        return result2.toString();
    }

    @Override
    public String marshal(String s) {
        return s;
    }

    protected static boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }
}

