/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.log.Logger;
import freemarker.template.utility.StringUtil;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class SecurityUtilities {
    private static final Logger LOG = Logger.getLogger("freemarker.security");

    private SecurityUtilities() {
    }

    public static String getSystemProperty(final String key2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(key2);
            }
        });
    }

    public static String getSystemProperty(final String key2, final String defValue) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(key2, defValue);
                }
            });
        }
        catch (AccessControlException e) {
            LOG.warn("Insufficient permissions to read system property " + StringUtil.jQuoteNoXSS(key2) + ", using default value " + StringUtil.jQuoteNoXSS(defValue));
            return defValue;
        }
    }

    public static Integer getSystemProperty(final String key2, final int defValue) {
        try {
            return (Integer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Integer.getInteger(key2, defValue);
                }
            });
        }
        catch (AccessControlException e) {
            LOG.warn("Insufficient permissions to read system property " + StringUtil.jQuote(key2) + ", using default value " + defValue);
            return defValue;
        }
    }
}

