/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltInWithParseTimeParameters;
import freemarker.core.Environment;
import freemarker.core.EvalUtil;
import freemarker.core.Expression;
import freemarker.core.ParseException;
import freemarker.core.Token;
import freemarker.core._MiscTemplateException;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.util.ArrayList;
import java.util.List;

final class BuiltInsWithParseTimeParameters {
    private BuiltInsWithParseTimeParameters() {
    }

    static class switch_BI
    extends BuiltInWithParseTimeParameters {
        private List parameters;

        switch_BI() {
        }

        void bindToParameters(List parameters2, Token openParen, Token closeParen) throws ParseException {
            if (parameters2.size() < 2) {
                throw this.newArgumentCountException("must have at least 2", openParen, closeParen);
            }
            this.parameters = parameters2;
        }

        protected List getArgumentsAsList() {
            return this.parameters;
        }

        protected int getArgumentsCount() {
            return this.parameters.size();
        }

        protected Expression getArgumentParameterValue(int argIdx) {
            return (Expression)this.parameters.get(argIdx);
        }

        protected void cloneArguments(Expression clone, String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
            ArrayList<Expression> parametersClone = new ArrayList<Expression>(this.parameters.size());
            for (int i2 = 0; i2 < this.parameters.size(); ++i2) {
                parametersClone.add(((Expression)this.parameters.get(i2)).deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
            }
            ((switch_BI)clone).parameters = parametersClone;
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel targetValue = this.target.evalToNonMissing(env);
            List parameters2 = this.parameters;
            int paramCnt = parameters2.size();
            int i2 = 0;
            while (i2 + 1 < paramCnt) {
                Expression caseExp = (Expression)parameters2.get(i2);
                TemplateModel caseValue = caseExp.evalToNonMissing(env);
                if (EvalUtil.compare(targetValue, this.target, 1, "==", caseValue, caseExp, this, true, false, false, false, env)) {
                    return ((Expression)parameters2.get(i2 + 1)).evalToNonMissing(env);
                }
                i2 += 2;
            }
            if (paramCnt % 2 == 0) {
                throw new _MiscTemplateException(this.target, "The value before ?", this.key, "(case1, value1, case2, value2, ...) didn't match any of the case parameters, and there was no default value parameter (an additional last parameter) eithter. ");
            }
            return ((Expression)parameters2.get(paramCnt - 1)).evalToNonMissing(env);
        }
    }

    static class then_BI
    extends BuiltInWithParseTimeParameters {
        private Expression whenTrueExp;
        private Expression whenFalseExp;

        then_BI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            boolean lho = this.target.evalToBoolean(env);
            return (lho ? this.whenTrueExp : this.whenFalseExp).evalToNonMissing(env);
        }

        void bindToParameters(List parameters2, Token openParen, Token closeParen) throws ParseException {
            if (parameters2.size() != 2) {
                throw this.newArgumentCountException("requires exactly 2", openParen, closeParen);
            }
            this.whenTrueExp = (Expression)parameters2.get(0);
            this.whenFalseExp = (Expression)parameters2.get(1);
        }

        protected Expression getArgumentParameterValue(int argIdx) {
            switch (argIdx) {
                case 0: {
                    return this.whenTrueExp;
                }
                case 1: {
                    return this.whenFalseExp;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        protected int getArgumentsCount() {
            return 2;
        }

        protected List getArgumentsAsList() {
            ArrayList<Expression> args = new ArrayList<Expression>(2);
            args.add(this.whenTrueExp);
            args.add(this.whenFalseExp);
            return args;
        }

        protected void cloneArguments(Expression cloneExp, String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
            then_BI clone = (then_BI)cloneExp;
            clone.whenTrueExp = this.whenTrueExp.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState);
            clone.whenFalseExp = this.whenFalseExp.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState);
        }
    }
}

