/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.mdlviewer.swt;

import de.treichels.hott.model.Curve;
import de.treichels.hott.model.CurvePoint;
import de.treichels.hott.report.html.CurveImageGenerator;
import de.treichels.hott.util.Util;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.NotNull;

public class SwtCurveImageGenerator
implements CurveImageGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getImage(Curve curve, double scale2, boolean description2) {
        Image image;
        boolean pitchCurve = curve.getPoint().get(0).getPosition() == 0;
        Resource g = null;
        try {
            int y0;
            int x0;
            image = new Image((Device)Display.getDefault(), (int)(10.0 + 200.0 * scale2), (int)(10.0 + 250.0 * scale2));
            g = new GC(image);
            ((GC)g).setAntialias(1);
            ((GC)g).setTextAntialias(1);
            ((GC)g).setBackground(Display.getDefault().getSystemColor(1));
            ((GC)g).fillRectangle(0, 0, (int)(10.0 + 200.0 * scale2), (int)(10.0 + 250.0 * scale2));
            ((GC)g).setForeground(Display.getDefault().getSystemColor(2));
            ((GC)g).setLineWidth(1);
            ((GC)g).drawRectangle(5, 5, (int)(200.0 * scale2), (int)(250.0 * scale2));
            ((GC)g).setForeground(Display.getDefault().getSystemColor(15));
            ((GC)g).drawLine(5, (int)(5.0 + 25.0 * scale2), (int)(5.0 + 200.0 * scale2), (int)(5.0 + 25.0 * scale2));
            ((GC)g).drawLine(5, (int)(5.0 + 225.0 * scale2), (int)(5.0 + 200.0 * scale2), (int)(5.0 + 225.0 * scale2));
            ((GC)g).drawLine(5, (int)(5.0 + 125.0 * scale2), (int)(5.0 + 200.0 * scale2), (int)(5.0 + 125.0 * scale2));
            if (!pitchCurve) {
                ((GC)g).drawLine((int)(5.0 + 100.0 * scale2), 5, (int)(5.0 + 100.0 * scale2), (int)(5.0 + 250.0 * scale2));
            }
            ((GC)g).setFont(new Font((Device)Display.getDefault(), new FontData("Arial", 10, 1)));
            ((GC)g).setForeground(Display.getDefault().getSystemColor(2));
            int numPoints = 0;
            for (CurvePoint p : curve.getPoint()) {
                if (!p.isEnabled()) continue;
                ++numPoints;
            }
            double[] xVals = new double[numPoints];
            double[] yVals = new double[numPoints];
            int i2 = 0;
            for (CurvePoint p : curve.getPoint()) {
                if (!p.isEnabled()) continue;
                xVals[i2] = i2 == 0 ? (pitchCurve ? 0.0 : -100.0) : (i2 == numPoints - 1 ? 100.0 : (double)p.getPosition());
                yVals[i2] = p.getValue();
                if (description2) {
                    if (pitchCurve) {
                        x0 = (int)(5.0 + xVals[i2] * 2.0 * scale2);
                        y0 = (int)(5.0 + (225.0 - yVals[i2] * 2.0) * scale2);
                    } else {
                        x0 = (int)(5.0 + (100.0 + xVals[i2]) * scale2);
                        y0 = (int)(5.0 + (125.0 - yVals[i2]) * scale2);
                    }
                    ((GC)g).setBackground(Display.getDefault().getSystemColor(2));
                    ((GC)g).fillOval(x0 - 3, y0 - 3, 6, 6);
                    ((GC)g).setBackground(Display.getDefault().getSystemColor(1));
                    ((GC)g).fillRectangle(x0 - 5, y0 + 3, 9, 13);
                    ((GC)g).drawText(Integer.toString(p.getNumber() + 1), x0 - 4, y0 + 2, true);
                }
                ++i2;
            }
            ((GC)g).setLineWidth(2);
            if (numPoints > 2 && curve.isSmoothing()) {
                SplineInterpolator s = new SplineInterpolator();
                PolynomialSplineFunction function = s.interpolate(xVals, yVals);
                x0 = 5;
                y0 = pitchCurve ? (int)(5.0 + (225.0 - yVals[0] * 2.0) * scale2) : (int)(5.0 + (125.0 - yVals[0]) * scale2);
                while (x0 < (int)(4.0 + 200.0 * scale2)) {
                    int x1 = x0 + 1;
                    int y1 = pitchCurve ? (int)(5.0 + (225.0 - function.value((double)(x1 - 5) / scale2 / 2.0) * 2.0) * scale2) : (int)(5.0 + (125.0 - function.value((double)(x1 - 5) / scale2 - 100.0)) * scale2);
                    ((GC)g).drawLine(x0, y0, x1, y1);
                    x0 = x1;
                    y0 = y1;
                }
            } else {
                for (i2 = 0; i2 < numPoints - 1; ++i2) {
                    int y1;
                    int x1;
                    int y02;
                    int x02;
                    if (pitchCurve) {
                        x02 = (int)(5.0 + xVals[i2] * 2.0 * scale2);
                        y02 = (int)(5.0 + (225.0 - yVals[i2] * 2.0) * scale2);
                        x1 = (int)(5.0 + xVals[i2 + 1] * 2.0 * scale2);
                        y1 = (int)(5.0 + (225.0 - yVals[i2 + 1] * 2.0) * scale2);
                    } else {
                        x02 = (int)(5.0 + (100.0 + xVals[i2]) * scale2);
                        y02 = (int)(5.0 + (125.0 - yVals[i2]) * scale2);
                        x1 = (int)(5.0 + (100.0 + xVals[i2 + 1]) * scale2);
                        y1 = (int)(5.0 + (125.0 - yVals[i2 + 1]) * scale2);
                    }
                    ((GC)g).drawLine(x02, y02, x1, y1);
                }
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return image;
    }

    @Override
    @NotNull
    public String getImageSource(@NotNull Curve curve, double scale2, boolean description2) {
        ByteArrayOutputStream baos;
        block2: {
            Image image = this.getImage(curve, scale2, description2);
            baos = new ByteArrayOutputStream();
            ImageLoader imageLoader = new ImageLoader();
            try {
                imageLoader.data = new ImageData[]{image.getImageData()};
                imageLoader.save(baos, 5);
            }
            catch (Exception e) {
                if (!Util.INSTANCE.getDEBUG()) break block2;
                e.printStackTrace();
            }
        }
        return "data:image/png;base64," + Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

