/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.io;

import de.treichels.hott.decoder.internal.decoder.BaseDecoder;
import de.treichels.hott.decoder.internal.io.CRC16;
import de.treichels.hott.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u000b2\b\b\u0002\u0010\u001a\u001a\u00020\u000bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010\u001e\u001a\u00020\u000bJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000bJ\u0006\u0010%\u001a\u00020\u000bJ\u0006\u0010&\u001a\u00020 J\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020\u0017J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u000bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lde/treichels/hott/decoder/internal/io/HoTTReader;", "", "data", "", "([B)V", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "_crc", "Lde/treichels/hott/decoder/internal/io/CRC16;", "crc", "", "getCrc", "()I", "level", "logger", "Ljava/util/logging/Logger;", "<set-?>", "offset", "getOffset", "setOffset", "(I)V", "read", "", "buffer", "off", "len", "readBoolean", "", "readByte", "readInt", "readLong", "", "readShort", "readString", "", "length", "readUnsignedByte", "readUnsignedInt", "readUnsignedShort", "resetCRC", "skip", "n", "HoTT-Decoder"})
public final class HoTTReader {
    private int level;
    private final Logger logger;
    private final CRC16 _crc;
    private int offset;
    private final InputStream inputStream;

    public final int getCrc() {
        return this._crc.getValue();
    }

    public final int getOffset() {
        return this.offset;
    }

    private final void setOffset(int n) {
        this.offset = n;
    }

    /*
     * WARNING - void declaration
     */
    public final void read(@NotNull byte[] buffer, int off, int len) {
        int b;
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        int n = this.level;
        this.level = n + 1;
        int o = this.offset;
        if (off < 0 || len < 0 || len > buffer.length - off) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int n2 = off;
        int n3 = off + len;
        while (n2 < n3 && (b = this.readUnsignedByte()) != -1) {
            void i2;
            buffer[i2] = (byte)b;
            ++i2;
        }
        HoTTReader hoTTReader = this;
        hoTTReader.level += -1;
        if (hoTTReader.level == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "read(%d)@0x%04X:\n%s";
            Object[] objectArray = new Object[]{len, o, Util.dumpData$default(Util.INSTANCE, buffer, 0, 2, null)};
            Logger logger = this.logger;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.finest(string4);
        }
    }

    public static /* synthetic */ void read$default(HoTTReader hoTTReader, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        hoTTReader.read(byArray, n, n2);
    }

    public final boolean readBoolean() {
        boolean bl;
        int n = this.level;
        this.level = n + 1;
        int o = this.offset;
        boolean $receiver = bl = this.readByte() != 0;
        HoTTReader hoTTReader = this;
        hoTTReader.level += -1;
        if (hoTTReader.level == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "readBoolean@0x%04X: %s";
            Object[] objectArray = new Object[]{o, String.valueOf($receiver)};
            Logger logger = this.logger;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.finest(string4);
        }
        return bl;
    }

    public final int readByte() {
        byte by;
        int n = this.level;
        this.level = n + 1;
        int o = this.offset;
        byte $receiver = by = (byte)this.readUnsignedByte();
        HoTTReader hoTTReader = this;
        hoTTReader.level += -1;
        if (hoTTReader.level == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "readByte@0x%04X: 0x%02X (%d)";
            Object[] objectArray = new Object[]{o, (int)$receiver, (int)$receiver};
            Logger logger = this.logger;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.finest(string4);
        }
        return by;
    }

    public final int readInt() {
        int n;
        int n2 = this.level;
        this.level = n2 + 1;
        int o = this.offset;
        int $receiver = n = (int)this.readUnsignedInt();
        HoTTReader hoTTReader = this;
        hoTTReader.level += -1;
        if (hoTTReader.level == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "readInt@0x%04X: 0x%08X (%d)";
            Object[] objectArray = new Object[]{o, $receiver, $receiver};
            Logger logger = this.logger;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.finest(string4);
        }
        return n;
    }

    public final long readLong() {
        long l;
        int n = this.level;
        this.level = n + 1;
        int o = this.offset;
        long $receiver = l = this.readUnsignedInt() + (this.readUnsignedInt() << 32);
        HoTTReader hoTTReader = this;
        hoTTReader.level += -1;
        if (hoTTReader.level == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "readUnsignedInt@0x%04X: 0x%016X (%d)";
            Object[] objectArray = new Object[]{o, $receiver, $receiver};
            Logger logger = this.logger;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.finest(string4);
        }
        return l;
    }

    public final int readShort() {
        short s;
        int n = this.level;
        this.level = n + 1;
        int o = this.offset;
        short $receiver = s = (short)this.readUnsignedShort();
        HoTTReader hoTTReader = this;
        hoTTReader.level += -1;
        if (hoTTReader.level == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "readUnsignedShort@0x%04X: 0x%04X (%d)";
            Object[] objectArray = new Object[]{o, (int)$receiver, (int)$receiver};
            Logger logger = this.logger;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.finest(string4);
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readString(int length) {
        void $receiver$iv;
        int n = this.level;
        this.level = n + 1;
        int o = this.offset;
        byte[] bytes = new byte[length];
        HoTTReader.read$default(this, bytes, 0, 0, 6, null);
        Object object = BaseDecoder.Companion.getISO_8859_1();
        object = new String(bytes, (Charset)object);
        CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            char c;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char c2 = c = $receiver$iv$iv.charAt(index$iv$iv);
            boolean bl = match$iv$iv = Character.isISOControl(c2) || CharsKt.isWhitespace(c);
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        Object $receiver = object = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        HoTTReader hoTTReader = this;
        hoTTReader.level += -1;
        if (hoTTReader.level == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "readString@0x%04X: %s";
            Object[] objectArray = new Object[]{o, $receiver};
            Logger logger = this.logger;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.finest(string4);
        }
        return object;
    }

    public final int readUnsignedByte() {
        int n = this.level;
        this.level = n + 1;
        int o = this.offset;
        int result2 = this.inputStream.read();
        this._crc.update((byte)result2);
        int n2 = this.offset;
        this.offset = n2 + 1;
        int $receiver = n2 = result2;
        HoTTReader hoTTReader = this;
        hoTTReader.level += -1;
        if (hoTTReader.level == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "readUnsignedByte@0x%04X: 0x%02X (%d)";
            Object[] objectArray = new Object[]{o, $receiver, $receiver};
            Logger logger = this.logger;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.finest(string4);
        }
        return n2;
    }

    public final long readUnsignedInt() {
        long l;
        int n = this.level;
        this.level = n + 1;
        int o = this.offset;
        long $receiver = l = (long)this.readUnsignedShort() + ((long)this.readUnsignedShort() << 16);
        HoTTReader hoTTReader = this;
        hoTTReader.level += -1;
        if (hoTTReader.level == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "readUnsignedInt@0x%04X: 0x%08X (%d)";
            Object[] objectArray = new Object[]{o, $receiver, $receiver};
            Logger logger = this.logger;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.finest(string4);
        }
        return l;
    }

    public final int readUnsignedShort() {
        int n;
        int n2 = this.level;
        this.level = n2 + 1;
        int o = this.offset;
        int $receiver = n = this.readUnsignedByte() + (this.readUnsignedByte() << 8);
        HoTTReader hoTTReader = this;
        hoTTReader.level += -1;
        if (hoTTReader.level == 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "readUnsignedShort@0x%04X: 0x%04X (%d)";
            Object[] objectArray = new Object[]{o, $receiver, $receiver};
            Logger logger = this.logger;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.finest(string4);
        }
        return n;
    }

    public final void resetCRC() {
        this._crc.reset();
    }

    public final void skip(int n) {
        int count = n;
        while (count-- > 0) {
            this.readByte();
        }
    }

    public HoTTReader(@NotNull InputStream inputStream2) {
        Intrinsics.checkParameterIsNotNull(inputStream2, "inputStream");
        this.inputStream = inputStream2;
        Logger logger = Logger.getLogger(this.getClass().getName());
        Intrinsics.checkExpressionValueIsNotNull(logger, "Logger.getLogger(javaClass.name)");
        this.logger = logger;
        this._crc = new CRC16();
    }

    public HoTTReader(@NotNull byte[] data2) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        this(new ByteArrayInputStream(data2));
    }
}

