/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.commands;

import de.treichels.hott.decoder.internal.commands.BaseCommand;
import de.treichels.hott.decoder.internal.commands.BaseResponse;
import de.treichels.hott.decoder.internal.commands.PCMD;
import de.treichels.hott.decoder.internal.io.HoTTReader;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lde/treichels/hott/decoder/internal/commands/ADPCMReadFileInfo;", "Lde/treichels/hott/decoder/internal/commands/BaseCommand;", "index", "", "user", "", "(IZ)V", "getIndex", "()I", "response", "Lde/treichels/hott/decoder/internal/commands/ADPCMReadFileInfo$Response;", "getResponse", "()Lde/treichels/hott/decoder/internal/commands/ADPCMReadFileInfo$Response;", "Response", "HoTT-Decoder"})
public final class ADPCMReadFileInfo
extends BaseCommand {
    @NotNull
    private final Response response;
    private final int index;

    @Override
    @NotNull
    public Response getResponse() {
        return this.response;
    }

    public final int getIndex() {
        return this.index;
    }

    public ADPCMReadFileInfo(int index, boolean user) {
        super(user ? PCMD.ADPCM_USER_RD_INFO : PCMD.ADPCM_SYS_RD_INFO, 4);
        this.index = index;
        this.getWriter().writeInt(this.index);
        this.response = new Response();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\b\u00a8\u0006\u001e"}, d2={"Lde/treichels/hott/decoder/internal/commands/ADPCMReadFileInfo$Response;", "Lde/treichels/hott/decoder/internal/commands/BaseResponse;", "()V", "baseAddress", "", "getBaseAddress", "()I", "setBaseAddress", "(I)V", "index", "getIndex", "setIndex", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "reverseIndex", "getReverseIndex", "setReverseIndex", "sampleRate", "getSampleRate", "setSampleRate", "size", "getSize", "setSize", "dumpData", "initData", "", "HoTT-Decoder"})
    public static final class Response
    extends BaseResponse {
        private int size;
        private int baseAddress;
        private int index;
        private int reverseIndex;
        private int sampleRate;
        @NotNull
        private String name = "";

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            this.size = n;
        }

        public final int getBaseAddress() {
            return this.baseAddress;
        }

        public final void setBaseAddress(int n) {
            this.baseAddress = n;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final int getReverseIndex() {
            return this.reverseIndex;
        }

        public final void setReverseIndex(int n) {
            this.reverseIndex = n;
        }

        public final int getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(int n) {
            this.sampleRate = n;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull(string2, "<set-?>");
            this.name = string2;
        }

        @Override
        protected void initData() {
            if (this.getData().length == 32) {
                HoTTReader hoTTReader;
                HoTTReader $receiver = hoTTReader = this.getReader();
                this.size = $receiver.readInt();
                this.baseAddress = $receiver.readInt();
                this.index = $receiver.readShort();
                this.reverseIndex = $receiver.readShort();
                this.sampleRate = $receiver.readShort();
                this.name = $receiver.readString(18);
            }
        }

        @Override
        @NotNull
        public String dumpData() {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "[size=0x%04x, baseAddress=0x%05x, index=%d/%d, sampleRate=%d, name=%s]";
            Object[] objectArray = new Object[]{this.size, this.baseAddress, this.index, this.reverseIndex, this.sampleRate, this.name};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
            return string3;
        }
    }
}

