/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.async;

import com.sun.javafx.runtime.async.AbstractAsyncOperation;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractRemoteResource<T>
extends AbstractAsyncOperation<T> {
    protected final String url;
    protected final String method;
    protected final String outboundContent;
    protected int fileSize;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();

    protected AbstractRemoteResource(String string2, AsyncOperationListener<T> asyncOperationListener) {
        this(string2, "GET", asyncOperationListener);
    }

    protected AbstractRemoteResource(String string2, String string3, AsyncOperationListener<T> asyncOperationListener) {
        this(string2, string3, null, asyncOperationListener);
    }

    protected AbstractRemoteResource(String string2, String string3, String string4, AsyncOperationListener<T> asyncOperationListener) {
        super(asyncOperationListener);
        this.url = string2;
        this.method = string3;
        this.outboundContent = string4;
    }

    protected abstract T processStream(InputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws IOException {
        URLConnection uRLConnection;
        URL uRL = new URL(this.url);
        ProgressInputStream progressInputStream = null;
        String string2 = uRL.getProtocol();
        if (string2.equals("http") || string2.equals("https")) {
            uRLConnection = (HttpURLConnection)uRL.openConnection();
            ((HttpURLConnection)uRLConnection).setRequestMethod(this.method);
            uRLConnection.setDoInput(true);
            for (Map.Entry<String, String> object : this.headers.entrySet()) {
                String string3 = object.getKey();
                String string4 = object.getValue();
                if (string4 == null || string4.equals("")) continue;
                uRLConnection.setRequestProperty(string3, string4);
            }
            if (this.outboundContent != null && this.method.equals("POST")) {
                uRLConnection.setDoOutput(true);
                Object object2 = this.outboundContent.getBytes("utf-8");
                uRLConnection.setRequestProperty("Content-Length", String.valueOf(((Object)object2).length));
                OutputStream outputStream = uRLConnection.getOutputStream();
                outputStream.write((byte[])object2);
                outputStream.close();
            }
            uRLConnection.connect();
            this.fileSize = uRLConnection.getContentLength();
            this.setProgressMax(this.fileSize);
            this.responseHeaders = uRLConnection.getHeaderFields();
            progressInputStream = new ProgressInputStream(uRLConnection.getInputStream());
        } else {
            uRLConnection = uRL.openConnection();
            this.setProgressMax(uRLConnection.getContentLength());
            progressInputStream = new ProgressInputStream(uRLConnection.getInputStream());
        }
        try {
            uRLConnection = this.processStream(progressInputStream);
            return (T)uRLConnection;
        }
        finally {
            ((InputStream)progressInputStream).close();
        }
    }

    public void setHeader(String string2, String string3) {
        this.headers.put(string2, string3);
    }

    public String getResponseHeader(String string2) {
        String string3 = null;
        List<String> list2 = this.responseHeaders.get(string2);
        if (list2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                stringBuilder.append((Object)iterator2.next());
                if (!iterator2.hasNext()) continue;
                stringBuilder.append(',');
            }
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    protected class ProgressInputStream
    extends BufferedInputStream {
        public ProgressInputStream(InputStream inputStream2) {
            super(inputStream2);
        }

        @Override
        public synchronized int read() throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int n = super.read();
            AbstractRemoteResource.this.addProgress(1);
            return n;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int n3 = super.read(byArray, n, n2);
            AbstractRemoteResource.this.addProgress(n3);
            return n3;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int n = super.read(byArray);
            AbstractRemoteResource.this.addProgress(n);
            return n;
        }
    }
}

