/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ElementObserver;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.collections.WeakListChangeListener;
import javafx.util.Callback;

public final class ElementObservableListDecorator<E>
extends ObservableListBase<E>
implements ObservableList<E> {
    private final ObservableList<E> decoratedList;
    private final ListChangeListener<E> listener;
    private ElementObserver<E> observer;

    public ElementObservableListDecorator(ObservableList<E> observableList, Callback<E, Observable[]> callback) {
        this.observer = new ElementObserver<E>(callback, new Callback<E, InvalidationListener>(){

            public InvalidationListener call(final E e) {
                return new InvalidationListener(){

                    public void invalidated(Observable observable2) {
                        int n;
                        ElementObservableListDecorator.this.beginChange();
                        if (ElementObservableListDecorator.this.decoratedList instanceof RandomAccess) {
                            int n2 = ElementObservableListDecorator.this.size();
                            for (n = 0; n < n2; ++n) {
                                if (ElementObservableListDecorator.this.get(n) != e) continue;
                                ElementObservableListDecorator.this.nextUpdate(n);
                            }
                        } else {
                            Iterator iterator2 = ElementObservableListDecorator.this.iterator();
                            while (iterator2.hasNext()) {
                                if (iterator2.next() == e) {
                                    ElementObservableListDecorator.this.nextUpdate(n);
                                }
                                ++n;
                            }
                        }
                        ElementObservableListDecorator.this.endChange();
                    }
                };
            }
        }, this);
        this.decoratedList = observableList;
        int n = this.decoratedList.size();
        for (int j = 0; j < n; ++j) {
            this.observer.attachListener(this.decoratedList.get(j));
        }
        this.listener = new ListChangeListener<E>(){

            public void onChanged(ListChangeListener.Change<? extends E> change) {
                while (change.next()) {
                    int n;
                    if (!change.wasAdded() && !change.wasRemoved()) continue;
                    int n2 = change.getRemovedSize();
                    List list2 = change.getRemoved();
                    for (n = 0; n < n2; ++n) {
                        ElementObservableListDecorator.this.observer.detachListener(list2.get(n));
                    }
                    if (ElementObservableListDecorator.this.decoratedList instanceof RandomAccess) {
                        n = change.getTo();
                        for (int j = change.getFrom(); j < n; ++j) {
                            ElementObservableListDecorator.this.observer.attachListener(ElementObservableListDecorator.this.decoratedList.get(j));
                        }
                        continue;
                    }
                    for (Object e : change.getAddedSubList()) {
                        ElementObservableListDecorator.this.observer.attachListener(e);
                    }
                }
                change.reset();
                ElementObservableListDecorator.this.fireChange(change);
            }
        };
        this.decoratedList.addListener((ListChangeListener)new WeakListChangeListener(this.listener));
    }

    public <T> T[] toArray(T[] TArray) {
        return this.decoratedList.toArray((Object[])TArray);
    }

    public Object[] toArray() {
        return this.decoratedList.toArray();
    }

    public List<E> subList(int n, int n2) {
        return this.decoratedList.subList(n, n2);
    }

    public int size() {
        return this.decoratedList.size();
    }

    public E set(int n, E e) {
        return (E)this.decoratedList.set(n, e);
    }

    public boolean retainAll(Collection<?> collection) {
        return this.decoratedList.retainAll(collection);
    }

    public boolean removeAll(Collection<?> collection) {
        return this.decoratedList.removeAll(collection);
    }

    public E remove(int n) {
        return (E)this.decoratedList.remove(n);
    }

    public boolean remove(Object object) {
        return this.decoratedList.remove(object);
    }

    public ListIterator<E> listIterator(int n) {
        return this.decoratedList.listIterator(n);
    }

    public ListIterator<E> listIterator() {
        return this.decoratedList.listIterator();
    }

    public int lastIndexOf(Object object) {
        return this.decoratedList.lastIndexOf(object);
    }

    public Iterator<E> iterator() {
        return this.decoratedList.iterator();
    }

    public boolean isEmpty() {
        return this.decoratedList.isEmpty();
    }

    public int indexOf(Object object) {
        return this.decoratedList.indexOf(object);
    }

    public E get(int n) {
        return (E)this.decoratedList.get(n);
    }

    public boolean containsAll(Collection<?> collection) {
        return this.decoratedList.containsAll(collection);
    }

    public boolean contains(Object object) {
        return this.decoratedList.contains(object);
    }

    public void clear() {
        this.decoratedList.clear();
    }

    public boolean addAll(int n, Collection<? extends E> collection) {
        return this.decoratedList.addAll(n, collection);
    }

    public boolean addAll(Collection<? extends E> collection) {
        return this.decoratedList.addAll(collection);
    }

    public void add(int n, E e) {
        this.decoratedList.add(n, e);
    }

    public boolean add(E e) {
        return this.decoratedList.add(e);
    }

    public boolean setAll(Collection<? extends E> collection) {
        return this.decoratedList.setAll(collection);
    }

    public boolean setAll(E ... EArray) {
        return this.decoratedList.setAll((Object[])EArray);
    }

    public boolean retainAll(E ... EArray) {
        return this.decoratedList.retainAll((Object[])EArray);
    }

    public boolean removeAll(E ... EArray) {
        return this.decoratedList.removeAll((Object[])EArray);
    }

    public void remove(int n, int n2) {
        this.decoratedList.remove(n, n2);
    }

    public boolean addAll(E ... EArray) {
        return this.decoratedList.addAll((Object[])EArray);
    }
}

