/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.List;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.factories.RomanNumberFactory;

public class RomanList
extends List {
    public RomanList() {
        super(true);
    }

    public RomanList(int symbolIndent) {
        super(true, symbolIndent);
    }

    public RomanList(boolean lowercase, int symbolIndent) {
        super(true, symbolIndent);
        this.lowercase = lowercase;
    }

    public boolean add(Element o) {
        if (o instanceof ListItem) {
            ListItem item2 = (ListItem)o;
            Chunk chunk = new Chunk(this.preSymbol, this.symbol.getFont());
            chunk.setAttributes(this.symbol.getAttributes());
            chunk.append(RomanNumberFactory.getString(this.first + this.list.size(), this.lowercase));
            chunk.append(this.postSymbol);
            item2.setListSymbol(chunk);
            item2.setIndentationLeft(this.symbolIndent, this.autoindent);
            item2.setIndentationRight(0.0f);
            this.list.add(item2);
        } else if (o instanceof List) {
            List nested = (List)o;
            nested.setIndentationLeft(nested.getIndentationLeft() + this.symbolIndent);
            --this.first;
            return this.list.add(nested);
        }
        return false;
    }

    public List cloneShallow() {
        RomanList clone = new RomanList();
        this.populateProperties(clone);
        return clone;
    }
}

