/*
 * Decompiled with CFR 0.152.
 */
package gde.device.renschler;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Logger;

public class Picolario2LogReader {
    static Logger log = Logger.getLogger(Picolario2LogReader.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordSet read(String filePath, IDevice device, String recordNameExtend, Integer channelConfigNumber) {
        RecordSet recordSet;
        block39: {
            Channel activeChannel = null;
            int lineNumber = 0;
            String recordSetNameExtend = device.getRecordSetStemNameReplacement();
            recordSet = null;
            FilterInputStream data_in = null;
            int[] points = new int[device.getNumberOfMeasurements(1)];
            String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new File(filePath).lastModified());
            boolean isOutdated = false;
            MenuToolBar menuToolBar = application.getMenuToolBar();
            GDE.getUiNotification().setProgress(0);
            GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT1251") + filePath);
            try {
                int i;
                activeChannel = channelConfigNumber == null ? channels.getActiveChannel() : (Channel)channels.get((Object)channelConfigNumber);
                channelConfigNumber = channels.getActiveChannelNumber();
                if (activeChannel == null) break block39;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, device.getChannelCount() + " - data for channel = " + channelConfigNumber);
                }
                String recordSetName = activeChannel.size() + 1 + recordSetNameExtend;
                recordSetName = recordNameExtend.length() > 2 ? recordSetName + " [" + recordNameExtend + "]" : recordSetName;
                long startTime = System.nanoTime() / 1000000L;
                File file = new File(filePath);
                FileInputStream file_input = new FileInputStream(file);
                data_in = new DataInputStream(file_input);
                long fileSize = file.length();
                long numReads = 0L;
                byte[] buffer = new byte[4];
                ((DataInputStream)data_in).read(buffer);
                String firmware = String.format("%.1f", (double)DataParser.parse2Int((byte[])buffer, (int)0) / 10.0);
                fileSize -= 4L;
                ((DataInputStream)data_in).read(buffer);
                double dataRate = (buffer[buffer.length - 1] & 0x80) == 0 ? 25.0 : 30.303030303030305;
                int numValues = 0;
                for (int i2 = 0; i2 < buffer.length - 1; ++i2) {
                    byte tmpByte = buffer[i2];
                    for (int j = 0; j < 8; ++j) {
                        if ((tmpByte & 1) == 0) continue;
                        ++numValues;
                        tmpByte = (byte)(tmpByte >> 1);
                    }
                }
                log.log(Level.FINE, String.format("firmware version = %s; number of values = %d", firmware, numValues));
                int[] startValues = new int[numValues + 1];
                fileSize -= 4L;
                buffer = new byte[4];
                ((DataInputStream)data_in).read(buffer);
                points[1] = startValues[1] = DataParser.parse2Int((byte[])buffer, (int)0) * 1000;
                startValues[0] = points[0] = (int)(44330.0 * (1.0 - Math.pow((double)points[1] / 100000.0 / 1013.25, 0.19138755980861244)) * 1000.0);
                buffer = new byte[2];
                ((DataInputStream)data_in).read(buffer);
                points[2] = startValues[2] = DataParser.parse2Short((byte[])buffer, (int)0) * 1000;
                log.log(Level.FINE, String.format("start pressure = %d; start voltage = %d", startValues[1] / 1000, startValues[2] / 1000));
                fileSize -= 4L;
                recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)channelConfigNumber, (boolean)true, (boolean)true, (boolean)true);
                activeChannel.put((Object)recordSetName, (Object)recordSet);
                recordSet = (RecordSet)activeChannel.get((Object)recordSetName);
                recordSet.setRecordSetDescription(recordSet.getRecordSetDescription() + String.format("\nFirmware : %s", firmware));
                try {
                    isOutdated = Integer.parseInt(dateTime.split("-")[0]) <= 2000;
                }
                catch (Exception tmpByte) {
                    // empty catch block
                }
                if (!isOutdated) {
                    long startTimeStamp = (long)((double)new File(filePath).lastModified() - recordSet.getMaxTime_ms());
                    recordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                    recordSet.setStartTimeStamp(startTimeStamp);
                    activeChannel.setFileDescription((String)(application.isObjectoriented() ? dateTime + " " + application.getObjectKey() : dateTime));
                } else {
                    recordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new Date()));
                }
                if (GDE.isWithUi()) {
                    activeChannel.applyTemplate(recordSetName, false);
                }
                numReads = fileSize / (long)numValues;
                buffer = new byte[numValues];
                double timeStamp_ms = 0.0;
                int integrationSize = 15;
                Vector<Integer[]> values = new Vector<Integer[]>(integrationSize);
                for (i = 0; i < integrationSize / 2; ++i) {
                    values.add(new Integer[]{0, startValues[1]});
                }
                for (int j = 0; j < integrationSize / 2 + 1 && ((DataInputStream)data_in).read(buffer) > 0; ++j) {
                    Integer[] valuePoints = new Integer[numValues + 1];
                    for (int i3 = 2; i3 <= buffer.length; ++i3) {
                        int n = i3;
                        int n2 = points[n] + buffer[i3 - 1] * 1000;
                        points[n] = n2;
                        valuePoints[i3] = n2;
                    }
                    points[1] = points[1] + buffer[0] * 1000;
                    valuePoints[1] = points[1];
                    valuePoints[0] = valuePoints[1];
                    values.add(valuePoints);
                }
                do {
                    for (i = 2; i <= buffer.length; ++i) {
                        points[i] = ((Integer[])values.get(integrationSize / 2 + 1))[i];
                    }
                    points[1] = 0;
                    for (i = 0; i < values.size(); ++i) {
                        if (i == integrationSize / 2 + 1) continue;
                        points[1] = points[1] + ((Integer[])values.get(i))[1] / (integrationSize - 1);
                    }
                    points[0] = (int)(44330.0 * (1.0 - Math.pow((double)points[1] / 100000.0 / 1013.25, 0.19138755980861244)) * 1000.0);
                    Integer[] valuePoints = new Integer[numValues + 1];
                    for (int i4 = 2; i4 <= buffer.length; ++i4) {
                        valuePoints[i4] = ((Integer[])values.lastElement())[i4] + buffer[i4 - 1] * 1000;
                    }
                    valuePoints[1] = ((Integer[])values.lastElement())[1] + buffer[0] * 1000;
                    valuePoints[0] = valuePoints[1];
                    values.add(valuePoints);
                    values.remove(0);
                    recordSet.addPoints(points, timeStamp_ms);
                    timeStamp_ms += dataRate;
                    if (fileSize % 100L == 0L) {
                        GDE.getUiNotification().setProgress((int)(100L - fileSize / (long)numValues * 100L / numReads));
                    }
                    fileSize -= (long)numValues;
                } while (((DataInputStream)data_in).read(buffer) > 0);
                data_in.close();
                data_in = null;
                GDE.getUiNotification().setProgress(100);
                if (GDE.isWithUi()) {
                    Channels.getInstance().switchChannel(activeChannel.getName());
                    activeChannel.switchRecordSet(recordSetName);
                    device.updateVisibilityStatus(recordSet, true);
                    menuToolBar.updateChannelSelector();
                    menuToolBar.updateRecordSetSelectCombo();
                }
                recordSet.descriptionAppendFilename(filePath.substring(filePath.lastIndexOf(47) + 1));
                log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            }
            catch (FileNotFoundException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                application.openMessageDialog(e.getMessage());
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                application.openMessageDialog(e.getMessage());
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                if (activeChannel != null && activeChannel.size() > 0) {
                    String recordSetName = activeChannel.getFirstRecordSetName();
                    activeChannel.setActiveRecordSet(recordSetName);
                    device.updateVisibilityStatus((RecordSet)activeChannel.get((Object)recordSetName), true);
                    ((RecordSet)activeChannel.get((Object)recordSetName)).checkAllDisplayable();
                    if (GDE.isWithUi()) {
                        activeChannel.switchRecordSet(recordSetName);
                    }
                }
                String msg = filePath + " - " + Messages.getString((String)"GDE_MSGE0045", (Object[])new Object[]{e.getMessage(), lineNumber});
                log.log(Level.WARNING, msg, e);
                application.openMessageDialog(msg);
            }
            finally {
                if (data_in != null) {
                    try {
                        data_in.close();
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, e.getMessage());
                    }
                    data_in = null;
                }
                GDE.getUiNotification().setStatusMessage("");
            }
        }
        return recordSet;
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
    }
}

